/*
 * Decompiled with CFR 0.152.
 */
package org.opendope.conditions;

import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlID;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.CollapsedStringAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.docx4j.XmlUtils;
import org.docx4j.model.datastorage.DomToXPathMap;
import org.docx4j.model.datastorage.OpenDoPEHandler;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.CustomXmlPart;
import org.opendope.conditions.And;
import org.opendope.conditions.Evaluable;
import org.opendope.conditions.Not;
import org.opendope.conditions.Or;
import org.opendope.conditions.Xpathref;
import org.opendope.xpaths.Xpaths;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="", propOrder={"particle"})
@XmlRootElement(name="condition")
public class Condition
implements Evaluable {
    private static Logger log = LoggerFactory.getLogger(Condition.class);
    @XmlElements(value={@XmlElement(name="xpathref", type=Xpathref.class), @XmlElement(name="and", type=And.class), @XmlElement(name="or", type=Or.class), @XmlElement(name="not", type=Not.class)})
    protected Evaluable particle;
    @XmlAttribute(name="id", required=true)
    @XmlJavaTypeAdapter(value=CollapsedStringAdapter.class)
    @XmlID
    @XmlSchemaType(name="ID")
    protected String id;
    @XmlAttribute(name="name")
    protected String name;
    @XmlAttribute(name="description")
    protected String description;
    @XmlAttribute(name="comments")
    protected String comments;
    @XmlAttribute(name="source")
    protected String source;
    @XmlTransient
    private DomToXPathMap domToXPathMap = null;

    public Evaluable getParticle() {
        return this.particle;
    }

    public void setParticle(Evaluable value) {
        this.particle = value;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean evaluate(WordprocessingMLPackage pkg, Map<String, CustomXmlPart> customXmlDataStorageParts, Map<String, Condition> conditionsMap, Map<String, Xpaths.Xpath> xpathsMap) {
        String path;
        if (!OpenDoPEHandler.ENABLE_XPATH_CACHE) return this.particle.evaluate(pkg, customXmlDataStorageParts, conditionsMap, xpathsMap);
        if (this.domToXPathMap == null) return this.particle.evaluate(pkg, customXmlDataStorageParts, conditionsMap, xpathsMap);
        if (!(this.particle instanceof Xpathref)) return this.particle.evaluate(pkg, customXmlDataStorageParts, conditionsMap, xpathsMap);
        Xpathref xpRef = (Xpathref)this.particle;
        String xpath = xpRef.toString(conditionsMap, xpathsMap);
        if (xpath.startsWith("string")) {
            String path2;
            String tmpPath = xpath.replace("][1]", "]");
            if (!tmpPath.startsWith("string(" + (path2 = this.extractPath(tmpPath)) + ")='")) return this.particle.evaluate(pkg, customXmlDataStorageParts, conditionsMap, xpathsMap);
            String val = this.domToXPathMap.getPathMap().get(path2);
            if (val == null) {
                log.info("Couldn't find " + val + " in domToXPathMap path map; reverting to default handling");
                return this.particle.evaluate(pkg, customXmlDataStorageParts, conditionsMap, xpathsMap);
            }
            boolean result = tmpPath.equals("string(" + path2 + ")='" + val + "'");
            if (!result) {
                result = tmpPath.equals("string(" + path2 + ")='" + val.trim() + "'");
            }
            if (!log.isDebugEnabled()) return result;
            boolean tmpCheck = this.particle.evaluate(pkg, customXmlDataStorageParts, conditionsMap, xpathsMap);
            if (result == tmpCheck) {
                return result;
            }
            String message = "PANIC! Manual string calc doesn't match XPath eval!\n" + xpath + "\nstring(" + path2 + ")='" + val + "'\n";
            log.error(message);
            throw new RuntimeException(message);
        }
        if (!xpath.startsWith("count")) return this.particle.evaluate(pkg, customXmlDataStorageParts, conditionsMap, xpathsMap);
        String tmpPath = xpath.replace("][1]", "]");
        if (!tmpPath.equals("count(" + (path = this.extractPath(tmpPath)) + ")>0")) {
            log.debug("No manual count eval coded for: " + tmpPath);
            return this.particle.evaluate(pkg, customXmlDataStorageParts, conditionsMap, xpathsMap);
        }
        log.debug("XPATH_CACHE >0 case handling " + path);
        String[] segments = path.split("/");
        StringBuffer sb = new StringBuffer();
        for (int x = 0; x < segments.length; ++x) {
            if (!"".equals(segments[x])) {
                if (segments[x].endsWith("]")) {
                    sb.append(segments[x]);
                } else {
                    sb.append(segments[x] + "[1]");
                }
            }
            if (x >= segments.length - 1) continue;
            sb.append("/");
        }
        path = sb.toString();
        Integer val = this.domToXPathMap.getCountMap().get(path);
        if (val == null) {
            val = this.domToXPathMap.getCountMap().get("_all_" + path);
        } else if (log.isDebugEnabled()) {
            log.debug("countMap result " + val);
        }
        if (val == null) {
            if (!log.isDebugEnabled()) return false;
            log.warn("log.isDebugEnabled()-specific code path; results may vary");
            boolean tmpCheck = this.particle.evaluate(pkg, customXmlDataStorageParts, conditionsMap, xpathsMap);
            if (tmpCheck) {
                String message = "FIXME.  Expected map entry facilitating manual eval of  " + path;
                log.error(message);
                throw new RuntimeException(message);
            }
            System.out.println("Manual count calc worked for null case");
            return tmpCheck;
        }
        boolean result = val != null;
        if (!log.isDebugEnabled()) return result;
        boolean tmpCheck = this.particle.evaluate(pkg, customXmlDataStorageParts, conditionsMap, xpathsMap);
        if (result == tmpCheck) {
            log.debug("Manual count calc worked");
            return result;
        }
        String message = "PANIC! Manual count calc doesn't match XPath eval!\n" + xpath + "\ncount(" + path + ")>0\n" + val;
        log.error(message);
        throw new RuntimeException(message);
    }

    private String extractPath(String xpath) {
        int firstBracket = xpath.indexOf("(");
        int lastBracket = xpath.indexOf(")");
        try {
            return xpath.substring(firstBracket + 1, lastBracket);
        }
        catch (StringIndexOutOfBoundsException e) {
            log.error(xpath + ".substring(" + firstBracket + "1, " + lastBracket + ")");
            throw e;
        }
    }

    public void setDomToXPathMap(DomToXPathMap domToXPathMap) {
        this.domToXPathMap = domToXPathMap;
    }

    @Override
    public void listXPaths(List<Xpaths.Xpath> theList, Map<String, Condition> conditionsMap, Map<String, Xpaths.Xpath> xpathsMap) {
        this.particle.listXPaths(theList, conditionsMap, xpathsMap);
    }

    @Override
    public void mapIds(Map<String, String> xpathIdMap, Map<String, String> conditionIdMap) {
        this.particle.mapIds(xpathIdMap, conditionIdMap);
    }

    @Override
    public String toString(Map<String, Condition> conditionsMap, Map<String, Xpaths.Xpath> xpathsMap) {
        return this.particle.toString(conditionsMap, xpathsMap);
    }

    @Override
    public Condition repeat(String xpathBase, int index, Map<String, Condition> conditionsMap, Map<String, Xpaths.Xpath> xpathsMap) {
        Condition newCondition;
        if (this.getParticle() instanceof Xpathref) {
            newCondition = new Condition();
            Xpathref xpathref = new Xpathref();
            xpathref.setId(((Xpathref)this.getParticle()).getId());
            newCondition.setParticle(xpathref);
        } else if (this.getParticle() instanceof Not && ((Not)this.getParticle()).getParticle() instanceof Xpathref) {
            newCondition = new Condition();
            Not notParticle = new Not();
            newCondition.setParticle(notParticle);
            Xpathref xpathref = new Xpathref();
            xpathref.setId(((Xpathref)((Not)this.getParticle()).getParticle()).getId());
            notParticle.setParticle(xpathref);
        } else {
            newCondition = XmlUtils.deepCopy(this);
        }
        String newConditionId = this.id + "_" + index;
        newCondition.setId(newConditionId);
        Condition preExistingSanity = conditionsMap.put(newCondition.getId(), newCondition);
        if (preExistingSanity != null) {
            String newC;
            String preExisting = XmlUtils.marshaltoString(preExistingSanity);
            if (preExisting.equals(newC = XmlUtils.marshaltoString(newCondition))) {
                log.debug("Duplicate identical Condition being added: " + newCondition.getId());
            } else {
                log.error("Duplicate Condition " + newCondition.getId() + ": \n" + newC + " overwriting \n" + preExisting);
            }
        }
        newCondition.getParticle().repeat(xpathBase, index, conditionsMap, xpathsMap);
        return newCondition;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String value) {
        this.id = value;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String value) {
        this.name = value;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String value) {
        this.description = value;
    }

    public String getComments() {
        return this.comments;
    }

    public void setComments(String value) {
        this.comments = value;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String value) {
        this.source = value;
    }
}

