/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.convert.out.common.preprocess;

import javax.xml.transform.TransformerException;
import org.docx4j.TraversalUtil;
import org.docx4j.convert.out.common.ConversionSectionWrapper;
import org.docx4j.convert.out.common.preprocess.PageNumberInformation;
import org.docx4j.model.fields.FldSimpleModel;
import org.docx4j.model.fields.FormattingSwitchHelper;
import org.docx4j.model.structure.HeaderFooterPolicy;
import org.docx4j.openpackaging.parts.WordprocessingML.FooterPart;
import org.docx4j.openpackaging.parts.WordprocessingML.HeaderPart;
import org.docx4j.utils.TraversalUtilVisitor;
import org.docx4j.wml.CTSimpleField;

public class PageNumberInformationCollector {
    public static PageNumberInformation process(ConversionSectionWrapper sectionWrapper, boolean dummyPageNumbering) {
        PageNumberInformation ret = new PageNumberInformation(sectionWrapper.getSectPr());
        FieldVisitor fldVisitor = null;
        HeaderFooterPolicy headerFooterPolicy = sectionWrapper.getHeaderFooterPolicy();
        if (!dummyPageNumbering) {
            fldVisitor = new FieldVisitor(ret);
            TraversalUtil.visit(sectionWrapper.getContent(), fldVisitor);
            PageNumberInformationCollector.process(headerFooterPolicy.getFirstHeader(), fldVisitor);
            PageNumberInformationCollector.process(headerFooterPolicy.getFirstFooter(), fldVisitor);
            PageNumberInformationCollector.process(headerFooterPolicy.getDefaultHeader(), fldVisitor);
            PageNumberInformationCollector.process(headerFooterPolicy.getDefaultFooter(), fldVisitor);
            PageNumberInformationCollector.process(headerFooterPolicy.getEvenHeader(), fldVisitor);
            PageNumberInformationCollector.process(headerFooterPolicy.getEvenFooter(), fldVisitor);
        }
        return ret;
    }

    protected static void process(FooterPart footer, FieldVisitor fldVisitor) {
        if (footer != null && !footer.getContent().isEmpty()) {
            TraversalUtil.visit(footer.getContent(), fldVisitor);
        }
    }

    protected static void process(HeaderPart header, FieldVisitor fldVisitor) {
        if (header != null && !header.getContent().isEmpty()) {
            TraversalUtil.visit(header.getContent(), fldVisitor);
        }
    }

    protected static class FieldVisitor
    extends TraversalUtilVisitor<CTSimpleField> {
        private static final Object PAGE_FIELD_TYPE = "PAGE";
        private static final Object NUMPAGES_FIELD_TYPE = "NUMPAGES";
        private static final Object SECTIONPAGES_FIELD_TYPE = "SECTIONPAGES";
        protected PageNumberInformation results = null;
        protected FldSimpleModel fldSimpleModel = new FldSimpleModel();

        public FieldVisitor(PageNumberInformation results) {
            this.results = results;
        }

        @Override
        public void apply(CTSimpleField element) {
            String instr = element.getInstr();
            String fieldType = FormattingSwitchHelper.getFldSimpleName(instr);
            if (PAGE_FIELD_TYPE.equals(fieldType)) {
                this.results.setPagePresent(true);
                this.results.setPageFormat(this.extractFormat(instr));
            } else if (NUMPAGES_FIELD_TYPE.equals(fieldType)) {
                this.results.setNumpagesPresent(true);
                this.results.setNumpagesFormat(this.extractFormat(instr));
            } else if (SECTIONPAGES_FIELD_TYPE.equals(fieldType)) {
                this.results.setSectionpagesPresent(true);
                this.results.setSectionpagesFormat(this.extractFormat(instr));
            }
        }

        protected String extractFormat(String instr) {
            String ret = null;
            try {
                this.fldSimpleModel.build(instr);
                return FormattingSwitchHelper.findFirstSwitchValue("\\*", this.fldSimpleModel.getFldParameters(), true);
            }
            catch (TransformerException e) {
                ret = null;
                return ret;
            }
        }
    }
}

