/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.model.properties.paragraph;

import org.docx4j.jaxb.Context;
import org.docx4j.model.properties.paragraph.AbstractParagraphProperty;
import org.docx4j.wml.Jc;
import org.docx4j.wml.JcEnumeration;
import org.docx4j.wml.PPr;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.css.CSSValue;

public class Justification
extends AbstractParagraphProperty {
    protected static Logger log = LoggerFactory.getLogger(Justification.class);
    public static final String CSS_NAME = "text-align";
    public static final String FO_NAME = "text-align";

    @Override
    public String getCssName() {
        return "text-align";
    }

    public Justification(Jc jc) {
        this.setObject(jc);
    }

    public Justification(CSSValue value) {
        this.debug("text-align", value);
        Jc jc = Context.getWmlObjectFactory().createJc();
        if (value.getCssText().toLowerCase().equals("left")) {
            jc.setVal(JcEnumeration.LEFT);
        } else if (value.getCssText().toLowerCase().equals("center")) {
            jc.setVal(JcEnumeration.CENTER);
        } else if (value.getCssText().toLowerCase().equals("right")) {
            jc.setVal(JcEnumeration.RIGHT);
        } else if (value.getCssText().toLowerCase().equals("justify")) {
            jc.setVal(JcEnumeration.BOTH);
        } else {
            log.warn("How to handle justification: " + value.getCssText());
        }
        this.setObject(jc);
    }

    @Override
    public String getCssProperty() {
        String val = ((Jc)this.getObject()).getVal().value();
        if (val.equals("left") || val.equals("center") || val.equals("right")) {
            return Justification.composeCss("text-align", val);
        }
        if (val.equals("both")) {
            return Justification.composeCss("text-align", "justify");
        }
        return "";
    }

    @Override
    public void setXslFO(Element foElement) {
        if (((Jc)this.getObject()).getVal() == null) {
            log.error("justification missing value");
            return;
        }
        String val = ((Jc)this.getObject()).getVal().value();
        if (val.equals("left") || val.equals("center") || val.equals("right")) {
            foElement.setAttribute("text-align", val);
        } else if (val.equals("both")) {
            foElement.setAttribute("text-align", "justify");
        }
    }

    @Override
    public void set(PPr pPr) {
        pPr.setJc((Jc)this.getObject());
    }
}

