/*
 * Decompiled with CFR 0.152.
 */
package org.docstr.gwt;

import javax.inject.Inject;
import org.docstr.gwt.AbstractBaseTask;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.compile.JavaCompile;

public abstract class GwtSuperDevTask
extends AbstractBaseTask {
    public static final String CODE_SERVER_CLASS = "com.google.gwt.dev.codeserver.CodeServer";
    @Input
    @Optional
    private final Property<Boolean> allowMissingSrc;
    @Input
    @Optional
    private final Property<Boolean> compileTest;
    @Input
    @Optional
    private final Property<Integer> compileTestRecompiles;
    @Input
    @Optional
    private final Property<Boolean> precompile;
    @Input
    @Optional
    private final Property<Integer> port;
    @InputDirectory
    @Optional
    private final DirectoryProperty src;
    @OutputDirectory
    @Optional
    private final DirectoryProperty launcherDir;
    @Input
    @Optional
    private final Property<String> bindAddress;
    @Input
    @Optional
    private final Property<Boolean> closureFormattedOutput;

    @Inject
    public GwtSuperDevTask(ObjectFactory objects) {
        super(objects);
        this.allowMissingSrc = objects.property(Boolean.class);
        this.compileTest = objects.property(Boolean.class);
        this.compileTestRecompiles = objects.property(Integer.class);
        this.precompile = objects.property(Boolean.class);
        this.port = objects.property(Integer.class);
        this.src = objects.directoryProperty();
        this.launcherDir = objects.directoryProperty();
        this.bindAddress = objects.property(String.class);
        this.closureFormattedOutput = objects.property(Boolean.class);
        this.getMainClass().set((Object)CODE_SERVER_CLASS);
        this.dependsOn(new Object[]{this.getProject().getTasks().withType(JavaCompile.class)});
    }

    public Property<Boolean> getAllowMissingSrc() {
        return this.allowMissingSrc;
    }

    public Property<Boolean> getCompileTest() {
        return this.compileTest;
    }

    public Property<Integer> getCompileTestRecompiles() {
        return this.compileTestRecompiles;
    }

    public Property<Boolean> getPrecompile() {
        return this.precompile;
    }

    public Property<Integer> getPort() {
        return this.port;
    }

    public DirectoryProperty getSrc() {
        return this.src;
    }

    public DirectoryProperty getLauncherDir() {
        return this.launcherDir;
    }

    public Property<String> getBindAddress() {
        return this.bindAddress;
    }

    public Property<Boolean> getClosureFormattedOutput() {
        return this.closureFormattedOutput;
    }

    @Override
    public void exec() {
        if (this.getAllowMissingSrc().isPresent()) {
            if (((Boolean)this.getAllowMissingSrc().get()).booleanValue()) {
                this.args(new Object[]{"-allowMissingSrc"});
            } else {
                this.args(new Object[]{"-noallowMissingSrc"});
            }
        }
        if (this.getCompileTest().isPresent()) {
            if (((Boolean)this.getCompileTest().get()).booleanValue()) {
                this.args(new Object[]{"-compileTest"});
            } else {
                this.args(new Object[]{"-nocompileTest"});
            }
        }
        if (this.getCompileTestRecompiles().isPresent()) {
            this.args(new Object[]{"-compileTestRecompiles", this.getCompileTestRecompiles().get()});
        }
        if (this.getPrecompile().isPresent()) {
            if (((Boolean)this.getPrecompile().get()).booleanValue()) {
                this.args(new Object[]{"-precompile"});
            } else {
                this.args(new Object[]{"-noprecompile"});
            }
        }
        if (this.getPort().isPresent()) {
            this.args(new Object[]{"-port", this.getPort().get()});
        }
        if (this.getSrc().isPresent()) {
            this.args(new Object[]{"-src", ((Directory)this.getSrc().get()).getAsFile().getPath()});
        }
        if (this.getLauncherDir().isPresent()) {
            this.args(new Object[]{"-launcherDir", ((Directory)this.getLauncherDir().get()).getAsFile().getPath()});
        }
        if (this.getBindAddress().isPresent()) {
            this.args(new Object[]{"-bindAddress", this.getBindAddress().get()});
        }
        if (this.getClosureFormattedOutput().isPresent()) {
            if (((Boolean)this.getClosureFormattedOutput().get()).booleanValue()) {
                this.args(new Object[]{"-XclosureFormattedOutput"});
            } else {
                this.args(new Object[]{"-XnoclosureFormattedOutput"});
            }
        }
        super.exec();
    }
}

