/*
 * Decompiled with CFR 0.152.
 */
package org.docstr.gwt;

import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import org.gradle.api.GradleException;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.logging.Logger;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.JavaExec;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;

public abstract class AbstractBaseTask
extends JavaExec {
    @Input
    @Optional
    private final Property<String> logLevel;
    @OutputDirectory
    @Optional
    private final DirectoryProperty workDir;
    @OutputDirectory
    @Optional
    private final DirectoryProperty gen;
    @OutputDirectory
    @Optional
    private final DirectoryProperty war;
    @OutputDirectory
    @Optional
    private final DirectoryProperty deploy;
    @OutputDirectory
    @Optional
    private final DirectoryProperty extra;
    @OutputDirectory
    @Optional
    private final DirectoryProperty cacheDir;
    @Input
    @Optional
    private final Property<String> sourceLevel;
    @Input
    @Optional
    private final Property<String> methodNameDisplayMode;
    @Input
    @Optional
    private final Property<Boolean> generateJsInteropExports;
    @Input
    @Optional
    private final ListProperty<String> includeJsInteropExports;
    @Input
    @Optional
    private final ListProperty<String> excludeJsInteropExports;
    @Input
    @Optional
    private final Property<String> style;
    @Input
    @Optional
    private final Property<Boolean> failOnError;
    @Input
    @Optional
    private final ListProperty<String> setProperty;
    @Input
    @Optional
    private final Property<Boolean> incremental;
    @Input
    private final ListProperty<String> modules;

    @Inject
    public AbstractBaseTask(ObjectFactory objects) {
        this.logLevel = objects.property(String.class);
        this.workDir = objects.directoryProperty();
        this.gen = objects.directoryProperty();
        this.war = objects.directoryProperty();
        this.deploy = objects.directoryProperty();
        this.extra = objects.directoryProperty();
        this.cacheDir = objects.directoryProperty();
        this.sourceLevel = objects.property(String.class);
        this.methodNameDisplayMode = objects.property(String.class);
        this.generateJsInteropExports = objects.property(Boolean.class);
        this.includeJsInteropExports = objects.listProperty(String.class);
        this.excludeJsInteropExports = objects.listProperty(String.class);
        this.style = objects.property(String.class);
        this.failOnError = objects.property(Boolean.class);
        this.setProperty = objects.listProperty(String.class);
        this.incremental = objects.property(Boolean.class);
        this.modules = objects.listProperty(String.class);
    }

    public void exec() {
        SourceSetContainer sourceSets = (SourceSetContainer)this.getProject().getExtensions().getByType(SourceSetContainer.class);
        SourceSet mainSourceSet = (SourceSet)sourceSets.getByName("main");
        Set allMainSourcePaths = mainSourceSet.getAllSource().getSrcDirs();
        FileCollection outputClasspath = mainSourceSet.getOutput().getClassesDirs().plus((FileCollection)this.getProject().files(new Object[]{mainSourceSet.getOutput().getResourcesDir()}));
        this.classpath(new Object[]{allMainSourcePaths, outputClasspath, this.getProject().getConfigurations().getByName("runtimeClasspath")});
        Logger log = this.getProject().getLogger();
        this.getClasspath().getFiles().forEach(file -> log.debug("classpath: {}", file));
        if (this.getLogLevel().isPresent()) {
            this.args(new Object[]{"-logLevel", this.getLogLevel().get()});
        }
        if (this.getWorkDir().isPresent()) {
            this.args(new Object[]{"-workDir", ((Directory)this.getWorkDir().get()).getAsFile().getPath()});
        }
        if (!this.isCodeServerTask() && this.getGen().isPresent()) {
            this.args(new Object[]{"-gen", ((Directory)this.getGen().get()).getAsFile().getPath()});
        }
        if (!this.isCodeServerTask() && this.getWar().isPresent()) {
            boolean mkdirs;
            if (!((Directory)this.getWar().get()).getAsFile().exists() && !(mkdirs = ((Directory)this.getWar().get()).getAsFile().mkdirs())) {
                throw new GradleException("Failed to create war directory: " + ((Directory)this.getWar().get()).getAsFile());
            }
            this.args(new Object[]{"-war", ((Directory)this.getWar().get()).getAsFile().getPath()});
        }
        if (!this.isCodeServerTask() && this.getDeploy().isPresent()) {
            this.args(new Object[]{"-deploy", ((Directory)this.getDeploy().get()).getAsFile().getPath()});
        }
        if (!this.isCodeServerTask() && this.getExtra().isPresent()) {
            this.args(new Object[]{"-extra", ((Directory)this.getExtra().get()).getAsFile().getPath()});
        }
        if (!this.isCodeServerTask() && this.getCacheDir().isPresent()) {
            this.jvmArgs(new Object[]{"-Dgwt.persistentunitcachedir=" + ((Directory)this.getCacheDir().get()).getAsFile().getPath()});
        }
        if (this.getSourceLevel().isPresent()) {
            this.args(new Object[]{"-sourceLevel", this.getSourceLevel().get()});
        }
        if (this.getMethodNameDisplayMode().isPresent()) {
            this.args(new Object[]{"-XmethodNameDisplayMode", this.getMethodNameDisplayMode().get()});
        }
        if (this.getGenerateJsInteropExports().isPresent()) {
            if (((Boolean)this.getGenerateJsInteropExports().get()).booleanValue()) {
                this.args(new Object[]{"-generateJsInteropExports"});
            } else {
                this.args(new Object[]{"-nogenerateJsInteropExports"});
            }
        }
        if (this.getIncludeJsInteropExports().isPresent()) {
            ((List)this.getIncludeJsInteropExports().get()).forEach(include -> this.args(new Object[]{"-includeJsInteropExports", include}));
        }
        if (this.getExcludeJsInteropExports().isPresent()) {
            ((List)this.getExcludeJsInteropExports().get()).forEach(exclude -> this.args(new Object[]{"-excludeJsInteropExports", exclude}));
        }
        if (this.getStyle().isPresent()) {
            this.args(new Object[]{"-style", this.getStyle().get()});
        }
        if (this.getFailOnError().isPresent()) {
            if (((Boolean)this.getFailOnError().get()).booleanValue()) {
                this.args(new Object[]{"-failOnError"});
            } else {
                this.args(new Object[]{"-nofailOnError"});
            }
        }
        if (this.getSetProperty().isPresent()) {
            ((List)this.getSetProperty().get()).forEach(property -> this.args(new Object[]{"-setProperty", property}));
        }
        if (this.getIncremental().isPresent()) {
            if (((Boolean)this.getIncremental().get()).booleanValue()) {
                this.args(new Object[]{"-incremental"});
            } else {
                this.args(new Object[]{"-noincremental"});
            }
        }
        ((List)this.getModules().get()).forEach(module -> this.args(new Object[]{module}));
        log.lifecycle("jvmArgs: {}", new Object[]{this.getJvmArguments().getOrElse(List.of())});
        log.lifecycle("args: {}", new Object[]{this.getArgs()});
        super.exec();
    }

    private boolean isCodeServerTask() {
        return "com.google.gwt.dev.codeserver.CodeServer".equals(this.getMainClass().get());
    }

    public final Property<String> getLogLevel() {
        return this.logLevel;
    }

    public final DirectoryProperty getWorkDir() {
        return this.workDir;
    }

    public final DirectoryProperty getGen() {
        return this.gen;
    }

    public final DirectoryProperty getWar() {
        return this.war;
    }

    public final DirectoryProperty getDeploy() {
        return this.deploy;
    }

    public final DirectoryProperty getExtra() {
        return this.extra;
    }

    public final DirectoryProperty getCacheDir() {
        return this.cacheDir;
    }

    public final Property<String> getSourceLevel() {
        return this.sourceLevel;
    }

    public final Property<String> getMethodNameDisplayMode() {
        return this.methodNameDisplayMode;
    }

    public final Property<Boolean> getGenerateJsInteropExports() {
        return this.generateJsInteropExports;
    }

    public final ListProperty<String> getIncludeJsInteropExports() {
        return this.includeJsInteropExports;
    }

    public final ListProperty<String> getExcludeJsInteropExports() {
        return this.excludeJsInteropExports;
    }

    public final Property<String> getStyle() {
        return this.style;
    }

    public final Property<Boolean> getFailOnError() {
        return this.failOnError;
    }

    public final ListProperty<String> getSetProperty() {
        return this.setProperty;
    }

    public final Property<Boolean> getIncremental() {
        return this.incremental;
    }

    public final ListProperty<String> getModules() {
        return this.modules;
    }
}

