/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.oauth2.client.grants;

import java.io.IOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import net.iharder.Base64;
import org.dmfs.express.json.JsonValue;
import org.dmfs.express.json.elementary.JsonText;
import org.dmfs.httpessentials.client.HttpRequestExecutor;
import org.dmfs.httpessentials.exceptions.ProtocolError;
import org.dmfs.httpessentials.exceptions.ProtocolException;
import org.dmfs.oauth2.client.BasicOAuth2AuthorizationRequest;
import org.dmfs.oauth2.client.OAuth2AccessToken;
import org.dmfs.oauth2.client.OAuth2Client;
import org.dmfs.oauth2.client.OAuth2InteractiveGrant;
import org.dmfs.oauth2.client.OAuth2Scope;
import org.dmfs.oauth2.client.scope.StringScope;
import org.dmfs.oauth2.client.tokens.ImplicitGrantAccessToken;
import org.dmfs.oauth2.client.utils.GrantState;
import org.dmfs.rfc3986.Uri;
import org.dmfs.rfc3986.UriEncoded;
import org.dmfs.rfc3986.encoding.Precoded;
import org.dmfs.rfc3986.uris.LazyUri;
import org.dmfs.rfc3986.uris.Text;
import org.json.JSONArray;

public final class ImplicitGrant
implements OAuth2InteractiveGrant {
    private final OAuth2Client mClient;
    private final OAuth2Scope mScope;
    private final CharSequence mState;

    public ImplicitGrant(OAuth2Client client, OAuth2Scope scope) {
        this(client, scope, client.randomChars());
    }

    private ImplicitGrant(OAuth2Client client, OAuth2Scope scope, CharSequence state) {
        this.mClient = client;
        this.mScope = scope;
        this.mState = state;
    }

    @Override
    public URI authorizationUrl() {
        if (this.mScope.isEmpty()) {
            return this.mClient.authorizationUrl(new BasicOAuth2AuthorizationRequest("token", this.mState));
        }
        return this.mClient.authorizationUrl(new BasicOAuth2AuthorizationRequest("token", this.mScope, this.mState));
    }

    @Override
    public OAuth2InteractiveGrant withRedirect(Uri redirectUri) {
        return new AuthorizedImplicitGrant(this.mClient, redirectUri, this.mScope, this.mState);
    }

    @Override
    public OAuth2AccessToken accessToken(HttpRequestExecutor executor) throws IOException, ProtocolError, ProtocolException {
        throw new IllegalStateException("first use withRedirectUri(URI) to pass the redirect URI returned by the authorization endpoint.");
    }

    @Override
    @Deprecated
    public OAuth2InteractiveGrant.OAuth2GrantState state() {
        return new InitialImplicitGrantState(this.mScope, this.mState);
    }

    @Override
    public String encodedState() {
        return Base64.encodeBytes((byte[])new JsonText((JsonValue)new GrantState(InitialImplicitGrantFactory.class, this.mScope.toString(), this.mState.toString())).value().getBytes(StandardCharsets.UTF_8));
    }

    private static final class AuthorizedImplicitGrant
    implements OAuth2InteractiveGrant {
        private final OAuth2Client mClient;
        private final Uri mRedirectUri;
        private final OAuth2Scope mScope;
        private final CharSequence mState;

        private AuthorizedImplicitGrant(OAuth2Client client, Uri redirectUri, OAuth2Scope scope, CharSequence state) {
            this.mClient = client;
            this.mRedirectUri = redirectUri;
            this.mScope = scope;
            this.mState = state;
        }

        @Override
        public OAuth2AccessToken accessToken(HttpRequestExecutor executor) throws IOException, ProtocolError, ProtocolException {
            return new ImplicitGrantAccessToken(this.mRedirectUri, this.mScope, this.mState, this.mClient.defaultTokenTtl());
        }

        @Override
        public URI authorizationUrl() {
            throw new IllegalStateException("This grant has already been completed. You can't start it again.");
        }

        @Override
        public OAuth2InteractiveGrant withRedirect(Uri redirectUri) {
            throw new IllegalStateException("This grant has already been completed. You can't feed another redirect URI.");
        }

        @Override
        @Deprecated
        public OAuth2InteractiveGrant.OAuth2GrantState state() {
            return new AuthorizedImplicitGrantState(this.mRedirectUri, this.mScope, this.mState);
        }

        @Override
        public String encodedState() {
            return Base64.encodeBytes((byte[])new JsonText((JsonValue)new GrantState(AuthenticatedImplicitGrantFactory.class, new Text(this.mRedirectUri).toString(), this.mScope.toString(), this.mState.toString())).value().getBytes(StandardCharsets.UTF_8));
        }

        private static final class AuthenticatedImplicitGrantFactory
        implements OAuth2InteractiveGrant.OAuth2InteractiveGrantFactory {
            private AuthenticatedImplicitGrantFactory() {
            }

            @Override
            public OAuth2InteractiveGrant grant(OAuth2Client client, JSONArray arguments) {
                if (arguments.length() != 3) {
                    throw new IllegalArgumentException("Can't restore grant from invalid state.");
                }
                return new AuthorizedImplicitGrant(client, (Uri)new LazyUri((UriEncoded)new Precoded((CharSequence)arguments.getString(0))), new StringScope(arguments.getString(1)), arguments.getString(2));
            }
        }
    }

    @Deprecated
    private static final class InitialImplicitGrantState
    implements OAuth2InteractiveGrant.OAuth2GrantState {
        private static final long serialVersionUID = 1L;
        private final String mScopeString;
        private final String mState;

        public InitialImplicitGrantState(OAuth2Scope scope, CharSequence state) {
            this.mScopeString = scope.toString();
            this.mState = state.toString();
        }

        @Override
        public ImplicitGrant grant(OAuth2Client client) {
            return new ImplicitGrant(client, new StringScope(this.mScopeString), this.mState);
        }
    }

    private static final class InitialImplicitGrantFactory
    implements OAuth2InteractiveGrant.OAuth2InteractiveGrantFactory {
        private InitialImplicitGrantFactory() {
        }

        @Override
        public OAuth2InteractiveGrant grant(OAuth2Client client, JSONArray arguments) {
            if (arguments.length() != 2) {
                throw new IllegalArgumentException("Can't restore grant from invalid state.");
            }
            return new ImplicitGrant(client, new StringScope(arguments.getString(0)), arguments.getString(1));
        }
    }

    @Deprecated
    private static final class AuthorizedImplicitGrantState
    implements OAuth2InteractiveGrant.OAuth2GrantState {
        private static final long serialVersionUID = 1L;
        private final Uri mRedirectUri;
        private final String mScopeString;
        private final String mState;

        private AuthorizedImplicitGrantState(Uri redirectUri, OAuth2Scope scope, CharSequence state) {
            this.mRedirectUri = redirectUri;
            this.mScopeString = scope.toString();
            this.mState = state.toString();
        }

        @Override
        public OAuth2InteractiveGrant grant(OAuth2Client client) {
            return new AuthorizedImplicitGrant(client, this.mRedirectUri, new StringScope(this.mScopeString), this.mState);
        }
    }
}

