/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.oauth2.client.http.requests;

import java.io.IOException;
import org.dmfs.httpessentials.HttpMethod;
import org.dmfs.httpessentials.HttpStatus;
import org.dmfs.httpessentials.client.HttpRequest;
import org.dmfs.httpessentials.client.HttpResponse;
import org.dmfs.httpessentials.client.HttpResponseHandler;
import org.dmfs.httpessentials.exceptions.ProtocolError;
import org.dmfs.httpessentials.exceptions.ProtocolException;
import org.dmfs.httpessentials.headers.EmptyHeaders;
import org.dmfs.httpessentials.headers.Headers;
import org.dmfs.httpessentials.responsehandlers.FailResponseHandler;
import org.dmfs.oauth2.client.OAuth2AccessToken;
import org.dmfs.oauth2.client.OAuth2Scope;
import org.dmfs.oauth2.client.http.responsehandlers.TokenErrorResponseHandler;
import org.dmfs.oauth2.client.http.responsehandlers.TokenResponseHandler;

public abstract class AbstractAccessTokenRequest
implements HttpRequest<OAuth2AccessToken> {
    private final OAuth2Scope mScope;

    public AbstractAccessTokenRequest(OAuth2Scope scope) {
        this.mScope = scope;
    }

    public final HttpMethod method() {
        return HttpMethod.POST;
    }

    public final Headers headers() {
        return EmptyHeaders.INSTANCE;
    }

    public final HttpResponseHandler<OAuth2AccessToken> responseHandler(HttpResponse response) throws IOException, ProtocolError, ProtocolException {
        if (!HttpStatus.OK.equals((Object)response.status())) {
            if (!HttpStatus.BAD_REQUEST.equals((Object)response.status())) {
                return FailResponseHandler.getInstance();
            }
            return new TokenErrorResponseHandler();
        }
        return new TokenResponseHandler(this.mScope);
    }
}

