/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.oauth2.client.http.entities;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Locale;
import org.dmfs.httpessentials.client.HttpRequestEntity;
import org.dmfs.httpessentials.types.MediaType;
import org.dmfs.httpessentials.types.StructuredMediaType;
import org.dmfs.jems.optional.Optional;
import org.dmfs.jems.optional.elementary.Present;
import org.dmfs.rfc3986.encoding.XWwwFormUrlEncoded;
import org.dmfs.rfc3986.parameters.Parameter;
import org.dmfs.rfc3986.parameters.ParameterList;
import org.dmfs.rfc3986.parameters.parametersets.BasicParameterList;

public final class XWwwFormUrlEncodedEntity
implements HttpRequestEntity {
    private static final Optional<MediaType> CONTENT_TYPE = new Present((Object)new StructuredMediaType("application", "x-www-form-urlencoded"));
    private static final String ENCODING = "UTF-8";
    private final ParameterList mValues;

    public XWwwFormUrlEncodedEntity(Parameter ... values) {
        this.mValues = new BasicParameterList(values);
    }

    public XWwwFormUrlEncodedEntity(ParameterList values) {
        this.mValues = values;
    }

    public Optional<MediaType> contentType() {
        return CONTENT_TYPE;
    }

    public Optional<Long> contentLength() {
        try {
            return new Present((Object)this.toString().getBytes(ENCODING).length);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(String.format(Locale.ENGLISH, "%s encoding not supported by runtime", ENCODING));
        }
    }

    public void writeContent(OutputStream out) throws IOException {
        out.write(this.toString().getBytes(ENCODING));
    }

    public String toString() {
        return new XWwwFormUrlEncoded(this.mValues).toString();
    }
}

