/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.oauth2.client.http.decorators;

import java.io.UnsupportedEncodingException;
import net.iharder.Base64;
import org.dmfs.httpessentials.converters.PlainStringHeaderConverter;
import org.dmfs.httpessentials.decoration.Decoration;
import org.dmfs.httpessentials.headers.BasicSingletonHeaderType;
import org.dmfs.httpessentials.headers.HeaderType;
import org.dmfs.httpessentials.headers.Headers;
import org.dmfs.httpessentials.headers.UpdatedHeaders;
import org.dmfs.httpessentials.typedentity.EntityConverter;

public final class BasicAuthHeaderDecoration
implements Decoration<Headers> {
    private final HeaderType<String> AUTHORIZATION_HEADER_TYPE = new BasicSingletonHeaderType("Authorization", (EntityConverter)new PlainStringHeaderConverter());
    private final String mUsername;
    private final String mPassword;

    public BasicAuthHeaderDecoration(String username, String password) {
        if (username == null) {
            throw new IllegalArgumentException("username must not be null");
        }
        if (password == null) {
            throw new IllegalArgumentException("password must not be null");
        }
        this.mUsername = username;
        this.mPassword = password;
    }

    public Headers decorated(Headers original) {
        String authHeaderValue = "Basic " + Base64.encodeBytes((byte[])this.usernameAndPasswordBytes());
        return new UpdatedHeaders(original, this.AUTHORIZATION_HEADER_TYPE.entity((Object)authHeaderValue));
    }

    private byte[] usernameAndPasswordBytes() {
        try {
            return String.format("%s:%s", this.mUsername, this.mPassword).getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Charset UTF-8 not supported by runtime!", e);
        }
    }
}

