/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.oauth2.client;

import java.io.IOException;
import java.net.URI;
import org.dmfs.httpessentials.client.HttpRequest;
import org.dmfs.httpessentials.client.HttpRequestExecutor;
import org.dmfs.httpessentials.exceptions.ProtocolError;
import org.dmfs.httpessentials.exceptions.ProtocolException;
import org.dmfs.httpessentials.exceptions.RedirectionException;
import org.dmfs.httpessentials.exceptions.UnexpectedStatusException;
import org.dmfs.oauth2.client.OAuth2AccessToken;
import org.dmfs.oauth2.client.OAuth2AuthorizationProvider;
import org.dmfs.oauth2.client.OAuth2AuthorizationRequest;
import org.dmfs.rfc5545.Duration;

public final class BasicOAuth2AuthorizationProvider
implements OAuth2AuthorizationProvider {
    private final URI mAuthorizationEndpoint;
    private final URI mTokenEndpoint;
    private final Duration mDefaultTokenTtl;

    public BasicOAuth2AuthorizationProvider(URI authorizationEndpoint, URI tokenEndpoint, Duration defaultTokenTtl) {
        this.mAuthorizationEndpoint = authorizationEndpoint;
        this.mTokenEndpoint = tokenEndpoint;
        this.mDefaultTokenTtl = defaultTokenTtl;
    }

    @Override
    public OAuth2AccessToken accessToken(HttpRequest<OAuth2AccessToken> tokenRequest, HttpRequestExecutor executor) throws RedirectionException, UnexpectedStatusException, IOException, ProtocolError, ProtocolException {
        return (OAuth2AccessToken)executor.execute(this.mTokenEndpoint, tokenRequest);
    }

    @Override
    public URI authorizationUrl(OAuth2AuthorizationRequest authorizationRequest) {
        return authorizationRequest.authorizationUri(this.mAuthorizationEndpoint);
    }

    @Override
    public Duration defaultTokenTtl() {
        return this.mDefaultTokenTtl;
    }
}

