/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.rfc5545.recur;

import java.util.TimeZone;
import org.dmfs.rfc5545.DateTime;
import org.dmfs.rfc5545.Instance;
import org.dmfs.rfc5545.calendarmetrics.CalendarMetrics;
import org.dmfs.rfc5545.recur.Limiter;
import org.dmfs.rfc5545.recur.RecurrenceRule;
import org.dmfs.rfc5545.recur.RuleIterator;

final class UntilLimiter
extends Limiter {
    private final long mUntil;

    public UntilLimiter(RecurrenceRule rule, RuleIterator previous, CalendarMetrics calendarMetrics, TimeZone startTimezone) {
        super(previous);
        DateTime until = rule.getUntil();
        if (!until.isFloating()) {
            until = until.shiftTimeZone(startTimezone);
        }
        this.mUntil = until.getInstance();
    }

    @Override
    boolean stop(long instance) {
        return this.mUntil < Instance.maskWeekday((long)instance);
    }
}

