/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.rfc5545.recur;

import org.dmfs.rfc5545.Instance;
import org.dmfs.rfc5545.calendarmetrics.CalendarMetrics;
import org.dmfs.rfc5545.recur.LongArray;
import org.dmfs.rfc5545.recur.RecurrenceRule;
import org.dmfs.rfc5545.recur.RuleIterator;

final class ByMonthSkipFilter
extends RuleIterator {
    private static final int MAX_EMPTY_SETS = 1000;
    private final CalendarMetrics mCalendarMetrics;
    private final RecurrenceRule.Skip mSkip;
    private LongArray mWorkingSet = null;
    private final LongArray mResultSet = new LongArray();

    public ByMonthSkipFilter(RecurrenceRule rule, RuleIterator previous, CalendarMetrics calendarMetrics, long start) {
        super(previous);
        this.mCalendarMetrics = calendarMetrics;
        this.mSkip = rule.getSkip();
    }

    @Override
    public long next() {
        LongArray workingSet = this.mWorkingSet;
        if (workingSet == null || !workingSet.hasNext()) {
            this.mWorkingSet = workingSet = this.nextSet();
        }
        return workingSet.next();
    }

    @Override
    LongArray nextSet() {
        LongArray resultSet = this.mResultSet;
        CalendarMetrics calendarMetrics = this.mCalendarMetrics;
        resultSet.clear();
        int counter = 0;
        do {
            if (counter == 1000) {
                throw new IllegalArgumentException("too many empty recurrence sets");
            }
            ++counter;
            LongArray prev = this.mPrevious.nextSet();
            while (prev.hasNext()) {
                long next = Instance.maskWeekday((long)prev.next());
                if (!calendarMetrics.validate(next)) {
                    next = calendarMetrics.validate(Instance.setDayOfMonth((long)next, (int)1)) ? (this.mSkip == RecurrenceRule.Skip.BACKWARD ? calendarMetrics.prevDay(next) : calendarMetrics.nextDay(next)) : (this.mSkip == RecurrenceRule.Skip.BACKWARD ? calendarMetrics.prevMonth(next) : calendarMetrics.nextMonth(next));
                }
                resultSet.add(next);
            }
        } while (!resultSet.hasNext());
        return resultSet;
    }
}

