/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.impl;

import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.directwebremoting.ConversionException;
import org.directwebremoting.ScriptBuffer;
import org.directwebremoting.extend.ConverterManager;
import org.directwebremoting.extend.EnginePrivate;
import org.directwebremoting.extend.RealScriptSession;
import org.directwebremoting.extend.ScriptBufferUtil;
import org.directwebremoting.extend.ScriptConduit;
import org.directwebremoting.extend.Sleeper;
import org.directwebremoting.util.LocalUtil;

public abstract class BaseSleeper
implements Sleeper {
    private final HttpServletResponse response;
    private final RealScriptSession scriptSession;
    private final ScriptConduit conduit;
    private final PrintWriter out;
    private String batchId;
    private Runnable onClose;
    private int disconnectedTime;
    protected ConverterManager converterManager = null;
    protected boolean jsonOutput = false;
    private final Object lock = new Object();
    private boolean closePending = false;
    private boolean opened = false;
    private boolean closed = false;
    private long nextScriptIndex = 0L;
    private static final Log log = LogFactory.getLog(BaseSleeper.class);

    public BaseSleeper(HttpServletResponse response, RealScriptSession scriptSession, ScriptConduit conduit) throws IOException {
        this.response = response;
        this.scriptSession = scriptSession;
        this.conduit = conduit;
        this.out = response.getWriter();
    }

    @Override
    public final void enterSleep(String batchId, Runnable onClose, int disconnectedTime) {
        this.batchId = batchId;
        this.onClose = onClose;
        this.disconnectedTime = disconnectedTime;
        this.doWork();
        if (!this.closed) {
            this.enterSleep();
        }
    }

    protected abstract void enterSleep();

    @Override
    public final void wakeUpForData() {
        this.wakeUp();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final int wakeUpToClose() {
        Object object = this.lock;
        synchronized (object) {
            this.closePending = true;
        }
        this.wakeUp();
        return this.disconnectedTime;
    }

    protected abstract void wakeUp();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void doWork() {
        try {
            if (this.closed) {
                return;
            }
            Object object = this.lock;
            synchronized (object) {
                if (this.closePending) {
                    this.closePending = false;
                    this.closed = true;
                }
            }
            if (!this.opened) {
                this.beginStreamAndChunk();
                this.opened = true;
            }
            this.sendNewChunkScripts();
            this.checkNonChunkScripts();
            if (this.closed) {
                this.sendPollReply();
                this.endStreamAndChunk();
                this.doClose();
            } else {
                this.endChunk();
            }
            this.scriptSession.updateLastAccessedTime();
        }
        catch (Exception ex) {
            if (LocalUtil.getRootCause(ex) instanceof IOException) {
                log.debug((Object)"Poll I/O error", (Throwable)ex);
            } else {
                log.error((Object)"Error during poll.", (Throwable)ex);
            }
            this.closed = true;
            try {
                this.sendPollReply();
                this.endStreamAndChunk();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.doClose();
        }
    }

    private void beginStreamAndChunk() throws Exception {
        this.response.setContentType(this.conduit.getOutboundMimeType());
        RealScriptSession.Script script = this.scriptSession.getScript(this.nextScriptIndex);
        boolean beginningRunnable = false;
        if (script != null && script.getScript() instanceof Runnable) {
            try {
                ((Runnable)script.getScript()).run();
            }
            catch (Exception ex) {
                log.error((Object)"Exception when executing Script Runnable.", (Throwable)ex);
            }
            beginningRunnable = true;
        }
        this.conduit.beginStreamAndChunk();
        if (beginningRunnable) {
            this.conduit.sendScript(EnginePrivate.getRemoteHandleReverseAjaxScript(script.getIndex(), ""));
            this.nextScriptIndex = script.getIndex() + 1L;
        }
    }

    private void sendNewChunkScripts() throws Exception {
        RealScriptSession.Script script;
        while ((script = this.scriptSession.getScript(this.nextScriptIndex)) != null && script.getScript() instanceof String) {
            this.conduit.sendScript(EnginePrivate.getRemoteHandleReverseAjaxScript(script.getIndex(), (String)script.getScript()));
            this.nextScriptIndex = script.getIndex() + 1L;
        }
    }

    private void checkNonChunkScripts() {
        RealScriptSession.Script script = this.scriptSession.getScript(this.nextScriptIndex);
        if (script != null && !(script.getScript() instanceof String)) {
            this.closed = true;
            this.disconnectedTime = 0;
        }
    }

    private void sendPollReply() throws ConversionException, IOException {
        ScriptBuffer script = EnginePrivate.getRemoteHandleCallbackScript(this.batchId, "0", this.disconnectedTime);
        this.conduit.sendScript(ScriptBufferUtil.createOutput(script, this.converterManager, this.jsonOutput));
    }

    private void endStreamAndChunk() throws Exception {
        this.conduit.endStreamAndChunk();
    }

    private void endChunk() throws IOException {
        this.conduit.endChunk();
        this.out.flush();
        if (this.out.checkError()) {
            throw new IOException("Stream write error");
        }
        this.response.flushBuffer();
    }

    private void doClose() {
        this.close();
        if (this.onClose != null) {
            this.onClose.run();
        }
    }

    public void setConverterManager(ConverterManager converterManager) {
        this.converterManager = converterManager;
    }

    public void setJsonOutput(boolean jsonOutput) {
        this.jsonOutput = jsonOutput;
    }

    protected abstract void close();
}

