/*
 * Decompiled with CFR 0.152.
 */
package org.didd.version;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.util.AttributeSet;
import android.view.View;

public class WebViewProgress
extends View {
    private float progress = 0.0f;
    private int contentWidth;
    private int contentHeight;
    private int color = Color.parseColor((String)"#0D9CEA");
    private Paint paint;

    public WebViewProgress(Context context) {
        super(context);
    }

    public WebViewProgress(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public WebViewProgress(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.contentWidth == 0) {
            this.contentWidth = this.getWidth() - this.getPaddingLeft() - this.getPaddingRight();
        }
        if (this.contentHeight == 0) {
            this.contentHeight = this.getHeight() - this.getPaddingTop() - this.getPaddingBottom();
        }
        float left = this.getPaddingLeft();
        float top = this.getPaddingTop();
        float right = left + this.progress * (float)this.contentWidth;
        float bottom = top + (float)this.contentHeight;
        if (null == this.paint) {
            this.paint = new Paint(1);
            this.paint.setColor(this.color);
        }
        canvas.drawRect(left, top, right, bottom, this.paint);
    }

    public void updateProgress(float progress) {
        this.progress = progress;
        if (progress >= 1.0f || progress <= 0.0f) {
            this.setVisibility(8);
        } else {
            this.setVisibility(0);
        }
        this.color = Color.argb((int)((int)(200.0f * (1.0f - progress)) + 55), (int)13, (int)156, (int)234);
        this.invalidate();
    }

    public float curProgress() {
        return this.progress;
    }
}

