/*
 * Decompiled with CFR 0.152.
 */
package org.didd.version;

import android.content.ComponentName;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.pm.ResolveInfo;
import android.net.Uri;
import android.os.Bundle;
import android.support.v7.app.AlertDialog;
import android.support.v7.app.AppCompatActivity;
import android.view.KeyEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.LinearLayout;
import android.widget.TextView;
import android.widget.Toast;
import com.transsnet.version.R;
import java.util.List;
import org.didd.common.log.L;
import org.didd.version.VersionApi;
import org.didd.version.VersionBean;

public class VersionActivity
extends AppCompatActivity
implements DialogInterface.OnKeyListener,
DialogInterface.OnCancelListener,
View.OnClickListener {
    private static final String TAG = VersionApi.class.getSimpleName();
    private static final boolean debug = true;
    private Context mContext;
    private VersionBean data;
    private String mAppName;
    private AlertDialog mDialog;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.mContext = this;
        if (null != this.getIntent()) {
            this.handleIntent(this.getIntent());
        }
    }

    protected void onResume() {
        super.onResume();
        VersionApi.mResumed = true;
    }

    protected void onPause() {
        super.onPause();
        VersionApi.mResumed = false;
    }

    protected void onNewIntent(Intent intent) {
        super.onNewIntent(intent);
        this.handleIntent(this.getIntent());
    }

    private void handleIntent(Intent intent) {
        if (null == intent) {
            this.finish();
            return;
        }
        this.mAppName = intent.getStringExtra("appName");
        this.data = (VersionBean)intent.getSerializableExtra("versionBean");
        if (null == this.data) {
            this.finish();
        }
        this.showDialog(this.data);
    }

    private void showDialog(VersionBean data) {
        AlertDialog.Builder builder = new AlertDialog.Builder(this.mContext);
        View customView = View.inflate((Context)this.mContext, (int)R.layout.didd_version_layout, null);
        this.initCustomViewData(customView, data);
        builder.setView(customView);
        this.mDialog = builder.create();
        this.mDialog.setCanceledOnTouchOutside(false);
        this.mDialog.setOnKeyListener((DialogInterface.OnKeyListener)this);
        this.mDialog.setOnCancelListener((DialogInterface.OnCancelListener)this);
        this.mDialog.show();
    }

    private void initCustomViewData(View view, VersionBean data) {
        String tip;
        if (null == view) {
            return;
        }
        this.data = data;
        TextView appName = (TextView)view.findViewById(R.id.version_app_name);
        TextView info = (TextView)view.findViewById(R.id.version_message);
        Button cancelBtn = (Button)view.findViewById(R.id.version_btn_cancel);
        Button updateBtn = (Button)view.findViewById(R.id.version_btn_update);
        String title = this.getAppName() + " " + data.getStrategyName();
        appName.setText((CharSequence)title);
        info.setText((CharSequence)data.getUpdateDesc());
        if ("1".equals(data.getUpgradeStrategy())) {
            cancelBtn.setEnabled(false);
            cancelBtn.setVisibility(8);
            view.findViewById(R.id.version_line_b).setVisibility(8);
            tip = "Update";
            updateBtn.setText((CharSequence)"");
            int dp160 = this.dp2px(160);
            LinearLayout.LayoutParams lp = new LinearLayout.LayoutParams(dp160, -1, 0.0f);
            updateBtn.setLayoutParams((ViewGroup.LayoutParams)lp);
        } else {
            cancelBtn.setOnClickListener((View.OnClickListener)this);
            tip = "Try it now";
        }
        updateBtn.setText((CharSequence)tip);
        updateBtn.setOnClickListener((View.OnClickListener)this);
    }

    private int dp2px(int values) {
        float scale = this.mContext.getResources().getDisplayMetrics().density;
        return (int)((float)values * scale + 0.5f);
    }

    public boolean onKey(DialogInterface dialog, int keyCode, KeyEvent event) {
        return true;
    }

    public void onCancel(DialogInterface dialog) {
        this.finish();
    }

    public void onBackPressed() {
    }

    public void onClick(View v) {
        L.d((String)TAG, (String)"onClick, ");
        if (v.getId() == R.id.version_btn_cancel) {
            if (!"1".equals(this.data.getUpgradeStrategy())) {
                this.dismiss();
            }
        } else if (v.getId() == R.id.version_btn_update) {
            this.update();
        }
    }

    private void dismiss() {
        L.d((String)TAG, (String)"dismiss, ");
        try {
            if (null != this.mDialog) {
                this.mDialog.dismiss();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.finish();
    }

    private void update() {
        String url;
        L.d((String)TAG, (String)"update, ");
        if (null == this.data) {
            Toast.makeText((Context)this.mContext, (CharSequence)"Url is null, Error", (int)0).show();
            return;
        }
        if (!"1".equals(this.data.getUpgradeStrategy())) {
            this.dismiss();
        }
        if (this.isMarketUrl(url = this.data.getDownloadUrl())) {
            this.toMarket(url);
        } else {
            this.toBrowser(url);
        }
    }

    private void toBrowser(String url) {
        L.d((String)TAG, (String)("toBrowser, url = " + url));
        try {
            Intent intent = new Intent();
            intent.setAction("android.intent.action.VIEW");
            Uri content_url = Uri.parse((String)url);
            intent.setData(content_url);
            intent.setFlags(0x10000000);
            this.mContext.startActivity(intent);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void toMarket(String url) {
        L.d((String)TAG, (String)("toMarket, url = " + url));
        try {
            this.startGooglePlay(url);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean isMarketUrl(String url) {
        L.d((String)TAG, (String)("isMarketUrl, url = " + url));
        return null != url && url.startsWith("market://");
    }

    private void startGooglePlay(String url) {
        Intent mIntent = new Intent("android.intent.action.VIEW", Uri.parse((String)url));
        boolean marketExist = false;
        List otherApps = this.mContext.getPackageManager().queryIntentActivities(mIntent, 0);
        for (ResolveInfo otherApp : otherApps) {
            if (!otherApp.activityInfo.applicationInfo.packageName.equals("com.android.vending")) continue;
            ActivityInfo otherAppActivity = otherApp.activityInfo;
            ComponentName componentName = new ComponentName(otherAppActivity.applicationInfo.packageName, otherAppActivity.name);
            mIntent.setFlags(0x10000000);
            mIntent.setComponent(componentName);
            this.mContext.startActivity(mIntent);
            marketExist = true;
            break;
        }
        if (!marketExist) {
            Intent webIntent = new Intent("android.intent.action.VIEW", Uri.parse((String)("https://play.google.com/store/apps/details?id=" + this.mContext.getPackageName())));
            this.mContext.startActivity(webIntent);
        }
    }

    private String getAppName() {
        return this.mAppName;
    }
}

