/*
 * Decompiled with CFR 0.152.
 */
package org.didd.common.statusbar;

import android.app.Activity;
import android.os.Build;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;

public class StatusBarUtil {
    public static void setStatusBarUpperAPI19(Activity context) {
        if (Build.VERSION.SDK_INT < 19) {
            return;
        }
        if (null == context) {
            return;
        }
        Window window = context.getWindow();
        if (null == window) {
            return;
        }
        window.addFlags(0x4000000);
        ViewGroup mContentView = (ViewGroup)context.findViewById(0x1020002);
        if (null == mContentView) {
            return;
        }
        View statusBarView = mContentView.getChildAt(0);
        if (statusBarView != null && statusBarView.getLayoutParams() != null && statusBarView.getLayoutParams().height == StatusBarUtil.getStatusBarHeight(context)) {
            mContentView.removeView(statusBarView);
        }
        if (mContentView.getChildAt(0) != null) {
            mContentView.getChildAt(0).setFitsSystemWindows(false);
        }
    }

    public static int getStatusBarHeight(Activity context) {
        int result = 0;
        int resId = context.getResources().getIdentifier("status_bar_height", "dimen", "android");
        if (resId > 0) {
            result = context.getResources().getDimensionPixelSize(resId);
        }
        return result;
    }

    public static void setWindowTransparent(Activity activity, boolean statusBarTranEnable, boolean navigationTranEnable) {
        if (null == activity) {
            return;
        }
        activity.setRequestedOrientation(1);
        activity.requestWindowFeature(1);
        if (Build.VERSION.SDK_INT >= 21) {
            Window window = activity.getWindow();
            if (null == window) {
                return;
            }
            window.clearFlags(0xC000000);
            window.getDecorView().setSystemUiVisibility(1792);
            window.addFlags(Integer.MIN_VALUE);
            if (statusBarTranEnable) {
                window.setStatusBarColor(0);
            }
            if (navigationTranEnable) {
                window.setNavigationBarColor(0);
            }
        } else if (statusBarTranEnable) {
            StatusBarUtil.setStatusBarUpperAPI19(activity);
        }
    }
}

