/*
 * Decompiled with CFR 0.152.
 */
package org.didd.common.permission;

import android.app.Activity;
import android.os.Build;
import java.util.ArrayList;

public class PermissionUtil {
    private OnCheckPermissionCallback mCheckPermissionCallback;
    private static final int REQUEST_CODE_CHECK_PERMISSION = 9;

    private void test() {
    }

    public void requestPermission(Activity context, String[] permission, OnCheckPermissionCallback callback) {
        this.mCheckPermissionCallback = callback;
        if (Build.VERSION.SDK_INT >= 23) {
            ArrayList<String> permissionNeedApply = new ArrayList<String>();
            for (String item : permission) {
                int res = context.checkSelfPermission(item);
                if (res == 0) continue;
                permissionNeedApply.add(item);
            }
            if (permissionNeedApply.size() > 0) {
                String[] lastPermission = new String[permissionNeedApply.size()];
                int i = 0;
                for (String item : permissionNeedApply) {
                    lastPermission[i++] = item;
                }
                context.requestPermissions(lastPermission, 9);
            } else {
                callback.requestPermissionSuccess();
            }
        } else {
            callback.requestPermissionSuccess();
        }
    }

    public void onRequestPermissionsResult(Activity activity, int requestCode, String[] permissions, int[] grantResults) {
        switch (requestCode) {
            case 9: {
                if (null == this.mCheckPermissionCallback) break;
                if (this.verifyPermissions(grantResults)) {
                    this.mCheckPermissionCallback.requestPermissionSuccess();
                    break;
                }
                boolean isTip = false;
                if (Build.VERSION.SDK_INT >= 23) {
                    isTip = activity.shouldShowRequestPermissionRationale(permissions.length > 0 ? permissions[0] : "");
                }
                this.mCheckPermissionCallback.requestPermissionFailed(isTip, permissions.length > 0 ? permissions[0] : "");
            }
        }
    }

    private boolean verifyPermissions(int ... grantResults) {
        for (int result : grantResults) {
            if (result == 0) continue;
            return false;
        }
        return true;
    }

    public static interface OnCheckPermissionCallback {
        public void requestPermissionSuccess();

        public void requestPermissionFailed(boolean var1, String var2);
    }
}

