/*
 * Decompiled with CFR 0.152.
 */
package org.didd.common.log;

import android.graphics.Bitmap;
import android.os.Environment;
import android.os.StatFs;
import android.text.TextUtils;
import android.util.Log;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class FileUtils {
    private static final String TAG = FileUtils.class.getSimpleName();
    private static final String DEFAULT_STORE_PATH = "TM";
    private static List<String> fileList;

    public static String getSDCardRoot() {
        return Environment.getExternalStorageDirectory().getAbsolutePath() + File.separator;
    }

    public static String getSaveFilePath() {
        long z;
        long y;
        String savePath = null;
        long x = FileUtils.getExternaltStorageAvailableSpace();
        long max = FileUtils.compareValue(x, y = FileUtils.getSdcard2StorageAvailableSpace(), z = FileUtils.getEmmcStorageAvailableSpace());
        if (max == x) {
            savePath = Environment.getExternalStorageDirectory().getAbsolutePath();
        } else if (max == y) {
            savePath = FileUtils.getSdcard2StorageDirectory();
        } else if (max == z) {
            savePath = FileUtils.getEmmcStorageDirectory();
        }
        return savePath + File.separator + DEFAULT_STORE_PATH + File.separator;
    }

    public static boolean isExistSDCard() {
        return FileUtils.getAvailableSizeOfSDCard() > 0L;
    }

    public static long getAvailableSizeOfSDCard() {
        return FileUtils.compareValue(FileUtils.getExternaltStorageAvailableSpace(), FileUtils.getSdcard2StorageAvailableSpace(), FileUtils.getEmmcStorageAvailableSpace());
    }

    private static long compareValue(long x, long y, long z) {
        long m1 = x > y ? x : y;
        long max = m1 > z ? m1 : z;
        return max;
    }

    private static long getExternaltStorageAvailableSpace() {
        if (!Environment.getExternalStorageState().equals("mounted")) {
            return 0L;
        }
        File path = Environment.getExternalStorageDirectory();
        StatFs statfs = new StatFs(path.getPath());
        long blockSize = statfs.getBlockSize();
        long availableBlocks = statfs.getAvailableBlocks();
        return blockSize * availableBlocks;
    }

    private static long getSdcard2StorageAvailableSpace() {
        if (!Environment.getExternalStorageState().equals("mounted")) {
            return 0L;
        }
        String path = FileUtils.getSdcard2StorageDirectory();
        File file = new File(path);
        if (!file.exists()) {
            return 0L;
        }
        StatFs statfs = new StatFs(path);
        long blockSize = statfs.getBlockSize();
        long availableBlocks = statfs.getAvailableBlocks();
        return blockSize * availableBlocks;
    }

    private static long getEmmcStorageAvailableSpace() {
        String path = FileUtils.getEmmcStorageDirectory();
        File file = new File(path);
        if (!file.exists()) {
            return 0L;
        }
        StatFs statfs = new StatFs(path);
        long blockSize = statfs.getBlockSize();
        long availableBlocks = statfs.getAvailableBlocks();
        return blockSize * availableBlocks;
    }

    private static final String getSdcard2StorageDirectory() {
        return "/mnt/sdcard2";
    }

    private static final String getEmmcStorageDirectory() {
        return "/mnt/emmc";
    }

    public static void zipFiles(File[] srcfile, File zipfile) {
        byte[] buf = new byte[1024];
        try {
            ZipOutputStream out = new ZipOutputStream(new FileOutputStream(zipfile));
            for (int i = 0; i < srcfile.length; ++i) {
                int len;
                FileInputStream in = new FileInputStream(srcfile[i]);
                out.putNextEntry(new ZipEntry(srcfile[i].getName()));
                while ((len = in.read(buf)) > 0) {
                    out.write(buf, 0, len);
                }
                out.closeEntry();
                in.close();
            }
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static File createFile(String filePath) throws IOException {
        if (TextUtils.isEmpty((CharSequence)filePath)) {
            Log.d((String)TAG, (String)"filePath is null.");
            return null;
        }
        File file = new File(filePath = filePath.replaceAll(File.separator + File.separator, File.separator));
        File parentFile = file.getParentFile();
        if (null != parentFile && !parentFile.exists()) {
            file.getParentFile().mkdirs();
        }
        if (file.createNewFile()) {
            // empty if block
        }
        return file;
    }

    public static void deleteFile(String filePath) {
        Log.d((String)TAG, (String)("deleteFile() filePath:" + filePath));
        if (filePath == null) {
            return;
        }
        File file = new File(filePath);
        if (file != null) {
            file.delete();
        }
    }

    public static boolean isFileExist(String path) {
        if (TextUtils.isEmpty((CharSequence)path)) {
            return false;
        }
        File file = new File(path);
        return file.exists();
    }

    public static List<String> getListFiles(String path, String suffix, boolean isdepth) {
        fileList = new ArrayList<String>();
        File file = new File(path);
        return FileUtils.getListFiles(file, suffix, isdepth);
    }

    private static List<String> getListFiles(File f, String suffix, boolean isdepth) {
        if (f.isDirectory() && isdepth) {
            File[] t = f.listFiles();
            for (int i = 0; i < t.length; ++i) {
                FileUtils.getListFiles(t[i], suffix, isdepth);
            }
        } else {
            String filePath = f.getAbsolutePath();
            System.out.println("suffix = " + suffix);
            if (suffix == null || suffix.equals("")) {
                System.out.println("----------------");
                fileList.add(filePath);
            } else {
                int begIndex = filePath.lastIndexOf(".");
                String tempsuffix = "";
                if (begIndex != -1) {
                    tempsuffix = filePath.substring(begIndex + 1, filePath.length());
                }
                if (tempsuffix.equals(suffix)) {
                    fileList.add(filePath);
                }
            }
        }
        return fileList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean copyfile(File fromFile, File toFile, boolean rewrite) {
        if (!(fromFile.exists() && fromFile.isFile() && fromFile.canRead())) {
            return false;
        }
        if (!toFile.getParentFile().exists()) {
            toFile.getParentFile().mkdirs();
        }
        if (toFile.exists() && rewrite) {
            toFile.delete();
        }
        FileInputStream fosfrom = null;
        FileOutputStream fosto = null;
        boolean result = false;
        try {
            int c;
            fosfrom = new FileInputStream(fromFile);
            fosto = new FileOutputStream(toFile);
            byte[] bt = new byte[1024];
            while ((c = fosfrom.read(bt)) > 0) {
                fosto.write(bt, 0, c);
            }
            result = true;
        }
        catch (Exception e) {
            Log.e((String)"readfile", (String)e.getMessage());
        }
        finally {
            try {
                if (null != fosfrom) {
                    fosfrom.close();
                }
                if (null != fosto) {
                    fosto.close();
                }
            }
            catch (Exception ex) {
                Log.e((String)"readfile", (String)ex.getMessage());
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean copyfile(InputStream fosfrom, File toFile, boolean rewrite) {
        if (!toFile.getParentFile().exists()) {
            toFile.getParentFile().mkdirs();
        }
        if (toFile.exists() && rewrite) {
            toFile.delete();
        }
        FileOutputStream fosto = null;
        boolean result = false;
        try {
            int c;
            fosto = new FileOutputStream(toFile);
            byte[] bt = new byte[1024];
            while ((c = fosfrom.read(bt)) > 0) {
                fosto.write(bt, 0, c);
            }
            result = true;
        }
        catch (Exception e) {
            Log.e((String)"readfile", (String)e.getMessage());
        }
        finally {
            try {
                if (null != fosfrom) {
                    fosfrom.close();
                }
                if (null != fosto) {
                    fosto.close();
                }
            }
            catch (Exception ex) {
                Log.e((String)"readfile", (String)ex.getMessage());
            }
        }
        return result;
    }

    public static String existThenRenameFile(String filePath) {
        File file = new File(filePath);
        String fileName = file.getName();
        int pointPosition = fileName.lastIndexOf(".");
        if (-1 != pointPosition) {
            String filePrefix = fileName.substring(0, pointPosition);
            String filePostfix = fileName.substring(pointPosition + 1);
            int count = 0;
            while (file.exists()) {
                fileName = filePrefix + "(" + ++count + ")." + filePostfix;
                file = new File(file.getParent(), fileName);
            }
        } else {
            String filePrefix = fileName;
            int count = 0;
            while (file.exists()) {
                fileName = filePrefix + "(" + ++count + ")";
                file = new File(file.getParent(), fileName);
            }
        }
        return file.getParent() + File.separator + fileName;
    }

    public static void saveFile(Bitmap bm, String filePath) {
        BufferedOutputStream bos = null;
        try {
            File myCaptureFile;
            File dirFile = new File(FileUtils.getSaveFilePath());
            if (!dirFile.exists()) {
                dirFile.mkdir();
            }
            if (null == (myCaptureFile = FileUtils.createFile(filePath))) {
                System.out.println("create new file failed");
                return;
            }
            bos = new BufferedOutputStream(new FileOutputStream(myCaptureFile));
            bm.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)bos);
            bos.flush();
            bos.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

