/*
 * Decompiled with CFR 0.152.
 */
package org.didd.common.log;

import android.text.TextUtils;
import android.text.format.DateFormat;
import android.util.Log;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.didd.common.log.FileUtils;

public class FLog {
    private static String LOG_FILE_DIR_NAME = "Logs";
    public static String LOG_FILE_DIR = FileUtils.getSaveFilePath() + LOG_FILE_DIR_NAME + File.separator;
    public static String LOG_FILE_PREFIX = "sky_log_";
    public static String LOG_FILE_SUFFIX = ".txt";
    public static int index = 0;
    private static int defaultMaxFiles;
    private static int maxFiles;
    private static ExecutorService executorService;
    private static FileWriter fileWriter;
    private static int file_size;
    private static boolean isWriteToFile;

    public static void setIsWriteToFile(boolean isWriteToFile) {
        FLog.isWriteToFile = isWriteToFile;
    }

    public static void setDirName(String dirName) {
        LOG_FILE_DIR_NAME = dirName;
    }

    private static void init() {
        executorService = Executors.newSingleThreadScheduledExecutor();
        FLog.initIndex();
    }

    private static void initIndex() {
        File dir = new File(LOG_FILE_DIR);
        long modify = System.currentTimeMillis();
        String path = "";
        if (null != dir && dir.isDirectory()) {
            File[] files = dir.listFiles();
            if (null == files) {
                return;
            }
            for (File file : files) {
                if (null == file || !file.exists() || file.isDirectory()) continue;
                long fileModifyTime = file.lastModified();
                long tmpTime = System.currentTimeMillis() - fileModifyTime;
                if (tmpTime >= modify) continue;
                modify = tmpTime;
                path = file.getName();
            }
        }
        if (!TextUtils.isEmpty((CharSequence)path) && path.contains(LOG_FILE_PREFIX)) {
            boolean isNeedNewFile = new File(LOG_FILE_DIR + path).length() >= (long)file_size;
            index = Integer.valueOf(path.replace(LOG_FILE_PREFIX, "").replace(LOG_FILE_SUFFIX, ""));
            if (isNeedNewFile) {
                ++index;
                try {
                    FileUtils.deleteFile(LOG_FILE_DIR + FLog.getFileName());
                    FileUtils.createFile(LOG_FILE_DIR + FLog.getFileName());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static void setLogFilePrefix(String prefix) {
        if (!TextUtils.isEmpty((CharSequence)prefix) && !LOG_FILE_PREFIX.equals(prefix)) {
            index = 0;
        }
        LOG_FILE_PREFIX = prefix;
    }

    public static void setLogFileStuffix(String stuffix) {
        if (TextUtils.isEmpty((CharSequence)stuffix)) {
            return;
        }
        if (!stuffix.contains(".")) {
            stuffix = "." + stuffix;
        }
        if (!LOG_FILE_SUFFIX.equals(stuffix)) {
            index = 0;
        }
        LOG_FILE_SUFFIX = stuffix;
    }

    public static void setMaxFiles(int maxFiles) {
        FLog.maxFiles = maxFiles;
    }

    private static synchronized String getFileName() {
        if (index >= maxFiles) {
            index = 0;
        }
        return LOG_FILE_PREFIX + index + LOG_FILE_SUFFIX;
    }

    private static void checkFileSize() {
        File file = new File(LOG_FILE_DIR + FLog.getFileName());
        if (file.length() >= (long)file_size) {
            ++index;
            FileUtils.deleteFile(LOG_FILE_DIR + FLog.getFileName());
        }
    }

    private static void write(String tag, String format) {
        if (!isWriteToFile) {
            return;
        }
        final String str = DateFormat.format((CharSequence)"yyyy-MM-dd HH:mm:ss", (long)System.currentTimeMillis()).toString() + "   " + tag + "   " + format + "\n";
        executorService.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    FLog.checkFileSize();
                    FileUtils.createFile(LOG_FILE_DIR + FLog.getFileName());
                    fileWriter = new FileWriter(LOG_FILE_DIR + FLog.getFileName(), true);
                    fileWriter.write(str, 0, str.length());
                    fileWriter.flush();
                    fileWriter.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private static void prient(int priority, String tag, String msg) {
        if (priority >= 3) {
            Log.println((int)priority, (String)tag, (String)msg);
        }
    }

    public static void d(String tag, String format) {
        if (null == executorService) {
            FLog.init();
        }
        FLog.write(tag, format);
        FLog.prient(3, tag, format);
    }

    public static void e(String tag, String format) {
        if (null == executorService) {
            FLog.init();
        }
        FLog.write(tag, format);
        FLog.prient(6, tag, format);
    }

    public static void i(String tag, String format) {
        if (null == executorService) {
            FLog.init();
        }
        FLog.write(tag, format);
        FLog.prient(4, tag, format);
    }

    public static void w(String tag, String format) {
        if (null == executorService) {
            FLog.init();
        }
        FLog.write(tag, format);
        FLog.prient(5, tag, format);
    }

    static {
        maxFiles = defaultMaxFiles = 40;
        executorService = null;
        fileWriter = null;
        file_size = 512000;
        isWriteToFile = true;
    }
}

