/*
 * Decompiled with CFR 0.152.
 */
package org.dhatim.fastexcel;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.Date;

public final class TimestampUtil {
    private static final int BAD_DATE = -1;
    public static final int SECONDS_PER_MINUTE = 60;
    public static final int MINUTES_PER_HOUR = 60;
    public static final int HOURS_PER_DAY = 24;
    public static final int SECONDS_PER_DAY = 86400;
    public static final long DAY_MILLISECONDS = 86400000L;

    public static Double convertDate(Date date) {
        Calendar calStart = Calendar.getInstance();
        calStart.setTime(date);
        int year = calStart.get(1);
        int dayOfYear = calStart.get(6);
        int hour = calStart.get(11);
        int minute = calStart.get(12);
        int second = calStart.get(13);
        int milliSecond = calStart.get(14);
        return TimestampUtil.internalGetExcelDate(year, dayOfYear, hour, minute, second, milliSecond);
    }

    public static Double convertDate(LocalDateTime date) {
        int year = date.getYear();
        int dayOfYear = date.getDayOfYear();
        int hour = date.getHour();
        int minute = date.getMinute();
        int second = date.getSecond();
        int milliSecond = date.getNano() / 1000000;
        return TimestampUtil.internalGetExcelDate(year, dayOfYear, hour, minute, second, milliSecond);
    }

    public static Double convertDate(LocalDate date) {
        int year = date.getYear();
        int dayOfYear = date.getDayOfYear();
        int hour = 0;
        int minute = 0;
        int second = 0;
        int milliSecond = 0;
        return TimestampUtil.internalGetExcelDate(year, dayOfYear, hour, minute, second, milliSecond);
    }

    public static Double convertZonedDateTime(ZonedDateTime zdt) {
        return TimestampUtil.convertDate(zdt.toLocalDateTime());
    }

    private static double internalGetExcelDate(int year, int dayOfYear, int hour, int minute, int second, int milliSecond) {
        if (year < 1900) {
            return -1.0;
        }
        double fraction = ((((double)hour * 60.0 + (double)minute) * 60.0 + (double)second) * 1000.0 + (double)milliSecond) / 8.64E7;
        double value = fraction + (double)TimestampUtil.absoluteDay(year, dayOfYear);
        if (value >= 60.0) {
            value += 1.0;
        }
        return value;
    }

    private static int absoluteDay(int year, int dayOfYear) {
        return dayOfYear + TimestampUtil.daysInPriorYears(year);
    }

    static int daysInPriorYears(int yr) {
        if (yr < 1900) {
            throw new IllegalArgumentException("'year' must be 1900 or greater");
        }
        int yr1 = yr - 1;
        int leapDays = yr1 / 4 - yr1 / 100 + yr1 / 400 - 460;
        return 365 * (yr - 1900) + leapDays;
    }
}

