/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.deeplearning4j.omnihub;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import org.apache.commons.io.FileUtils;
import org.deeplearning4j.nn.graph.ComputationGraph;
import org.deeplearning4j.nn.multilayer.MultiLayerNetwork;
import org.deeplearning4j.omnihub.OmnihubConfig;
import org.eclipse.deeplearning4j.omnihub.ProgressInputStream;
import org.nd4j.autodiff.samediff.SameDiff;

public class OmniHubUtils {
    public static MultiLayerNetwork loadNetwork(String name) throws IOException {
        return OmniHubUtils.loadNetwork(name, false);
    }

    public static MultiLayerNetwork loadNetwork(String name, boolean forceDownload) throws IOException {
        return MultiLayerNetwork.load((File)OmniHubUtils.downloadAndLoadFromZoo("dl4j", name, forceDownload), (boolean)true);
    }

    public static ComputationGraph loadCompGraph(String name) throws IOException {
        return OmniHubUtils.loadCompGraph(name, false);
    }

    public static ComputationGraph loadCompGraph(String name, boolean forceDownload) throws IOException {
        return ComputationGraph.load((File)OmniHubUtils.downloadAndLoadFromZoo("dl4j", name, forceDownload), (boolean)true);
    }

    public static SameDiff loadSameDiffModel(String name) {
        return OmniHubUtils.loadSameDiffModel(name, false);
    }

    public static SameDiff loadSameDiffModel(String name, boolean forceDownload) {
        return SameDiff.load((File)OmniHubUtils.downloadAndLoadFromZoo("samediff", name, forceDownload), (boolean)true);
    }

    public static File downloadAndLoadFromZoo(String framework, String name, boolean forceDownload) {
        File destination = new File(OmnihubConfig.getOmnihubHome(), framework);
        File destFile = new File(destination, name);
        if (forceDownload && destFile.exists()) {
            destFile.delete();
        }
        if (!destFile.exists()) {
            String url = OmnihubConfig.getOmnihubUrl() + "/" + framework + "/" + name;
            URL remoteUrl = URI.create(url).toURL();
            long size = OmniHubUtils.getFileSize(remoteUrl);
            try (ProgressInputStream is = new ProgressInputStream(new BufferedInputStream(URI.create(url).toURL().openStream()), size);){
                FileUtils.copyInputStreamToFile((InputStream)((Object)is), (File)destFile);
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return destFile;
    }

    private static int getFileSize(URL url) {
        URLConnection conn = null;
        try {
            conn = url.openConnection();
            if (conn instanceof HttpURLConnection) {
                ((HttpURLConnection)conn).setRequestMethod("HEAD");
            }
            conn.getInputStream();
            int n = conn.getContentLength();
            return n;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (conn instanceof HttpURLConnection) {
                ((HttpURLConnection)conn).disconnect();
            }
        }
    }
}

