/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.deeplearning4j.omnihub;

import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Comparator;
import javax.lang.model.element.Modifier;
import org.apache.commons.io.FileUtils;
import org.deeplearning4j.nn.graph.ComputationGraph;
import org.deeplearning4j.nn.multilayer.MultiLayerNetwork;
import org.eclipse.deeplearning4j.omnihub.api.Model;
import org.eclipse.deeplearning4j.omnihub.api.NamespaceModels;
import org.eclipse.deeplearning4j.omnihub.frameworks.Dl4jModelsKt;
import org.eclipse.deeplearning4j.omnihub.frameworks.SameDiffModelsKt;
import org.nd4j.autodiff.samediff.SameDiff;

public class ModelNamespaceGenerator {
    private static String copyright = "/*\n *  ******************************************************************************\n *  *\n *  *\n *  * This program and the accompanying materials are made available under the\n *  * terms of the Apache License, Version 2.0 which is available at\n *  * https://www.apache.org/licenses/LICENSE-2.0.\n *  *\n *  *  See the NOTICE file distributed with this work for additional\n *  *  information regarding copyright ownership.\n *  * Unless required by applicable law or agreed to in writing, software\n *  * distributed under the License is distributed on an \"AS IS\" BASIS, WITHOUT\n *  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the\n *  * License for the specific language governing permissions and limitations\n *  * under the License.\n *  *\n *  * SPDX-License-Identifier: Apache-2.0\n *  *****************************************************************************\n */\n";
    private static String codeGenWarning = "\n//================== GENERATED CODE - DO NOT MODIFY THIS FILE ==================\n\n";

    public static void generateModels(NamespaceModels models, File outputDirectory, String className, String basePackage, String parentClass) throws IOException {
        TypeSpec.Builder builder = TypeSpec.classBuilder((String)className).addModifiers(new Modifier[]{Modifier.PUBLIC});
        models.getModels().stream().sorted(Comparator.comparing(Model::modelName)).forEachOrdered(model -> builder.addMethod(ModelNamespaceGenerator.createSignature(model)));
        ModelNamespaceGenerator.addDefaultConstructor(builder);
        TypeSpec spec = builder.build();
        String modelsPackage = "org.eclipse.deeplearning4j.omnihub.models";
        JavaFile jf = JavaFile.builder((String)"org.eclipse.deeplearning4j.omnihub.models", (TypeSpec)spec).build();
        StringBuilder sb = new StringBuilder();
        sb.append(copyright);
        sb.append(codeGenWarning);
        jf.writeTo((Appendable)sb);
        File outFile = new File(outputDirectory, ModelNamespaceGenerator.packageToDirectory(basePackage) + File.separator + className + ".java");
        FileUtils.writeStringToFile((File)outFile, (String)sb.toString(), (Charset)StandardCharsets.UTF_8);
        System.out.println("Wrote class to " + outFile.getAbsolutePath());
    }

    private static void addDefaultConstructor(TypeSpec.Builder builder) {
        MethodSpec noArg = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).build();
        builder.addMethod(noArg);
    }

    private static String packageToDirectory(String packageName) {
        return packageName.replace(".", File.separator);
    }

    public static MethodSpec createSignature(Model model) {
        MethodSpec.Builder c = MethodSpec.methodBuilder((String)model.modelName()).addModifiers(new Modifier[]{Modifier.PUBLIC}).addException(Exception.class).addJavadoc(model.documentation(), new Object[0]);
        c.addParameter(ParameterSpec.builder((TypeName)TypeName.BOOLEAN, (String)"forceDownload", (Modifier[])new Modifier[0]).build());
        String[] segmented = model.modelUrl().split("/");
        String modelFileName = segmented[segmented.length - 1];
        switch (model.framework()) {
            case DL4J: {
                switch (model.modelType()) {
                    case COMP_GRAPH: {
                        c.returns(ComputationGraph.class);
                        c.addStatement(CodeBlock.builder().add(String.format("return org.eclipse.deeplearning4j.omnihub.OmniHubUtils.loadCompGraph(\"%s\",forceDownload)", modelFileName), new Object[0]).build());
                        break;
                    }
                    case SEQUENTIAL: {
                        c.returns(MultiLayerNetwork.class);
                        c.addStatement(CodeBlock.builder().add(String.format("return org.eclipse.deeplearning4j.omnihub.OmniHubUtils.loadNetwork(\"%s\",forceDownload)", modelFileName), new Object[0]).build());
                    }
                }
                break;
            }
            case SAMEDIFF: {
                c.addStatement(CodeBlock.builder().add(String.format("return org.eclipse.deeplearning4j.omnihub.OmniHubUtils.loadSameDiffModel(\"%s\",forceDownload)", modelFileName), new Object[0]).build());
                c.returns(SameDiff.class);
            }
        }
        return c.build();
    }

    public static void main(String ... args) throws Exception {
        ModelNamespaceGenerator.generateModels(Dl4jModelsKt.Dl4jModels(), new File("./omnihub/src/main/java/"), "Dl4jModels", "org.eclipse.deeplearning4j.omnihub.models", "");
        ModelNamespaceGenerator.generateModels(SameDiffModelsKt.SameDiffModels(), new File("./omnihub/src/main/java/"), "SameDiffModels", "org.eclipse.deeplearning4j.omnihub.models", "");
    }
}

