/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.zoo.util.imagenet;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import org.deeplearning4j.common.resources.DL4JResources;
import org.deeplearning4j.zoo.util.BaseLabels;
import org.nd4j.base.Preconditions;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.shade.jackson.databind.ObjectMapper;

public class ImageNetLabels
extends BaseLabels {
    private static final String jsonResource = "imagenet_class_index.json";
    private ArrayList<String> predictionLabels = this.getLabels();

    @Override
    protected ArrayList<String> getLabels() throws IOException {
        File localFile = this.getResourceFile();
        if (this.predictionLabels == null) {
            HashMap jsonMap = (HashMap)new ObjectMapper().readValue(localFile, HashMap.class);
            this.predictionLabels = new ArrayList(jsonMap.size());
            for (int i = 0; i < jsonMap.size(); ++i) {
                this.predictionLabels.add((String)((ArrayList)jsonMap.get(String.valueOf(i))).get(1));
            }
        }
        return this.predictionLabels;
    }

    @Override
    public String getLabel(int n) {
        return this.predictionLabels.get(n);
    }

    @Override
    protected URL getURL() {
        try {
            return DL4JResources.getURL((String)"resources/imagenet/imagenet_class_index.json");
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected String resourceName() {
        return jsonResource;
    }

    @Override
    protected String resourceMD5() {
        return "c2c37ea517e94d9795004a39431a14cb";
    }

    public String decodePredictions(INDArray predictions) {
        Preconditions.checkState((predictions.size(1) == (long)this.predictionLabels.size() ? 1 : 0) != 0, (String)"Invalid input array: expected array with size(1) equal to numLabels (%s), got array with shape %s", (Object)this.predictionLabels.size(), (Object)predictions.shape());
        String predictionDescription = "";
        int[] top5 = new int[5];
        float[] top5Prob = new float[5];
        int i = 0;
        int batch = 0;
        while ((long)batch < predictions.size(0)) {
            predictionDescription = predictionDescription + "Predictions for batch ";
            if (predictions.size(0) > 1L) {
                predictionDescription = predictionDescription + String.valueOf(batch);
            }
            predictionDescription = predictionDescription + " :";
            INDArray currentBatch = predictions.getRow((long)batch).dup();
            while (i < 5) {
                top5[i] = Nd4j.argMax((INDArray)currentBatch, (int[])new int[]{1}).getInt(new int[]{0});
                top5Prob[i] = currentBatch.getFloat((long)batch, (long)top5[i]);
                currentBatch.putScalar(0L, (long)top5[i], 0.0);
                predictionDescription = predictionDescription + "\n\t" + String.format("%3f", Float.valueOf(top5Prob[i] * 100.0f)) + "%, " + this.predictionLabels.get(top5[i]);
                ++i;
            }
            ++batch;
        }
        return predictionDescription;
    }
}

