/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.zoo.model;

import java.util.Arrays;
import org.deeplearning4j.common.resources.DL4JResources;
import org.deeplearning4j.nn.api.Model;
import org.deeplearning4j.nn.api.OptimizationAlgorithm;
import org.deeplearning4j.nn.conf.CacheMode;
import org.deeplearning4j.nn.conf.ComputationGraphConfiguration;
import org.deeplearning4j.nn.conf.ConvolutionMode;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.conf.WorkspaceMode;
import org.deeplearning4j.nn.conf.graph.ElementWiseVertex;
import org.deeplearning4j.nn.conf.graph.GraphVertex;
import org.deeplearning4j.nn.conf.inputs.InputType;
import org.deeplearning4j.nn.conf.layers.ActivationLayer;
import org.deeplearning4j.nn.conf.layers.BatchNormalization;
import org.deeplearning4j.nn.conf.layers.ConvolutionLayer;
import org.deeplearning4j.nn.conf.layers.GlobalPoolingLayer;
import org.deeplearning4j.nn.conf.layers.Layer;
import org.deeplearning4j.nn.conf.layers.OutputLayer;
import org.deeplearning4j.nn.conf.layers.PoolingType;
import org.deeplearning4j.nn.conf.layers.SeparableConvolution2D;
import org.deeplearning4j.nn.conf.layers.SubsamplingLayer;
import org.deeplearning4j.nn.graph.ComputationGraph;
import org.deeplearning4j.nn.weights.WeightInit;
import org.deeplearning4j.zoo.ModelMetaData;
import org.deeplearning4j.zoo.PretrainedType;
import org.deeplearning4j.zoo.ZooModel;
import org.deeplearning4j.zoo.ZooType;
import org.nd4j.linalg.activations.Activation;
import org.nd4j.linalg.learning.config.AdaDelta;
import org.nd4j.linalg.learning.config.IUpdater;
import org.nd4j.linalg.lossfunctions.LossFunctions;

public class Xception
extends ZooModel {
    private long seed;
    private int[] inputShape;
    private int numClasses;
    private WeightInit weightInit;
    private IUpdater updater;
    private CacheMode cacheMode;
    private WorkspaceMode workspaceMode;
    private ConvolutionLayer.AlgoMode cudnnAlgoMode;

    private Xception() {
    }

    @Override
    public String pretrainedUrl(PretrainedType pretrainedType) {
        if (pretrainedType == PretrainedType.IMAGENET) {
            return DL4JResources.getURLString((String)"models/xception_dl4j_inference.v2.zip");
        }
        return null;
    }

    @Override
    public long pretrainedChecksum(PretrainedType pretrainedType) {
        if (pretrainedType == PretrainedType.IMAGENET) {
            return 3277876097L;
        }
        return 0L;
    }

    @Override
    public Class<? extends Model> modelType() {
        return ComputationGraph.class;
    }

    public ComputationGraph init() {
        ComputationGraphConfiguration.GraphBuilder graph = this.graphBuilder();
        graph.addInputs(new String[]{"input"}).setInputTypes(new InputType[]{InputType.convolutional((long)this.inputShape[2], (long)this.inputShape[1], (long)this.inputShape[0])});
        ComputationGraphConfiguration conf = graph.build();
        ComputationGraph model = new ComputationGraph(conf);
        model.init();
        return model;
    }

    public ComputationGraphConfiguration.GraphBuilder graphBuilder() {
        ComputationGraphConfiguration.GraphBuilder graph = new NeuralNetConfiguration.Builder().seed(this.seed).optimizationAlgo(OptimizationAlgorithm.STOCHASTIC_GRADIENT_DESCENT).updater(this.updater).weightInit(this.weightInit).l2(4.0E-5).miniBatch(true).cacheMode(this.cacheMode).trainingWorkspaceMode(this.workspaceMode).inferenceWorkspaceMode(this.workspaceMode).convolutionMode(ConvolutionMode.Truncate).graphBuilder();
        graph.addLayer("block1_conv1", (Layer)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)new ConvolutionLayer.Builder(new int[]{3, 3}).stride(new int[]{2, 2}).nOut(32)).hasBias(false)).cudnnAlgoMode(this.cudnnAlgoMode)).build(), new String[]{"input"}).addLayer("block1_conv1_bn", (Layer)new BatchNormalization(), new String[]{"block1_conv1"}).addLayer("block1_conv1_act", (Layer)new ActivationLayer(Activation.RELU), new String[]{"block1_conv1_bn"}).addLayer("block1_conv2", (Layer)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)new ConvolutionLayer.Builder(new int[]{3, 3}).stride(new int[]{1, 1}).nOut(64)).hasBias(false)).cudnnAlgoMode(this.cudnnAlgoMode)).build(), new String[]{"block1_conv1_act"}).addLayer("block1_conv2_bn", (Layer)new BatchNormalization(), new String[]{"block1_conv2"}).addLayer("block1_conv2_act", (Layer)new ActivationLayer(Activation.RELU), new String[]{"block1_conv2_bn"}).addLayer("residual1_conv", (Layer)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)new ConvolutionLayer.Builder(new int[]{1, 1}).stride(new int[]{2, 2}).nOut(128)).hasBias(false)).convolutionMode(ConvolutionMode.Same)).cudnnAlgoMode(this.cudnnAlgoMode)).build(), new String[]{"block1_conv2_act"}).addLayer("residual1", (Layer)new BatchNormalization(), new String[]{"residual1_conv"}).addLayer("block2_sepconv1", (Layer)((SeparableConvolution2D.Builder)((SeparableConvolution2D.Builder)((SeparableConvolution2D.Builder)((SeparableConvolution2D.Builder)new SeparableConvolution2D.Builder(new int[]{3, 3}).nOut(128)).hasBias(false)).convolutionMode(ConvolutionMode.Same)).cudnnAlgoMode(this.cudnnAlgoMode)).build(), new String[]{"block1_conv2_act"}).addLayer("block2_sepconv1_bn", (Layer)new BatchNormalization(), new String[]{"block2_sepconv1"}).addLayer("block2_sepconv1_act", (Layer)new ActivationLayer(Activation.RELU), new String[]{"block2_sepconv1_bn"}).addLayer("block2_sepconv2", (Layer)((SeparableConvolution2D.Builder)((SeparableConvolution2D.Builder)((SeparableConvolution2D.Builder)((SeparableConvolution2D.Builder)new SeparableConvolution2D.Builder(new int[]{3, 3}).nOut(128)).hasBias(false)).convolutionMode(ConvolutionMode.Same)).cudnnAlgoMode(this.cudnnAlgoMode)).build(), new String[]{"block2_sepconv1_act"}).addLayer("block2_sepconv2_bn", (Layer)new BatchNormalization(), new String[]{"block2_sepconv2"}).addLayer("block2_pool", (Layer)((SubsamplingLayer.Builder)new SubsamplingLayer.Builder(SubsamplingLayer.PoolingType.MAX).kernelSize(new int[]{3, 3}).stride(new int[]{2, 2}).convolutionMode(ConvolutionMode.Same)).build(), new String[]{"block2_sepconv2_bn"}).addVertex("add1", (GraphVertex)new ElementWiseVertex(ElementWiseVertex.Op.Add), new String[]{"block2_pool", "residual1"}).addLayer("residual2_conv", (Layer)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)new ConvolutionLayer.Builder(new int[]{1, 1}).stride(new int[]{2, 2}).nOut(256)).hasBias(false)).convolutionMode(ConvolutionMode.Same)).cudnnAlgoMode(this.cudnnAlgoMode)).build(), new String[]{"add1"}).addLayer("residual2", (Layer)new BatchNormalization(), new String[]{"residual2_conv"}).addLayer("block3_sepconv1_act", (Layer)new ActivationLayer(Activation.RELU), new String[]{"add1"}).addLayer("block3_sepconv1", (Layer)((SeparableConvolution2D.Builder)((SeparableConvolution2D.Builder)((SeparableConvolution2D.Builder)((SeparableConvolution2D.Builder)new SeparableConvolution2D.Builder(new int[]{3, 3}).nOut(256)).hasBias(false)).convolutionMode(ConvolutionMode.Same)).cudnnAlgoMode(this.cudnnAlgoMode)).build(), new String[]{"block3_sepconv1_act"}).addLayer("block3_sepconv1_bn", (Layer)new BatchNormalization(), new String[]{"block3_sepconv1"}).addLayer("block3_sepconv2_act", (Layer)new ActivationLayer(Activation.RELU), new String[]{"block3_sepconv1_bn"}).addLayer("block3_sepconv2", (Layer)((SeparableConvolution2D.Builder)((SeparableConvolution2D.Builder)((SeparableConvolution2D.Builder)((SeparableConvolution2D.Builder)new SeparableConvolution2D.Builder(new int[]{3, 3}).nOut(256)).hasBias(false)).convolutionMode(ConvolutionMode.Same)).cudnnAlgoMode(this.cudnnAlgoMode)).build(), new String[]{"block3_sepconv2_act"}).addLayer("block3_sepconv2_bn", (Layer)new BatchNormalization(), new String[]{"block3_sepconv2"}).addLayer("block3_pool", (Layer)((SubsamplingLayer.Builder)new SubsamplingLayer.Builder(SubsamplingLayer.PoolingType.MAX).kernelSize(new int[]{3, 3}).stride(new int[]{2, 2}).convolutionMode(ConvolutionMode.Same)).build(), new String[]{"block3_sepconv2_bn"}).addVertex("add2", (GraphVertex)new ElementWiseVertex(ElementWiseVertex.Op.Add), new String[]{"block3_pool", "residual2"}).addLayer("residual3_conv", (Layer)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)new ConvolutionLayer.Builder(new int[]{1, 1}).stride(new int[]{2, 2}).nOut(728)).hasBias(false)).convolutionMode(ConvolutionMode.Same)).cudnnAlgoMode(this.cudnnAlgoMode)).build(), new String[]{"add2"}).addLayer("residual3", (Layer)new BatchNormalization(), new String[]{"residual3_conv"}).addLayer("block4_sepconv1_act", (Layer)new ActivationLayer(Activation.RELU), new String[]{"add2"}).addLayer("block4_sepconv1", (Layer)((SeparableConvolution2D.Builder)((SeparableConvolution2D.Builder)((SeparableConvolution2D.Builder)((SeparableConvolution2D.Builder)new SeparableConvolution2D.Builder(new int[]{3, 3}).nOut(728)).hasBias(false)).convolutionMode(ConvolutionMode.Same)).cudnnAlgoMode(this.cudnnAlgoMode)).build(), new String[]{"block4_sepconv1_act"}).addLayer("block4_sepconv1_bn", (Layer)new BatchNormalization(), new String[]{"block4_sepconv1"}).addLayer("block4_sepconv2_act", (Layer)new ActivationLayer(Activation.RELU), new String[]{"block4_sepconv1_bn"}).addLayer("block4_sepconv2", (Layer)((SeparableConvolution2D.Builder)((SeparableConvolution2D.Builder)((SeparableConvolution2D.Builder)((SeparableConvolution2D.Builder)new SeparableConvolution2D.Builder(new int[]{3, 3}).nOut(728)).hasBias(false)).convolutionMode(ConvolutionMode.Same)).cudnnAlgoMode(this.cudnnAlgoMode)).build(), new String[]{"block4_sepconv2_act"}).addLayer("block4_sepconv2_bn", (Layer)new BatchNormalization(), new String[]{"block4_sepconv2"}).addLayer("block4_pool", (Layer)((SubsamplingLayer.Builder)new SubsamplingLayer.Builder(SubsamplingLayer.PoolingType.MAX).kernelSize(new int[]{3, 3}).stride(new int[]{2, 2}).convolutionMode(ConvolutionMode.Same)).build(), new String[]{"block4_sepconv2_bn"}).addVertex("add3", (GraphVertex)new ElementWiseVertex(ElementWiseVertex.Op.Add), new String[]{"block4_pool", "residual3"});
        int residual = 3;
        int block = 5;
        for (int i = 0; i < 8; ++i) {
            String previousInput = "add" + residual;
            String blockName = "block" + block;
            graph.addLayer(blockName + "_sepconv1_act", (Layer)new ActivationLayer(Activation.RELU), new String[]{previousInput}).addLayer(blockName + "_sepconv1", (Layer)((SeparableConvolution2D.Builder)((SeparableConvolution2D.Builder)((SeparableConvolution2D.Builder)((SeparableConvolution2D.Builder)new SeparableConvolution2D.Builder(new int[]{3, 3}).nOut(728)).hasBias(false)).convolutionMode(ConvolutionMode.Same)).cudnnAlgoMode(this.cudnnAlgoMode)).build(), new String[]{blockName + "_sepconv1_act"}).addLayer(blockName + "_sepconv1_bn", (Layer)new BatchNormalization(), new String[]{blockName + "_sepconv1"}).addLayer(blockName + "_sepconv2_act", (Layer)new ActivationLayer(Activation.RELU), new String[]{blockName + "_sepconv1_bn"}).addLayer(blockName + "_sepconv2", (Layer)((SeparableConvolution2D.Builder)((SeparableConvolution2D.Builder)((SeparableConvolution2D.Builder)((SeparableConvolution2D.Builder)new SeparableConvolution2D.Builder(new int[]{3, 3}).nOut(728)).hasBias(false)).convolutionMode(ConvolutionMode.Same)).cudnnAlgoMode(this.cudnnAlgoMode)).build(), new String[]{blockName + "_sepconv2_act"}).addLayer(blockName + "_sepconv2_bn", (Layer)new BatchNormalization(), new String[]{blockName + "_sepconv2"}).addLayer(blockName + "_sepconv3_act", (Layer)new ActivationLayer(Activation.RELU), new String[]{blockName + "_sepconv2_bn"}).addLayer(blockName + "_sepconv3", (Layer)((SeparableConvolution2D.Builder)((SeparableConvolution2D.Builder)((SeparableConvolution2D.Builder)((SeparableConvolution2D.Builder)new SeparableConvolution2D.Builder(new int[]{3, 3}).nOut(728)).hasBias(false)).convolutionMode(ConvolutionMode.Same)).cudnnAlgoMode(this.cudnnAlgoMode)).build(), new String[]{blockName + "_sepconv3_act"}).addLayer(blockName + "_sepconv3_bn", (Layer)new BatchNormalization(), new String[]{blockName + "_sepconv3"}).addVertex("add" + (residual + 1), (GraphVertex)new ElementWiseVertex(ElementWiseVertex.Op.Add), new String[]{blockName + "_sepconv3_bn", previousInput});
            ++residual;
            ++block;
        }
        graph.addLayer("residual12_conv", (Layer)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)new ConvolutionLayer.Builder(new int[]{1, 1}).stride(new int[]{2, 2}).nOut(1024)).hasBias(false)).convolutionMode(ConvolutionMode.Same)).cudnnAlgoMode(this.cudnnAlgoMode)).build(), new String[]{"add" + residual}).addLayer("residual12", (Layer)new BatchNormalization(), new String[]{"residual12_conv"});
        graph.addLayer("block13_sepconv1_act", (Layer)new ActivationLayer(Activation.RELU), new String[]{"add11"}).addLayer("block13_sepconv1", (Layer)((SeparableConvolution2D.Builder)((SeparableConvolution2D.Builder)((SeparableConvolution2D.Builder)((SeparableConvolution2D.Builder)new SeparableConvolution2D.Builder(new int[]{3, 3}).nOut(728)).hasBias(false)).convolutionMode(ConvolutionMode.Same)).cudnnAlgoMode(this.cudnnAlgoMode)).build(), new String[]{"block13_sepconv1_act"}).addLayer("block13_sepconv1_bn", (Layer)new BatchNormalization(), new String[]{"block13_sepconv1"}).addLayer("block13_sepconv2_act", (Layer)new ActivationLayer(Activation.RELU), new String[]{"block13_sepconv1_bn"}).addLayer("block13_sepconv2", (Layer)((SeparableConvolution2D.Builder)((SeparableConvolution2D.Builder)((SeparableConvolution2D.Builder)((SeparableConvolution2D.Builder)new SeparableConvolution2D.Builder(new int[]{3, 3}).nOut(1024)).hasBias(false)).convolutionMode(ConvolutionMode.Same)).cudnnAlgoMode(this.cudnnAlgoMode)).build(), new String[]{"block13_sepconv2_act"}).addLayer("block13_sepconv2_bn", (Layer)new BatchNormalization(), new String[]{"block13_sepconv2"}).addLayer("block13_pool", (Layer)((SubsamplingLayer.Builder)new SubsamplingLayer.Builder(SubsamplingLayer.PoolingType.MAX).kernelSize(new int[]{3, 3}).stride(new int[]{2, 2}).convolutionMode(ConvolutionMode.Same)).build(), new String[]{"block13_sepconv2_bn"}).addVertex("add12", (GraphVertex)new ElementWiseVertex(ElementWiseVertex.Op.Add), new String[]{"block13_pool", "residual12"});
        graph.addLayer("block14_sepconv1", (Layer)((SeparableConvolution2D.Builder)((SeparableConvolution2D.Builder)((SeparableConvolution2D.Builder)((SeparableConvolution2D.Builder)new SeparableConvolution2D.Builder(new int[]{3, 3}).nOut(1536)).hasBias(false)).convolutionMode(ConvolutionMode.Same)).cudnnAlgoMode(this.cudnnAlgoMode)).build(), new String[]{"add12"}).addLayer("block14_sepconv1_bn", (Layer)new BatchNormalization(), new String[]{"block14_sepconv1"}).addLayer("block14_sepconv1_act", (Layer)new ActivationLayer(Activation.RELU), new String[]{"block14_sepconv1_bn"}).addLayer("block14_sepconv2", (Layer)((SeparableConvolution2D.Builder)((SeparableConvolution2D.Builder)((SeparableConvolution2D.Builder)((SeparableConvolution2D.Builder)new SeparableConvolution2D.Builder(new int[]{3, 3}).nOut(2048)).hasBias(false)).convolutionMode(ConvolutionMode.Same)).cudnnAlgoMode(this.cudnnAlgoMode)).build(), new String[]{"block14_sepconv1_act"}).addLayer("block14_sepconv2_bn", (Layer)new BatchNormalization(), new String[]{"block14_sepconv2"}).addLayer("block14_sepconv2_act", (Layer)new ActivationLayer(Activation.RELU), new String[]{"block14_sepconv2_bn"}).addLayer("avg_pool", (Layer)new GlobalPoolingLayer.Builder(PoolingType.AVG).build(), new String[]{"block14_sepconv2_act"}).addLayer("predictions", (Layer)((OutputLayer.Builder)((OutputLayer.Builder)new OutputLayer.Builder(LossFunctions.LossFunction.MCXENT).nOut(this.numClasses)).activation(Activation.SOFTMAX)).build(), new String[]{"avg_pool"}).setOutputs(new String[]{"predictions"});
        return graph;
    }

    @Override
    public ModelMetaData metaData() {
        return new ModelMetaData(new int[][]{this.inputShape}, 1, ZooType.CNN);
    }

    @Override
    public void setInputShape(int[][] inputShape) {
        this.inputShape = inputShape[0];
    }

    private static long $default$seed() {
        return 1234L;
    }

    private static int[] $default$inputShape() {
        return new int[]{3, 299, 299};
    }

    private static int $default$numClasses() {
        return 0;
    }

    private static WeightInit $default$weightInit() {
        return WeightInit.RELU;
    }

    private static IUpdater $default$updater() {
        return new AdaDelta();
    }

    private static CacheMode $default$cacheMode() {
        return CacheMode.NONE;
    }

    private static WorkspaceMode $default$workspaceMode() {
        return WorkspaceMode.ENABLED;
    }

    private static ConvolutionLayer.AlgoMode $default$cudnnAlgoMode() {
        return ConvolutionLayer.AlgoMode.PREFER_FASTEST;
    }

    public static XceptionBuilder builder() {
        return new XceptionBuilder();
    }

    public Xception(long seed, int[] inputShape, int numClasses, WeightInit weightInit, IUpdater updater, CacheMode cacheMode, WorkspaceMode workspaceMode, ConvolutionLayer.AlgoMode cudnnAlgoMode) {
        this.seed = seed;
        this.inputShape = inputShape;
        this.numClasses = numClasses;
        this.weightInit = weightInit;
        this.updater = updater;
        this.cacheMode = cacheMode;
        this.workspaceMode = workspaceMode;
        this.cudnnAlgoMode = cudnnAlgoMode;
    }

    public static class XceptionBuilder {
        private boolean seed$set;
        private long seed;
        private boolean inputShape$set;
        private int[] inputShape;
        private boolean numClasses$set;
        private int numClasses;
        private boolean weightInit$set;
        private WeightInit weightInit;
        private boolean updater$set;
        private IUpdater updater;
        private boolean cacheMode$set;
        private CacheMode cacheMode;
        private boolean workspaceMode$set;
        private WorkspaceMode workspaceMode;
        private boolean cudnnAlgoMode$set;
        private ConvolutionLayer.AlgoMode cudnnAlgoMode;

        XceptionBuilder() {
        }

        public XceptionBuilder seed(long seed) {
            this.seed = seed;
            this.seed$set = true;
            return this;
        }

        public XceptionBuilder inputShape(int[] inputShape) {
            this.inputShape = inputShape;
            this.inputShape$set = true;
            return this;
        }

        public XceptionBuilder numClasses(int numClasses) {
            this.numClasses = numClasses;
            this.numClasses$set = true;
            return this;
        }

        public XceptionBuilder weightInit(WeightInit weightInit) {
            this.weightInit = weightInit;
            this.weightInit$set = true;
            return this;
        }

        public XceptionBuilder updater(IUpdater updater) {
            this.updater = updater;
            this.updater$set = true;
            return this;
        }

        public XceptionBuilder cacheMode(CacheMode cacheMode) {
            this.cacheMode = cacheMode;
            this.cacheMode$set = true;
            return this;
        }

        public XceptionBuilder workspaceMode(WorkspaceMode workspaceMode) {
            this.workspaceMode = workspaceMode;
            this.workspaceMode$set = true;
            return this;
        }

        public XceptionBuilder cudnnAlgoMode(ConvolutionLayer.AlgoMode cudnnAlgoMode) {
            this.cudnnAlgoMode = cudnnAlgoMode;
            this.cudnnAlgoMode$set = true;
            return this;
        }

        public Xception build() {
            long seed = this.seed;
            if (!this.seed$set) {
                seed = Xception.$default$seed();
            }
            int[] inputShape = this.inputShape;
            if (!this.inputShape$set) {
                inputShape = Xception.$default$inputShape();
            }
            int numClasses = this.numClasses;
            if (!this.numClasses$set) {
                numClasses = Xception.$default$numClasses();
            }
            WeightInit weightInit = this.weightInit;
            if (!this.weightInit$set) {
                weightInit = Xception.$default$weightInit();
            }
            IUpdater updater = this.updater;
            if (!this.updater$set) {
                updater = Xception.$default$updater();
            }
            CacheMode cacheMode = this.cacheMode;
            if (!this.cacheMode$set) {
                cacheMode = Xception.$default$cacheMode();
            }
            WorkspaceMode workspaceMode = this.workspaceMode;
            if (!this.workspaceMode$set) {
                workspaceMode = Xception.$default$workspaceMode();
            }
            ConvolutionLayer.AlgoMode cudnnAlgoMode = this.cudnnAlgoMode;
            if (!this.cudnnAlgoMode$set) {
                cudnnAlgoMode = Xception.$default$cudnnAlgoMode();
            }
            return new Xception(seed, inputShape, numClasses, weightInit, updater, cacheMode, workspaceMode, cudnnAlgoMode);
        }

        public String toString() {
            return "Xception.XceptionBuilder(seed=" + this.seed + ", inputShape=" + Arrays.toString(this.inputShape) + ", numClasses=" + this.numClasses + ", weightInit=" + this.weightInit + ", updater=" + this.updater + ", cacheMode=" + this.cacheMode + ", workspaceMode=" + this.workspaceMode + ", cudnnAlgoMode=" + this.cudnnAlgoMode + ")";
        }
    }
}

