/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.zoo.model;

import java.util.Arrays;
import org.deeplearning4j.common.resources.DL4JResources;
import org.deeplearning4j.nn.api.Model;
import org.deeplearning4j.nn.api.OptimizationAlgorithm;
import org.deeplearning4j.nn.conf.CacheMode;
import org.deeplearning4j.nn.conf.ComputationGraphConfiguration;
import org.deeplearning4j.nn.conf.ConvolutionMode;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.conf.WorkspaceMode;
import org.deeplearning4j.nn.conf.distribution.Distribution;
import org.deeplearning4j.nn.conf.distribution.TruncatedNormalDistribution;
import org.deeplearning4j.nn.conf.graph.GraphVertex;
import org.deeplearning4j.nn.conf.graph.MergeVertex;
import org.deeplearning4j.nn.conf.inputs.InputType;
import org.deeplearning4j.nn.conf.layers.CnnLossLayer;
import org.deeplearning4j.nn.conf.layers.ConvolutionLayer;
import org.deeplearning4j.nn.conf.layers.DropoutLayer;
import org.deeplearning4j.nn.conf.layers.Layer;
import org.deeplearning4j.nn.conf.layers.SubsamplingLayer;
import org.deeplearning4j.nn.conf.layers.Upsampling2D;
import org.deeplearning4j.nn.graph.ComputationGraph;
import org.deeplearning4j.nn.weights.WeightInit;
import org.deeplearning4j.zoo.ModelMetaData;
import org.deeplearning4j.zoo.PretrainedType;
import org.deeplearning4j.zoo.ZooModel;
import org.deeplearning4j.zoo.ZooType;
import org.nd4j.linalg.activations.Activation;
import org.nd4j.linalg.learning.config.AdaDelta;
import org.nd4j.linalg.learning.config.IUpdater;
import org.nd4j.linalg.lossfunctions.LossFunctions;

public class UNet
extends ZooModel {
    private long seed;
    private int[] inputShape;
    private int numClasses;
    private WeightInit weightInit;
    private IUpdater updater;
    private CacheMode cacheMode;
    private WorkspaceMode workspaceMode;
    private ConvolutionLayer.AlgoMode cudnnAlgoMode;

    private UNet() {
    }

    @Override
    public String pretrainedUrl(PretrainedType pretrainedType) {
        if (pretrainedType == PretrainedType.SEGMENT) {
            return DL4JResources.getURLString((String)"models/unet_dl4j_segment_inference.v1.zip");
        }
        return null;
    }

    @Override
    public long pretrainedChecksum(PretrainedType pretrainedType) {
        if (pretrainedType == PretrainedType.SEGMENT) {
            return 712347958L;
        }
        return 0L;
    }

    @Override
    public Class<? extends Model> modelType() {
        return ComputationGraph.class;
    }

    public ComputationGraph init() {
        ComputationGraphConfiguration.GraphBuilder graph = this.graphBuilder();
        graph.addInputs(new String[]{"input"}).setInputTypes(new InputType[]{InputType.convolutional((long)this.inputShape[2], (long)this.inputShape[1], (long)this.inputShape[0])});
        ComputationGraphConfiguration conf = graph.build();
        ComputationGraph model = new ComputationGraph(conf);
        model.init();
        return model;
    }

    public ComputationGraphConfiguration.GraphBuilder graphBuilder() {
        ComputationGraphConfiguration.GraphBuilder graph = new NeuralNetConfiguration.Builder().seed(this.seed).optimizationAlgo(OptimizationAlgorithm.STOCHASTIC_GRADIENT_DESCENT).updater(this.updater).weightInit(this.weightInit).dist((Distribution)new TruncatedNormalDistribution(0.0, 0.5)).l2(5.0E-5).miniBatch(true).cacheMode(this.cacheMode).trainingWorkspaceMode(this.workspaceMode).inferenceWorkspaceMode(this.workspaceMode).graphBuilder();
        graph.addLayer("conv1-1", (Layer)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)new ConvolutionLayer.Builder(new int[]{3, 3}).stride(new int[]{1, 1}).nOut(64)).convolutionMode(ConvolutionMode.Same)).cudnnAlgoMode(this.cudnnAlgoMode)).activation(Activation.RELU)).build(), new String[]{"input"}).addLayer("conv1-2", (Layer)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)new ConvolutionLayer.Builder(new int[]{3, 3}).stride(new int[]{1, 1}).nOut(64)).convolutionMode(ConvolutionMode.Same)).cudnnAlgoMode(this.cudnnAlgoMode)).activation(Activation.RELU)).build(), new String[]{"conv1-1"}).addLayer("pool1", (Layer)new SubsamplingLayer.Builder(SubsamplingLayer.PoolingType.MAX).kernelSize(new int[]{2, 2}).build(), new String[]{"conv1-2"}).addLayer("conv2-1", (Layer)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)new ConvolutionLayer.Builder(new int[]{3, 3}).stride(new int[]{1, 1}).nOut(128)).convolutionMode(ConvolutionMode.Same)).cudnnAlgoMode(this.cudnnAlgoMode)).activation(Activation.RELU)).build(), new String[]{"pool1"}).addLayer("conv2-2", (Layer)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)new ConvolutionLayer.Builder(new int[]{3, 3}).stride(new int[]{1, 1}).nOut(128)).convolutionMode(ConvolutionMode.Same)).cudnnAlgoMode(this.cudnnAlgoMode)).activation(Activation.RELU)).build(), new String[]{"conv2-1"}).addLayer("pool2", (Layer)new SubsamplingLayer.Builder(SubsamplingLayer.PoolingType.MAX).kernelSize(new int[]{2, 2}).build(), new String[]{"conv2-2"}).addLayer("conv3-1", (Layer)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)new ConvolutionLayer.Builder(new int[]{3, 3}).stride(new int[]{1, 1}).nOut(256)).convolutionMode(ConvolutionMode.Same)).cudnnAlgoMode(this.cudnnAlgoMode)).activation(Activation.RELU)).build(), new String[]{"pool2"}).addLayer("conv3-2", (Layer)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)new ConvolutionLayer.Builder(new int[]{3, 3}).stride(new int[]{1, 1}).nOut(256)).convolutionMode(ConvolutionMode.Same)).cudnnAlgoMode(this.cudnnAlgoMode)).activation(Activation.RELU)).build(), new String[]{"conv3-1"}).addLayer("pool3", (Layer)new SubsamplingLayer.Builder(SubsamplingLayer.PoolingType.MAX).kernelSize(new int[]{2, 2}).build(), new String[]{"conv3-2"}).addLayer("conv4-1", (Layer)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)new ConvolutionLayer.Builder(new int[]{3, 3}).stride(new int[]{1, 1}).nOut(512)).convolutionMode(ConvolutionMode.Same)).cudnnAlgoMode(this.cudnnAlgoMode)).activation(Activation.RELU)).build(), new String[]{"pool3"}).addLayer("conv4-2", (Layer)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)new ConvolutionLayer.Builder(new int[]{3, 3}).stride(new int[]{1, 1}).nOut(512)).convolutionMode(ConvolutionMode.Same)).cudnnAlgoMode(this.cudnnAlgoMode)).activation(Activation.RELU)).build(), new String[]{"conv4-1"}).addLayer("drop4", (Layer)new DropoutLayer.Builder(0.5).build(), new String[]{"conv4-2"}).addLayer("pool4", (Layer)new SubsamplingLayer.Builder(SubsamplingLayer.PoolingType.MAX).kernelSize(new int[]{2, 2}).build(), new String[]{"drop4"}).addLayer("conv5-1", (Layer)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)new ConvolutionLayer.Builder(new int[]{3, 3}).stride(new int[]{1, 1}).nOut(1024)).convolutionMode(ConvolutionMode.Same)).cudnnAlgoMode(this.cudnnAlgoMode)).activation(Activation.RELU)).build(), new String[]{"pool4"}).addLayer("conv5-2", (Layer)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)new ConvolutionLayer.Builder(new int[]{3, 3}).stride(new int[]{1, 1}).nOut(1024)).convolutionMode(ConvolutionMode.Same)).cudnnAlgoMode(this.cudnnAlgoMode)).activation(Activation.RELU)).build(), new String[]{"conv5-1"}).addLayer("drop5", (Layer)new DropoutLayer.Builder(0.5).build(), new String[]{"conv5-2"}).addLayer("up6-1", (Layer)new Upsampling2D.Builder(2).build(), new String[]{"drop5"}).addLayer("up6-2", (Layer)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)new ConvolutionLayer.Builder(new int[]{2, 2}).stride(new int[]{1, 1}).nOut(512)).convolutionMode(ConvolutionMode.Same)).cudnnAlgoMode(this.cudnnAlgoMode)).activation(Activation.RELU)).build(), new String[]{"up6-1"}).addVertex("merge6", (GraphVertex)new MergeVertex(), new String[]{"drop4", "up6-2"}).addLayer("conv6-1", (Layer)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)new ConvolutionLayer.Builder(new int[]{3, 3}).stride(new int[]{1, 1}).nOut(512)).convolutionMode(ConvolutionMode.Same)).cudnnAlgoMode(this.cudnnAlgoMode)).activation(Activation.RELU)).build(), new String[]{"merge6"}).addLayer("conv6-2", (Layer)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)new ConvolutionLayer.Builder(new int[]{3, 3}).stride(new int[]{1, 1}).nOut(512)).convolutionMode(ConvolutionMode.Same)).cudnnAlgoMode(this.cudnnAlgoMode)).activation(Activation.RELU)).build(), new String[]{"conv6-1"}).addLayer("up7-1", (Layer)new Upsampling2D.Builder(2).build(), new String[]{"conv6-2"}).addLayer("up7-2", (Layer)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)new ConvolutionLayer.Builder(new int[]{2, 2}).stride(new int[]{1, 1}).nOut(256)).convolutionMode(ConvolutionMode.Same)).cudnnAlgoMode(this.cudnnAlgoMode)).activation(Activation.RELU)).build(), new String[]{"up7-1"}).addVertex("merge7", (GraphVertex)new MergeVertex(), new String[]{"conv3-2", "up7-2"}).addLayer("conv7-1", (Layer)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)new ConvolutionLayer.Builder(new int[]{3, 3}).stride(new int[]{1, 1}).nOut(256)).convolutionMode(ConvolutionMode.Same)).cudnnAlgoMode(this.cudnnAlgoMode)).activation(Activation.RELU)).build(), new String[]{"merge7"}).addLayer("conv7-2", (Layer)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)new ConvolutionLayer.Builder(new int[]{3, 3}).stride(new int[]{1, 1}).nOut(256)).convolutionMode(ConvolutionMode.Same)).cudnnAlgoMode(this.cudnnAlgoMode)).activation(Activation.RELU)).build(), new String[]{"conv7-1"}).addLayer("up8-1", (Layer)new Upsampling2D.Builder(2).build(), new String[]{"conv7-2"}).addLayer("up8-2", (Layer)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)new ConvolutionLayer.Builder(new int[]{2, 2}).stride(new int[]{1, 1}).nOut(128)).convolutionMode(ConvolutionMode.Same)).cudnnAlgoMode(this.cudnnAlgoMode)).activation(Activation.RELU)).build(), new String[]{"up8-1"}).addVertex("merge8", (GraphVertex)new MergeVertex(), new String[]{"conv2-2", "up8-2"}).addLayer("conv8-1", (Layer)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)new ConvolutionLayer.Builder(new int[]{3, 3}).stride(new int[]{1, 1}).nOut(128)).convolutionMode(ConvolutionMode.Same)).cudnnAlgoMode(this.cudnnAlgoMode)).activation(Activation.RELU)).build(), new String[]{"merge8"}).addLayer("conv8-2", (Layer)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)new ConvolutionLayer.Builder(new int[]{3, 3}).stride(new int[]{1, 1}).nOut(128)).convolutionMode(ConvolutionMode.Same)).cudnnAlgoMode(this.cudnnAlgoMode)).activation(Activation.RELU)).build(), new String[]{"conv8-1"}).addLayer("up9-1", (Layer)new Upsampling2D.Builder(2).build(), new String[]{"conv8-2"}).addLayer("up9-2", (Layer)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)new ConvolutionLayer.Builder(new int[]{2, 2}).stride(new int[]{1, 1}).nOut(64)).convolutionMode(ConvolutionMode.Same)).cudnnAlgoMode(this.cudnnAlgoMode)).activation(Activation.RELU)).build(), new String[]{"up9-1"}).addVertex("merge9", (GraphVertex)new MergeVertex(), new String[]{"conv1-2", "up9-2"}).addLayer("conv9-1", (Layer)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)new ConvolutionLayer.Builder(new int[]{3, 3}).stride(new int[]{1, 1}).nOut(64)).convolutionMode(ConvolutionMode.Same)).cudnnAlgoMode(this.cudnnAlgoMode)).activation(Activation.RELU)).build(), new String[]{"merge9"}).addLayer("conv9-2", (Layer)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)new ConvolutionLayer.Builder(new int[]{3, 3}).stride(new int[]{1, 1}).nOut(64)).convolutionMode(ConvolutionMode.Same)).cudnnAlgoMode(this.cudnnAlgoMode)).activation(Activation.RELU)).build(), new String[]{"conv9-1"}).addLayer("conv9-3", (Layer)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)new ConvolutionLayer.Builder(new int[]{3, 3}).stride(new int[]{1, 1}).nOut(2)).convolutionMode(ConvolutionMode.Same)).cudnnAlgoMode(this.cudnnAlgoMode)).activation(Activation.RELU)).build(), new String[]{"conv9-2"}).addLayer("conv10", (Layer)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)new ConvolutionLayer.Builder(new int[]{3, 3}).stride(new int[]{1, 1}).nOut(1)).convolutionMode(ConvolutionMode.Same)).cudnnAlgoMode(this.cudnnAlgoMode)).activation(Activation.SIGMOID)).build(), new String[]{"conv9-3"}).addLayer("output", (Layer)((CnnLossLayer.Builder)new CnnLossLayer.Builder(LossFunctions.LossFunction.MCXENT).activation(Activation.SOFTMAX)).build(), new String[]{"conv10"}).setOutputs(new String[]{"output"});
        return graph;
    }

    @Override
    public ModelMetaData metaData() {
        return new ModelMetaData(new int[][]{this.inputShape}, 1, ZooType.CNN);
    }

    @Override
    public void setInputShape(int[][] inputShape) {
        this.inputShape = inputShape[0];
    }

    private static long $default$seed() {
        return 1234L;
    }

    private static int[] $default$inputShape() {
        return new int[]{3, 512, 512};
    }

    private static int $default$numClasses() {
        return 0;
    }

    private static WeightInit $default$weightInit() {
        return WeightInit.RELU;
    }

    private static IUpdater $default$updater() {
        return new AdaDelta();
    }

    private static CacheMode $default$cacheMode() {
        return CacheMode.NONE;
    }

    private static WorkspaceMode $default$workspaceMode() {
        return WorkspaceMode.ENABLED;
    }

    private static ConvolutionLayer.AlgoMode $default$cudnnAlgoMode() {
        return ConvolutionLayer.AlgoMode.PREFER_FASTEST;
    }

    public static UNetBuilder builder() {
        return new UNetBuilder();
    }

    public UNet(long seed, int[] inputShape, int numClasses, WeightInit weightInit, IUpdater updater, CacheMode cacheMode, WorkspaceMode workspaceMode, ConvolutionLayer.AlgoMode cudnnAlgoMode) {
        this.seed = seed;
        this.inputShape = inputShape;
        this.numClasses = numClasses;
        this.weightInit = weightInit;
        this.updater = updater;
        this.cacheMode = cacheMode;
        this.workspaceMode = workspaceMode;
        this.cudnnAlgoMode = cudnnAlgoMode;
    }

    public static class UNetBuilder {
        private boolean seed$set;
        private long seed;
        private boolean inputShape$set;
        private int[] inputShape;
        private boolean numClasses$set;
        private int numClasses;
        private boolean weightInit$set;
        private WeightInit weightInit;
        private boolean updater$set;
        private IUpdater updater;
        private boolean cacheMode$set;
        private CacheMode cacheMode;
        private boolean workspaceMode$set;
        private WorkspaceMode workspaceMode;
        private boolean cudnnAlgoMode$set;
        private ConvolutionLayer.AlgoMode cudnnAlgoMode;

        UNetBuilder() {
        }

        public UNetBuilder seed(long seed) {
            this.seed = seed;
            this.seed$set = true;
            return this;
        }

        public UNetBuilder inputShape(int[] inputShape) {
            this.inputShape = inputShape;
            this.inputShape$set = true;
            return this;
        }

        public UNetBuilder numClasses(int numClasses) {
            this.numClasses = numClasses;
            this.numClasses$set = true;
            return this;
        }

        public UNetBuilder weightInit(WeightInit weightInit) {
            this.weightInit = weightInit;
            this.weightInit$set = true;
            return this;
        }

        public UNetBuilder updater(IUpdater updater) {
            this.updater = updater;
            this.updater$set = true;
            return this;
        }

        public UNetBuilder cacheMode(CacheMode cacheMode) {
            this.cacheMode = cacheMode;
            this.cacheMode$set = true;
            return this;
        }

        public UNetBuilder workspaceMode(WorkspaceMode workspaceMode) {
            this.workspaceMode = workspaceMode;
            this.workspaceMode$set = true;
            return this;
        }

        public UNetBuilder cudnnAlgoMode(ConvolutionLayer.AlgoMode cudnnAlgoMode) {
            this.cudnnAlgoMode = cudnnAlgoMode;
            this.cudnnAlgoMode$set = true;
            return this;
        }

        public UNet build() {
            long seed = this.seed;
            if (!this.seed$set) {
                seed = UNet.$default$seed();
            }
            int[] inputShape = this.inputShape;
            if (!this.inputShape$set) {
                inputShape = UNet.$default$inputShape();
            }
            int numClasses = this.numClasses;
            if (!this.numClasses$set) {
                numClasses = UNet.$default$numClasses();
            }
            WeightInit weightInit = this.weightInit;
            if (!this.weightInit$set) {
                weightInit = UNet.$default$weightInit();
            }
            IUpdater updater = this.updater;
            if (!this.updater$set) {
                updater = UNet.$default$updater();
            }
            CacheMode cacheMode = this.cacheMode;
            if (!this.cacheMode$set) {
                cacheMode = UNet.$default$cacheMode();
            }
            WorkspaceMode workspaceMode = this.workspaceMode;
            if (!this.workspaceMode$set) {
                workspaceMode = UNet.$default$workspaceMode();
            }
            ConvolutionLayer.AlgoMode cudnnAlgoMode = this.cudnnAlgoMode;
            if (!this.cudnnAlgoMode$set) {
                cudnnAlgoMode = UNet.$default$cudnnAlgoMode();
            }
            return new UNet(seed, inputShape, numClasses, weightInit, updater, cacheMode, workspaceMode, cudnnAlgoMode);
        }

        public String toString() {
            return "UNet.UNetBuilder(seed=" + this.seed + ", inputShape=" + Arrays.toString(this.inputShape) + ", numClasses=" + this.numClasses + ", weightInit=" + this.weightInit + ", updater=" + this.updater + ", cacheMode=" + this.cacheMode + ", workspaceMode=" + this.workspaceMode + ", cudnnAlgoMode=" + this.cudnnAlgoMode + ")";
        }
    }
}

