/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.zoo.model;

import org.deeplearning4j.nn.api.Model;
import org.deeplearning4j.nn.api.OptimizationAlgorithm;
import org.deeplearning4j.nn.conf.ComputationGraphConfiguration;
import org.deeplearning4j.nn.conf.ConvolutionMode;
import org.deeplearning4j.nn.conf.GradientNormalization;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.conf.WorkspaceMode;
import org.deeplearning4j.nn.conf.graph.GraphVertex;
import org.deeplearning4j.nn.conf.graph.MergeVertex;
import org.deeplearning4j.nn.conf.inputs.InputType;
import org.deeplearning4j.nn.conf.layers.ConvolutionLayer;
import org.deeplearning4j.nn.conf.layers.Layer;
import org.deeplearning4j.nn.conf.layers.SpaceToDepthLayer;
import org.deeplearning4j.nn.conf.layers.objdetect.Yolo2OutputLayer;
import org.deeplearning4j.nn.graph.ComputationGraph;
import org.deeplearning4j.nn.weights.WeightInit;
import org.deeplearning4j.zoo.ModelMetaData;
import org.deeplearning4j.zoo.PretrainedType;
import org.deeplearning4j.zoo.ZooModel;
import org.deeplearning4j.zoo.ZooType;
import org.deeplearning4j.zoo.model.helper.DarknetHelper;
import org.nd4j.linalg.activations.Activation;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.learning.config.Adam;
import org.nd4j.linalg.learning.config.IUpdater;

public class YOLO2
extends ZooModel {
    public static int nBoxes = 5;
    public static double[][] priorBoxes = new double[][]{{0.57273, 0.677385}, {1.87446, 2.06253}, {3.33843, 5.47434}, {7.88282, 3.52778}, {9.77052, 9.16828}};
    private int[] inputShape = new int[]{3, 608, 608};
    private int numLabels;
    private long seed;
    private WorkspaceMode workspaceMode;
    private ConvolutionLayer.AlgoMode cudnnAlgoMode;

    public YOLO2(int numLabels, long seed) {
        this(numLabels, seed, WorkspaceMode.SEPARATE);
    }

    public YOLO2(int numLabels, long seed, WorkspaceMode workspaceMode) {
        this.numLabels = numLabels;
        this.seed = seed;
        this.workspaceMode = workspaceMode;
        this.cudnnAlgoMode = workspaceMode == WorkspaceMode.SINGLE ? ConvolutionLayer.AlgoMode.PREFER_FASTEST : ConvolutionLayer.AlgoMode.NO_WORKSPACE;
    }

    @Override
    public String pretrainedUrl(PretrainedType pretrainedType) {
        if (pretrainedType == PretrainedType.IMAGENET) {
            return "http://blob.deeplearning4j.org/models/yolo2_dl4j_inference.v1.zip";
        }
        return null;
    }

    @Override
    public long pretrainedChecksum(PretrainedType pretrainedType) {
        if (pretrainedType == PretrainedType.IMAGENET) {
            return 1357637732L;
        }
        return 0L;
    }

    @Override
    public ZooType zooType() {
        return ZooType.YOLO2;
    }

    @Override
    public Class<? extends Model> modelType() {
        return ComputationGraph.class;
    }

    public ComputationGraphConfiguration conf() {
        INDArray priors = Nd4j.create((double[][])priorBoxes);
        ComputationGraphConfiguration.GraphBuilder graphBuilder = new NeuralNetConfiguration.Builder().seed(this.seed).optimizationAlgo(OptimizationAlgorithm.STOCHASTIC_GRADIENT_DESCENT).gradientNormalization(GradientNormalization.RenormalizeL2PerLayer).gradientNormalizationThreshold(1.0).updater((IUpdater)new Adam.Builder().learningRate(0.001).build()).l2(1.0E-5).activation(Activation.IDENTITY).trainingWorkspaceMode(this.workspaceMode).inferenceWorkspaceMode(this.workspaceMode).cudnnAlgoMode(this.cudnnAlgoMode).graphBuilder().addInputs(new String[]{"input"}).setInputTypes(new InputType[]{InputType.convolutional((int)this.inputShape[2], (int)this.inputShape[1], (int)this.inputShape[0])});
        DarknetHelper.addLayers(graphBuilder, 1, 3, this.inputShape[0], 32, 2);
        DarknetHelper.addLayers(graphBuilder, 2, 3, 32, 64, 2);
        DarknetHelper.addLayers(graphBuilder, 3, 3, 64, 128, 0);
        DarknetHelper.addLayers(graphBuilder, 4, 1, 128, 64, 0);
        DarknetHelper.addLayers(graphBuilder, 5, 3, 64, 128, 2);
        DarknetHelper.addLayers(graphBuilder, 6, 3, 128, 256, 0);
        DarknetHelper.addLayers(graphBuilder, 7, 1, 256, 128, 0);
        DarknetHelper.addLayers(graphBuilder, 8, 3, 128, 256, 2);
        DarknetHelper.addLayers(graphBuilder, 9, 3, 256, 512, 0);
        DarknetHelper.addLayers(graphBuilder, 10, 1, 512, 256, 0);
        DarknetHelper.addLayers(graphBuilder, 11, 3, 256, 512, 0);
        DarknetHelper.addLayers(graphBuilder, 12, 1, 512, 256, 0);
        DarknetHelper.addLayers(graphBuilder, 13, 3, 256, 512, 2);
        DarknetHelper.addLayers(graphBuilder, 14, 3, 512, 1024, 0);
        DarknetHelper.addLayers(graphBuilder, 15, 1, 1024, 512, 0);
        DarknetHelper.addLayers(graphBuilder, 16, 3, 512, 1024, 0);
        DarknetHelper.addLayers(graphBuilder, 17, 1, 1024, 512, 0);
        DarknetHelper.addLayers(graphBuilder, 18, 3, 512, 1024, 0);
        DarknetHelper.addLayers(graphBuilder, 19, 3, 1024, 1024, 0);
        DarknetHelper.addLayers(graphBuilder, 20, 3, 1024, 1024, 0);
        DarknetHelper.addLayers(graphBuilder, 21, "activation_13", 1, 512, 64, 0, 0);
        graphBuilder.addLayer("rearrange_21", (Layer)new SpaceToDepthLayer.Builder(2).build(), new String[]{"activation_21"}).addVertex("concatenate_21", (GraphVertex)new MergeVertex(), new String[]{"rearrange_21", "activation_20"});
        DarknetHelper.addLayers(graphBuilder, 22, "concatenate_21", 3, 1280, 1024, 0, 0);
        graphBuilder.addLayer("convolution2d_23", (Layer)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)new ConvolutionLayer.Builder(new int[]{1, 1}).nIn(1024)).nOut(nBoxes * (5 + this.numLabels))).weightInit(WeightInit.XAVIER)).stride(new int[]{1, 1}).convolutionMode(ConvolutionMode.Same)).weightInit(WeightInit.RELU)).activation(Activation.IDENTITY)).build(), new String[]{"activation_22"}).addLayer("outputs", (Layer)new Yolo2OutputLayer.Builder().boundingBoxPriors(priors).build(), new String[]{"convolution2d_23"}).setOutputs(new String[]{"outputs"}).backprop(true).pretrain(false);
        return graphBuilder.build();
    }

    public ComputationGraph init() {
        ComputationGraph model = new ComputationGraph(this.conf());
        model.init();
        return model;
    }

    @Override
    public ModelMetaData metaData() {
        return new ModelMetaData(new int[][]{this.inputShape}, 1, ZooType.CNN);
    }

    @Override
    public void setInputShape(int[][] inputShape) {
        this.inputShape = inputShape[0];
    }

    public YOLO2() {
    }
}

