/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.zoo.model.helper;

import org.deeplearning4j.nn.conf.ComputationGraphConfiguration;
import org.deeplearning4j.nn.conf.ConvolutionMode;
import org.deeplearning4j.nn.conf.layers.ActivationLayer;
import org.deeplearning4j.nn.conf.layers.BatchNormalization;
import org.deeplearning4j.nn.conf.layers.ConvolutionLayer;
import org.deeplearning4j.nn.conf.layers.Layer;
import org.deeplearning4j.nn.conf.layers.SubsamplingLayer;
import org.deeplearning4j.nn.weights.WeightInit;
import org.nd4j.linalg.activations.Activation;
import org.nd4j.linalg.activations.IActivation;
import org.nd4j.linalg.activations.impl.ActivationLReLU;

public class DarknetHelper {
    public static int getGridWidth(int[] inputShape) {
        return inputShape[1] / 32;
    }

    public static int getGridHeight(int[] inputShape) {
        return inputShape[2] / 32;
    }

    public static ComputationGraphConfiguration.GraphBuilder addLayers(ComputationGraphConfiguration.GraphBuilder graphBuilder, int layerNumber, int filterSize, int nIn, int nOut, int poolSize) {
        return DarknetHelper.addLayers(graphBuilder, layerNumber, filterSize, nIn, nOut, poolSize, poolSize);
    }

    public static ComputationGraphConfiguration.GraphBuilder addLayers(ComputationGraphConfiguration.GraphBuilder graphBuilder, int layerNumber, int filterSize, int nIn, int nOut, int poolSize, int poolStride) {
        Object input = "maxpooling2d_" + (layerNumber - 1);
        if (!graphBuilder.getVertices().containsKey(input)) {
            input = "activation_" + (layerNumber - 1);
        }
        if (!graphBuilder.getVertices().containsKey(input)) {
            input = "concatenate_" + (layerNumber - 1);
        }
        if (!graphBuilder.getVertices().containsKey(input)) {
            input = "input";
        }
        return DarknetHelper.addLayers(graphBuilder, layerNumber, (String)input, filterSize, nIn, nOut, poolSize, poolStride);
    }

    public static ComputationGraphConfiguration.GraphBuilder addLayers(ComputationGraphConfiguration.GraphBuilder graphBuilder, int layerNumber, String input, int filterSize, int nIn, int nOut, int poolSize, int poolStride) {
        graphBuilder.addLayer("convolution2d_" + layerNumber, (Layer)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)new ConvolutionLayer.Builder(new int[]{filterSize, filterSize}).nIn(nIn)).nOut(nOut)).weightInit(WeightInit.XAVIER)).convolutionMode(ConvolutionMode.Same)).hasBias(false)).stride(new int[]{1, 1}).activation(Activation.IDENTITY)).build(), new String[]{input}).addLayer("batchnormalization_" + layerNumber, (Layer)((BatchNormalization.Builder)((BatchNormalization.Builder)((BatchNormalization.Builder)((BatchNormalization.Builder)new BatchNormalization.Builder().nIn(nOut)).nOut(nOut)).weightInit(WeightInit.XAVIER)).activation(Activation.IDENTITY)).build(), new String[]{"convolution2d_" + layerNumber}).addLayer("activation_" + layerNumber, (Layer)new ActivationLayer.Builder().activation((IActivation)new ActivationLReLU(0.1)).build(), new String[]{"batchnormalization_" + layerNumber});
        if (poolSize > 0) {
            graphBuilder.addLayer("maxpooling2d_" + layerNumber, (Layer)((SubsamplingLayer.Builder)new SubsamplingLayer.Builder().kernelSize(new int[]{poolSize, poolSize}).stride(new int[]{poolStride, poolStride}).convolutionMode(ConvolutionMode.Same)).build(), new String[]{"activation_" + layerNumber});
        }
        return graphBuilder;
    }
}

