/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.zoo.model;

import java.util.Arrays;
import org.deeplearning4j.common.resources.DL4JResources;
import org.deeplearning4j.nn.api.Model;
import org.deeplearning4j.nn.api.OptimizationAlgorithm;
import org.deeplearning4j.nn.conf.CacheMode;
import org.deeplearning4j.nn.conf.ComputationGraphConfiguration;
import org.deeplearning4j.nn.conf.ConvolutionMode;
import org.deeplearning4j.nn.conf.GradientNormalization;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.conf.WorkspaceMode;
import org.deeplearning4j.nn.conf.inputs.InputType;
import org.deeplearning4j.nn.conf.layers.ConvolutionLayer;
import org.deeplearning4j.nn.conf.layers.Layer;
import org.deeplearning4j.nn.conf.layers.objdetect.Yolo2OutputLayer;
import org.deeplearning4j.nn.graph.ComputationGraph;
import org.deeplearning4j.nn.weights.WeightInit;
import org.deeplearning4j.zoo.ModelMetaData;
import org.deeplearning4j.zoo.PretrainedType;
import org.deeplearning4j.zoo.ZooModel;
import org.deeplearning4j.zoo.ZooType;
import org.deeplearning4j.zoo.model.helper.DarknetHelper;
import org.nd4j.linalg.activations.Activation;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.learning.config.Adam;
import org.nd4j.linalg.learning.config.IUpdater;

public class TinyYOLO
extends ZooModel {
    private int nBoxes;
    private double[][] priorBoxes;
    private long seed;
    private int[] inputShape;
    private int numClasses;
    private IUpdater updater;
    private CacheMode cacheMode;
    private WorkspaceMode workspaceMode;
    private ConvolutionLayer.AlgoMode cudnnAlgoMode;

    private TinyYOLO() {
    }

    @Override
    public String pretrainedUrl(PretrainedType pretrainedType) {
        if (pretrainedType == PretrainedType.IMAGENET) {
            return DL4JResources.getURLString((String)"models/tiny-yolo-voc_dl4j_inference.v2.zip");
        }
        return null;
    }

    @Override
    public long pretrainedChecksum(PretrainedType pretrainedType) {
        if (pretrainedType == PretrainedType.IMAGENET) {
            return 1256226465L;
        }
        return 0L;
    }

    @Override
    public Class<? extends Model> modelType() {
        return ComputationGraph.class;
    }

    public ComputationGraphConfiguration conf() {
        INDArray priors = Nd4j.create((double[][])this.priorBoxes);
        ComputationGraphConfiguration.GraphBuilder graphBuilder = new NeuralNetConfiguration.Builder().seed(this.seed).optimizationAlgo(OptimizationAlgorithm.STOCHASTIC_GRADIENT_DESCENT).gradientNormalization(GradientNormalization.RenormalizeL2PerLayer).gradientNormalizationThreshold(1.0).updater(this.updater).l2(1.0E-5).activation(Activation.IDENTITY).cacheMode(this.cacheMode).trainingWorkspaceMode(this.workspaceMode).inferenceWorkspaceMode(this.workspaceMode).cudnnAlgoMode(this.cudnnAlgoMode).graphBuilder().addInputs(new String[]{"input"}).setInputTypes(new InputType[]{InputType.convolutional((long)this.inputShape[2], (long)this.inputShape[1], (long)this.inputShape[0])});
        DarknetHelper.addLayers(graphBuilder, 1, 3, this.inputShape[0], 16, 2, 2);
        DarknetHelper.addLayers(graphBuilder, 2, 3, 16, 32, 2, 2);
        DarknetHelper.addLayers(graphBuilder, 3, 3, 32, 64, 2, 2);
        DarknetHelper.addLayers(graphBuilder, 4, 3, 64, 128, 2, 2);
        DarknetHelper.addLayers(graphBuilder, 5, 3, 128, 256, 2, 2);
        DarknetHelper.addLayers(graphBuilder, 6, 3, 256, 512, 2, 1);
        DarknetHelper.addLayers(graphBuilder, 7, 3, 512, 1024, 0, 0);
        DarknetHelper.addLayers(graphBuilder, 8, 3, 1024, 1024, 0, 0);
        int layerNumber = 9;
        graphBuilder.addLayer("convolution2d_" + layerNumber, (Layer)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)new ConvolutionLayer.Builder(new int[]{1, 1}).nIn(1024)).nOut(this.nBoxes * (5 + this.numClasses))).weightInit(WeightInit.XAVIER)).stride(new int[]{1, 1}).convolutionMode(ConvolutionMode.Same)).weightInit(WeightInit.RELU)).activation(Activation.IDENTITY)).build(), new String[]{"activation_" + (layerNumber - 1)}).addLayer("outputs", (Layer)new Yolo2OutputLayer.Builder().boundingBoxPriors(priors).build(), new String[]{"convolution2d_" + layerNumber}).setOutputs(new String[]{"outputs"});
        return graphBuilder.build();
    }

    public ComputationGraph init() {
        ComputationGraph model = new ComputationGraph(this.conf());
        model.init();
        return model;
    }

    @Override
    public ModelMetaData metaData() {
        return new ModelMetaData(new int[][]{this.inputShape}, 1, ZooType.CNN);
    }

    @Override
    public void setInputShape(int[][] inputShape) {
        this.inputShape = inputShape[0];
    }

    private static int $default$nBoxes() {
        return 5;
    }

    private static double[][] $default$priorBoxes() {
        return new double[][]{{1.08, 1.19}, {3.42, 4.41}, {6.63, 11.38}, {9.42, 5.11}, {16.62, 10.52}};
    }

    private static long $default$seed() {
        return 1234L;
    }

    private static int[] $default$inputShape() {
        return new int[]{3, 416, 416};
    }

    private static int $default$numClasses() {
        return 0;
    }

    private static IUpdater $default$updater() {
        return new Adam(0.001);
    }

    private static CacheMode $default$cacheMode() {
        return CacheMode.NONE;
    }

    private static WorkspaceMode $default$workspaceMode() {
        return WorkspaceMode.ENABLED;
    }

    private static ConvolutionLayer.AlgoMode $default$cudnnAlgoMode() {
        return ConvolutionLayer.AlgoMode.PREFER_FASTEST;
    }

    public static TinyYOLOBuilder builder() {
        return new TinyYOLOBuilder();
    }

    public TinyYOLO(int nBoxes, double[][] priorBoxes, long seed, int[] inputShape, int numClasses, IUpdater updater, CacheMode cacheMode, WorkspaceMode workspaceMode, ConvolutionLayer.AlgoMode cudnnAlgoMode) {
        this.nBoxes = nBoxes;
        this.priorBoxes = priorBoxes;
        this.seed = seed;
        this.inputShape = inputShape;
        this.numClasses = numClasses;
        this.updater = updater;
        this.cacheMode = cacheMode;
        this.workspaceMode = workspaceMode;
        this.cudnnAlgoMode = cudnnAlgoMode;
    }

    public int getNBoxes() {
        return this.nBoxes;
    }

    public double[][] getPriorBoxes() {
        return this.priorBoxes;
    }

    public static class TinyYOLOBuilder {
        private boolean nBoxes$set;
        private int nBoxes$value;
        private boolean priorBoxes$set;
        private double[][] priorBoxes$value;
        private boolean seed$set;
        private long seed$value;
        private boolean inputShape$set;
        private int[] inputShape$value;
        private boolean numClasses$set;
        private int numClasses$value;
        private boolean updater$set;
        private IUpdater updater$value;
        private boolean cacheMode$set;
        private CacheMode cacheMode$value;
        private boolean workspaceMode$set;
        private WorkspaceMode workspaceMode$value;
        private boolean cudnnAlgoMode$set;
        private ConvolutionLayer.AlgoMode cudnnAlgoMode$value;

        TinyYOLOBuilder() {
        }

        public TinyYOLOBuilder nBoxes(int nBoxes) {
            this.nBoxes$value = nBoxes;
            this.nBoxes$set = true;
            return this;
        }

        public TinyYOLOBuilder priorBoxes(double[][] priorBoxes) {
            this.priorBoxes$value = priorBoxes;
            this.priorBoxes$set = true;
            return this;
        }

        public TinyYOLOBuilder seed(long seed) {
            this.seed$value = seed;
            this.seed$set = true;
            return this;
        }

        public TinyYOLOBuilder inputShape(int[] inputShape) {
            this.inputShape$value = inputShape;
            this.inputShape$set = true;
            return this;
        }

        public TinyYOLOBuilder numClasses(int numClasses) {
            this.numClasses$value = numClasses;
            this.numClasses$set = true;
            return this;
        }

        public TinyYOLOBuilder updater(IUpdater updater) {
            this.updater$value = updater;
            this.updater$set = true;
            return this;
        }

        public TinyYOLOBuilder cacheMode(CacheMode cacheMode) {
            this.cacheMode$value = cacheMode;
            this.cacheMode$set = true;
            return this;
        }

        public TinyYOLOBuilder workspaceMode(WorkspaceMode workspaceMode) {
            this.workspaceMode$value = workspaceMode;
            this.workspaceMode$set = true;
            return this;
        }

        public TinyYOLOBuilder cudnnAlgoMode(ConvolutionLayer.AlgoMode cudnnAlgoMode) {
            this.cudnnAlgoMode$value = cudnnAlgoMode;
            this.cudnnAlgoMode$set = true;
            return this;
        }

        public TinyYOLO build() {
            int nBoxes$value = this.nBoxes$value;
            if (!this.nBoxes$set) {
                nBoxes$value = TinyYOLO.$default$nBoxes();
            }
            double[][] priorBoxes$value = this.priorBoxes$value;
            if (!this.priorBoxes$set) {
                priorBoxes$value = TinyYOLO.$default$priorBoxes();
            }
            long seed$value = this.seed$value;
            if (!this.seed$set) {
                seed$value = TinyYOLO.$default$seed();
            }
            int[] inputShape$value = this.inputShape$value;
            if (!this.inputShape$set) {
                inputShape$value = TinyYOLO.$default$inputShape();
            }
            int numClasses$value = this.numClasses$value;
            if (!this.numClasses$set) {
                numClasses$value = TinyYOLO.$default$numClasses();
            }
            IUpdater updater$value = this.updater$value;
            if (!this.updater$set) {
                updater$value = TinyYOLO.$default$updater();
            }
            CacheMode cacheMode$value = this.cacheMode$value;
            if (!this.cacheMode$set) {
                cacheMode$value = TinyYOLO.$default$cacheMode();
            }
            WorkspaceMode workspaceMode$value = this.workspaceMode$value;
            if (!this.workspaceMode$set) {
                workspaceMode$value = TinyYOLO.$default$workspaceMode();
            }
            ConvolutionLayer.AlgoMode cudnnAlgoMode$value = this.cudnnAlgoMode$value;
            if (!this.cudnnAlgoMode$set) {
                cudnnAlgoMode$value = TinyYOLO.$default$cudnnAlgoMode();
            }
            return new TinyYOLO(nBoxes$value, priorBoxes$value, seed$value, inputShape$value, numClasses$value, updater$value, cacheMode$value, workspaceMode$value, cudnnAlgoMode$value);
        }

        public String toString() {
            return "TinyYOLO.TinyYOLOBuilder(nBoxes$value=" + this.nBoxes$value + ", priorBoxes$value=" + Arrays.deepToString((Object[])this.priorBoxes$value) + ", seed$value=" + this.seed$value + ", inputShape$value=" + Arrays.toString(this.inputShape$value) + ", numClasses$value=" + this.numClasses$value + ", updater$value=" + this.updater$value + ", cacheMode$value=" + this.cacheMode$value + ", workspaceMode$value=" + this.workspaceMode$value + ", cudnnAlgoMode$value=" + this.cudnnAlgoMode$value + ")";
        }
    }
}

