/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.zoo.model;

import java.util.Arrays;
import org.deeplearning4j.nn.api.Model;
import org.deeplearning4j.nn.api.OptimizationAlgorithm;
import org.deeplearning4j.nn.conf.CacheMode;
import org.deeplearning4j.nn.conf.ComputationGraphConfiguration;
import org.deeplearning4j.nn.conf.ConvolutionMode;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.conf.WorkspaceMode;
import org.deeplearning4j.nn.conf.distribution.Distribution;
import org.deeplearning4j.nn.conf.distribution.TruncatedNormalDistribution;
import org.deeplearning4j.nn.conf.graph.GraphVertex;
import org.deeplearning4j.nn.conf.graph.L2NormalizeVertex;
import org.deeplearning4j.nn.conf.graph.MergeVertex;
import org.deeplearning4j.nn.conf.inputs.InputType;
import org.deeplearning4j.nn.conf.layers.BatchNormalization;
import org.deeplearning4j.nn.conf.layers.CenterLossOutputLayer;
import org.deeplearning4j.nn.conf.layers.ConvolutionLayer;
import org.deeplearning4j.nn.conf.layers.DenseLayer;
import org.deeplearning4j.nn.conf.layers.Layer;
import org.deeplearning4j.nn.conf.layers.SubsamplingLayer;
import org.deeplearning4j.nn.graph.ComputationGraph;
import org.deeplearning4j.zoo.ModelMetaData;
import org.deeplearning4j.zoo.PretrainedType;
import org.deeplearning4j.zoo.ZooModel;
import org.deeplearning4j.zoo.ZooType;
import org.deeplearning4j.zoo.model.helper.InceptionResNetHelper;
import org.nd4j.linalg.activations.Activation;
import org.nd4j.linalg.learning.config.IUpdater;
import org.nd4j.linalg.learning.config.RmsProp;
import org.nd4j.linalg.lossfunctions.LossFunctions;

public class InceptionResNetV1
extends ZooModel {
    private long seed;
    private int[] inputShape;
    private int numClasses;
    private IUpdater updater;
    private CacheMode cacheMode;
    private WorkspaceMode workspaceMode;
    private ConvolutionLayer.AlgoMode cudnnAlgoMode;

    private InceptionResNetV1() {
    }

    @Override
    public String pretrainedUrl(PretrainedType pretrainedType) {
        return null;
    }

    @Override
    public long pretrainedChecksum(PretrainedType pretrainedType) {
        return 0L;
    }

    @Override
    public Class<? extends Model> modelType() {
        return ComputationGraph.class;
    }

    public ComputationGraph init() {
        int embeddingSize = 128;
        ComputationGraphConfiguration.GraphBuilder graph = this.graphBuilder("input1");
        graph.addInputs(new String[]{"input1"}).setInputTypes(new InputType[]{InputType.convolutional((long)this.inputShape[2], (long)this.inputShape[1], (long)this.inputShape[0])}).addLayer("bottleneck", (Layer)((DenseLayer.Builder)((DenseLayer.Builder)new DenseLayer.Builder().nIn(5376)).nOut(embeddingSize)).build(), new String[]{"avgpool"}).addVertex("embeddings", (GraphVertex)new L2NormalizeVertex(new int[]{1}, 1.0E-10), new String[]{"bottleneck"}).addLayer("outputLayer", (Layer)((CenterLossOutputLayer.Builder)((CenterLossOutputLayer.Builder)((CenterLossOutputLayer.Builder)((CenterLossOutputLayer.Builder)new CenterLossOutputLayer.Builder().lossFunction(LossFunctions.LossFunction.NEGATIVELOGLIKELIHOOD)).activation(Activation.SOFTMAX)).alpha(0.9).lambda(1.0E-4).nIn(embeddingSize)).nOut(this.numClasses)).build(), new String[]{"embeddings"}).setOutputs(new String[]{"outputLayer"});
        ComputationGraphConfiguration conf = graph.build();
        ComputationGraph model = new ComputationGraph(conf);
        model.init();
        return model;
    }

    public ComputationGraphConfiguration.GraphBuilder graphBuilder(String input) {
        ComputationGraphConfiguration.GraphBuilder graph = new NeuralNetConfiguration.Builder().seed(this.seed).activation(Activation.RELU).optimizationAlgo(OptimizationAlgorithm.STOCHASTIC_GRADIENT_DESCENT).updater(this.updater).weightInit((Distribution)new TruncatedNormalDistribution(0.0, 0.5)).l2(5.0E-5).miniBatch(true).cacheMode(this.cacheMode).trainingWorkspaceMode(this.workspaceMode).inferenceWorkspaceMode(this.workspaceMode).convolutionMode(ConvolutionMode.Truncate).graphBuilder();
        graph.addLayer("stem-cnn1", (Layer)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)new ConvolutionLayer.Builder(new int[]{3, 3}, new int[]{2, 2}).nIn(this.inputShape[0])).nOut(32)).cudnnAlgoMode(this.cudnnAlgoMode)).build(), new String[]{input}).addLayer("stem-batch1", (Layer)((BatchNormalization.Builder)((BatchNormalization.Builder)new BatchNormalization.Builder(false).decay(0.995).eps(0.001).nIn(32)).nOut(32)).build(), new String[]{"stem-cnn1"}).addLayer("stem-cnn2", (Layer)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)new ConvolutionLayer.Builder(new int[]{3, 3}).nIn(32)).nOut(32)).cudnnAlgoMode(this.cudnnAlgoMode)).build(), new String[]{"stem-batch1"}).addLayer("stem-batch2", (Layer)((BatchNormalization.Builder)((BatchNormalization.Builder)new BatchNormalization.Builder(false).decay(0.995).eps(0.001).nIn(32)).nOut(32)).build(), new String[]{"stem-cnn2"}).addLayer("stem-cnn3", (Layer)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)new ConvolutionLayer.Builder(new int[]{3, 3}).convolutionMode(ConvolutionMode.Same)).nIn(32)).nOut(64)).cudnnAlgoMode(this.cudnnAlgoMode)).build(), new String[]{"stem-batch2"}).addLayer("stem-batch3", (Layer)((BatchNormalization.Builder)((BatchNormalization.Builder)new BatchNormalization.Builder(false).decay(0.995).eps(0.001).nIn(64)).nOut(64)).build(), new String[]{"stem-cnn3"}).addLayer("stem-pool4", (Layer)new SubsamplingLayer.Builder(SubsamplingLayer.PoolingType.MAX, new int[]{3, 3}, new int[]{2, 2}).build(), new String[]{"stem-batch3"}).addLayer("stem-cnn5", (Layer)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)new ConvolutionLayer.Builder(new int[]{1, 1}).nIn(64)).nOut(80)).cudnnAlgoMode(this.cudnnAlgoMode)).build(), new String[]{"stem-pool4"}).addLayer("stem-batch5", (Layer)((BatchNormalization.Builder)((BatchNormalization.Builder)new BatchNormalization.Builder(false).decay(0.995).eps(0.001).nIn(80)).nOut(80)).build(), new String[]{"stem-cnn5"}).addLayer("stem-cnn6", (Layer)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)new ConvolutionLayer.Builder(new int[]{3, 3}).nIn(80)).nOut(128)).cudnnAlgoMode(this.cudnnAlgoMode)).build(), new String[]{"stem-batch5"}).addLayer("stem-batch6", (Layer)((BatchNormalization.Builder)((BatchNormalization.Builder)new BatchNormalization.Builder(false).decay(0.995).eps(0.001).nIn(128)).nOut(128)).build(), new String[]{"stem-cnn6"}).addLayer("stem-cnn7", (Layer)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)new ConvolutionLayer.Builder(new int[]{3, 3}, new int[]{2, 2}).nIn(128)).nOut(192)).cudnnAlgoMode(this.cudnnAlgoMode)).build(), new String[]{"stem-batch6"}).addLayer("stem-batch7", (Layer)((BatchNormalization.Builder)((BatchNormalization.Builder)new BatchNormalization.Builder(false).decay(0.995).eps(0.001).nIn(192)).nOut(192)).build(), new String[]{"stem-cnn7"});
        InceptionResNetHelper.inceptionV1ResA(graph, "resnetA", 5, 0.17, "stem-batch7");
        graph.addLayer("reduceA-cnn1", (Layer)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)new ConvolutionLayer.Builder(new int[]{3, 3}, new int[]{2, 2}).nIn(192)).nOut(192)).cudnnAlgoMode(this.cudnnAlgoMode)).build(), new String[]{"resnetA"}).addLayer("reduceA-batch1", (Layer)((BatchNormalization.Builder)((BatchNormalization.Builder)new BatchNormalization.Builder(false).decay(0.995).eps(0.001).nIn(192)).nOut(192)).build(), new String[]{"reduceA-cnn1"}).addLayer("reduceA-cnn2", (Layer)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)new ConvolutionLayer.Builder(new int[]{1, 1}).convolutionMode(ConvolutionMode.Same)).nIn(192)).nOut(128)).cudnnAlgoMode(this.cudnnAlgoMode)).build(), new String[]{"resnetA"}).addLayer("reduceA-batch2", (Layer)((BatchNormalization.Builder)((BatchNormalization.Builder)new BatchNormalization.Builder(false).decay(0.995).eps(0.001).nIn(128)).nOut(128)).build(), new String[]{"reduceA-cnn2"}).addLayer("reduceA-cnn3", (Layer)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)new ConvolutionLayer.Builder(new int[]{3, 3}).convolutionMode(ConvolutionMode.Same)).nIn(128)).nOut(128)).cudnnAlgoMode(this.cudnnAlgoMode)).build(), new String[]{"reduceA-batch2"}).addLayer("reduceA-batch3", (Layer)((BatchNormalization.Builder)((BatchNormalization.Builder)new BatchNormalization.Builder(false).decay(0.995).eps(0.001).nIn(128)).nOut(128)).build(), new String[]{"reduceA-cnn3"}).addLayer("reduceA-cnn4", (Layer)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)new ConvolutionLayer.Builder(new int[]{3, 3}, new int[]{2, 2}).nIn(128)).nOut(192)).cudnnAlgoMode(this.cudnnAlgoMode)).build(), new String[]{"reduceA-batch3"}).addLayer("reduceA-batch4", (Layer)((BatchNormalization.Builder)((BatchNormalization.Builder)new BatchNormalization.Builder(false).decay(0.995).eps(0.001).nIn(192)).nOut(192)).build(), new String[]{"reduceA-cnn4"}).addLayer("reduceA-pool5", (Layer)new SubsamplingLayer.Builder(SubsamplingLayer.PoolingType.MAX, new int[]{3, 3}, new int[]{2, 2}).build(), new String[]{"resnetA"}).addVertex("reduceA", (GraphVertex)new MergeVertex(), new String[]{"reduceA-batch1", "reduceA-batch4", "reduceA-pool5"});
        InceptionResNetHelper.inceptionV1ResB(graph, "resnetB", 10, 0.1, "reduceA");
        graph.addLayer("reduceB-pool1", (Layer)new SubsamplingLayer.Builder(SubsamplingLayer.PoolingType.MAX, new int[]{3, 3}, new int[]{2, 2}).build(), new String[]{"resnetB"}).addLayer("reduceB-cnn2", (Layer)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)new ConvolutionLayer.Builder(new int[]{1, 1}).convolutionMode(ConvolutionMode.Same)).nIn(576)).nOut(256)).cudnnAlgoMode(this.cudnnAlgoMode)).build(), new String[]{"resnetB"}).addLayer("reduceB-batch1", (Layer)((BatchNormalization.Builder)((BatchNormalization.Builder)new BatchNormalization.Builder(false).decay(0.995).eps(0.001).nIn(256)).nOut(256)).build(), new String[]{"reduceB-cnn2"}).addLayer("reduceB-cnn3", (Layer)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)new ConvolutionLayer.Builder(new int[]{3, 3}, new int[]{2, 2}).nIn(256)).nOut(256)).cudnnAlgoMode(this.cudnnAlgoMode)).build(), new String[]{"reduceB-batch1"}).addLayer("reduceB-batch2", (Layer)((BatchNormalization.Builder)((BatchNormalization.Builder)new BatchNormalization.Builder(false).decay(0.995).eps(0.001).nIn(256)).nOut(256)).build(), new String[]{"reduceB-cnn3"}).addLayer("reduceB-cnn4", (Layer)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)new ConvolutionLayer.Builder(new int[]{1, 1}).convolutionMode(ConvolutionMode.Same)).nIn(576)).nOut(256)).cudnnAlgoMode(this.cudnnAlgoMode)).build(), new String[]{"resnetB"}).addLayer("reduceB-batch3", (Layer)((BatchNormalization.Builder)((BatchNormalization.Builder)new BatchNormalization.Builder(false).decay(0.995).eps(0.001).nIn(256)).nOut(256)).build(), new String[]{"reduceB-cnn4"}).addLayer("reduceB-cnn5", (Layer)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)new ConvolutionLayer.Builder(new int[]{3, 3}, new int[]{2, 2}).nIn(256)).nOut(256)).cudnnAlgoMode(this.cudnnAlgoMode)).build(), new String[]{"reduceB-batch3"}).addLayer("reduceB-batch4", (Layer)((BatchNormalization.Builder)((BatchNormalization.Builder)new BatchNormalization.Builder(false).decay(0.995).eps(0.001).nIn(256)).nOut(256)).build(), new String[]{"reduceB-cnn5"}).addLayer("reduceB-cnn6", (Layer)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)new ConvolutionLayer.Builder(new int[]{1, 1}).convolutionMode(ConvolutionMode.Same)).nIn(576)).nOut(256)).cudnnAlgoMode(this.cudnnAlgoMode)).build(), new String[]{"resnetB"}).addLayer("reduceB-batch5", (Layer)((BatchNormalization.Builder)((BatchNormalization.Builder)new BatchNormalization.Builder(false).decay(0.995).eps(0.001).nIn(256)).nOut(256)).build(), new String[]{"reduceB-cnn6"}).addLayer("reduceB-cnn7", (Layer)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)new ConvolutionLayer.Builder(new int[]{3, 3}).convolutionMode(ConvolutionMode.Same)).nIn(256)).nOut(256)).cudnnAlgoMode(this.cudnnAlgoMode)).build(), new String[]{"reduceB-batch5"}).addLayer("reduceB-batch6", (Layer)((BatchNormalization.Builder)((BatchNormalization.Builder)new BatchNormalization.Builder(false).decay(0.995).eps(0.001).nIn(256)).nOut(256)).build(), new String[]{"reduceB-cnn7"}).addLayer("reduceB-cnn8", (Layer)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)new ConvolutionLayer.Builder(new int[]{3, 3}, new int[]{2, 2}).nIn(256)).nOut(256)).cudnnAlgoMode(this.cudnnAlgoMode)).build(), new String[]{"reduceB-batch6"}).addLayer("reduceB-batch7", (Layer)((BatchNormalization.Builder)((BatchNormalization.Builder)new BatchNormalization.Builder(false).decay(0.995).eps(0.001).nIn(256)).nOut(256)).build(), new String[]{"reduceB-cnn8"}).addVertex("reduceB", (GraphVertex)new MergeVertex(), new String[]{"reduceB-pool1", "reduceB-batch2", "reduceB-batch4", "reduceB-batch7"});
        InceptionResNetHelper.inceptionV1ResC(graph, "resnetC", 5, 0.2, "reduceB");
        graph.addLayer("avgpool", (Layer)new SubsamplingLayer.Builder(SubsamplingLayer.PoolingType.AVG, new int[]{1, 1}).build(), new String[]{"resnetC"});
        return graph;
    }

    @Override
    public ModelMetaData metaData() {
        return new ModelMetaData(new int[][]{this.inputShape}, 1, ZooType.CNN);
    }

    @Override
    public void setInputShape(int[][] inputShape) {
        this.inputShape = inputShape[0];
    }

    private static long $default$seed() {
        return 1234L;
    }

    private static int[] $default$inputShape() {
        return new int[]{3, 160, 160};
    }

    private static int $default$numClasses() {
        return 0;
    }

    private static IUpdater $default$updater() {
        return new RmsProp(0.1, 0.96, 0.001);
    }

    private static CacheMode $default$cacheMode() {
        return CacheMode.NONE;
    }

    private static WorkspaceMode $default$workspaceMode() {
        return WorkspaceMode.ENABLED;
    }

    private static ConvolutionLayer.AlgoMode $default$cudnnAlgoMode() {
        return ConvolutionLayer.AlgoMode.PREFER_FASTEST;
    }

    public static InceptionResNetV1Builder builder() {
        return new InceptionResNetV1Builder();
    }

    public InceptionResNetV1(long seed, int[] inputShape, int numClasses, IUpdater updater, CacheMode cacheMode, WorkspaceMode workspaceMode, ConvolutionLayer.AlgoMode cudnnAlgoMode) {
        this.seed = seed;
        this.inputShape = inputShape;
        this.numClasses = numClasses;
        this.updater = updater;
        this.cacheMode = cacheMode;
        this.workspaceMode = workspaceMode;
        this.cudnnAlgoMode = cudnnAlgoMode;
    }

    public static class InceptionResNetV1Builder {
        private boolean seed$set;
        private long seed$value;
        private boolean inputShape$set;
        private int[] inputShape$value;
        private boolean numClasses$set;
        private int numClasses$value;
        private boolean updater$set;
        private IUpdater updater$value;
        private boolean cacheMode$set;
        private CacheMode cacheMode$value;
        private boolean workspaceMode$set;
        private WorkspaceMode workspaceMode$value;
        private boolean cudnnAlgoMode$set;
        private ConvolutionLayer.AlgoMode cudnnAlgoMode$value;

        InceptionResNetV1Builder() {
        }

        public InceptionResNetV1Builder seed(long seed) {
            this.seed$value = seed;
            this.seed$set = true;
            return this;
        }

        public InceptionResNetV1Builder inputShape(int[] inputShape) {
            this.inputShape$value = inputShape;
            this.inputShape$set = true;
            return this;
        }

        public InceptionResNetV1Builder numClasses(int numClasses) {
            this.numClasses$value = numClasses;
            this.numClasses$set = true;
            return this;
        }

        public InceptionResNetV1Builder updater(IUpdater updater) {
            this.updater$value = updater;
            this.updater$set = true;
            return this;
        }

        public InceptionResNetV1Builder cacheMode(CacheMode cacheMode) {
            this.cacheMode$value = cacheMode;
            this.cacheMode$set = true;
            return this;
        }

        public InceptionResNetV1Builder workspaceMode(WorkspaceMode workspaceMode) {
            this.workspaceMode$value = workspaceMode;
            this.workspaceMode$set = true;
            return this;
        }

        public InceptionResNetV1Builder cudnnAlgoMode(ConvolutionLayer.AlgoMode cudnnAlgoMode) {
            this.cudnnAlgoMode$value = cudnnAlgoMode;
            this.cudnnAlgoMode$set = true;
            return this;
        }

        public InceptionResNetV1 build() {
            long seed$value = this.seed$value;
            if (!this.seed$set) {
                seed$value = InceptionResNetV1.$default$seed();
            }
            int[] inputShape$value = this.inputShape$value;
            if (!this.inputShape$set) {
                inputShape$value = InceptionResNetV1.$default$inputShape();
            }
            int numClasses$value = this.numClasses$value;
            if (!this.numClasses$set) {
                numClasses$value = InceptionResNetV1.$default$numClasses();
            }
            IUpdater updater$value = this.updater$value;
            if (!this.updater$set) {
                updater$value = InceptionResNetV1.$default$updater();
            }
            CacheMode cacheMode$value = this.cacheMode$value;
            if (!this.cacheMode$set) {
                cacheMode$value = InceptionResNetV1.$default$cacheMode();
            }
            WorkspaceMode workspaceMode$value = this.workspaceMode$value;
            if (!this.workspaceMode$set) {
                workspaceMode$value = InceptionResNetV1.$default$workspaceMode();
            }
            ConvolutionLayer.AlgoMode cudnnAlgoMode$value = this.cudnnAlgoMode$value;
            if (!this.cudnnAlgoMode$set) {
                cudnnAlgoMode$value = InceptionResNetV1.$default$cudnnAlgoMode();
            }
            return new InceptionResNetV1(seed$value, inputShape$value, numClasses$value, updater$value, cacheMode$value, workspaceMode$value, cudnnAlgoMode$value);
        }

        public String toString() {
            return "InceptionResNetV1.InceptionResNetV1Builder(seed$value=" + this.seed$value + ", inputShape$value=" + Arrays.toString(this.inputShape$value) + ", numClasses$value=" + this.numClasses$value + ", updater$value=" + this.updater$value + ", cacheMode$value=" + this.cacheMode$value + ", workspaceMode$value=" + this.workspaceMode$value + ", cudnnAlgoMode$value=" + this.cudnnAlgoMode$value + ")";
        }
    }
}

