/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.ui.activation;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import org.apache.commons.compress.utils.IOUtils;
import org.canova.api.util.ClassPathResource;
import org.deeplearning4j.ui.activation.PathUpdate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/activations")
@Produces(value={"text/html"})
public class ActivationsResource {
    private String imagePath = "activations.png";
    private static Logger log = LoggerFactory.getLogger(ActivationsResource.class);

    @POST
    @Path(value="/update")
    @Produces(value={"application/json"})
    public Response update(PathUpdate path) {
        this.imagePath = path.getPath();
        return Response.ok(Collections.singletonMap("status", "updated path")).build();
    }

    @GET
    @Path(value="/img")
    @Produces(value={"image/png"})
    public Response image() {
        File fx;
        if (this.imagePath == null) {
            this.imagePath = "activations.png";
        }
        if (!(fx = new File(this.imagePath)).exists()) {
            try {
                ClassPathResource resource = new ClassPathResource("/404.img");
                fx = resource.getFile();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        final File f = fx;
        return Response.ok().entity((Object)new StreamingOutput(){

            public void write(OutputStream output) throws IOException, WebApplicationException {
                FileInputStream fis = new FileInputStream(f);
                byte[] bytes = IOUtils.toByteArray((InputStream)fis);
                fis.close();
                output.write(bytes);
                output.flush();
            }
        }).build();
    }
}

