/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.ui.nearestneighbors;

import io.dropwizard.views.View;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.commons.io.FileUtils;
import org.deeplearning4j.berkeley.Pair;
import org.deeplearning4j.clustering.sptree.DataPoint;
import org.deeplearning4j.clustering.vptree.VPTree;
import org.deeplearning4j.models.embeddings.inmemory.InMemoryLookupTable;
import org.deeplearning4j.models.embeddings.loader.WordVectorSerializer;
import org.deeplearning4j.models.embeddings.wordvectors.WordVectors;
import org.deeplearning4j.models.word2vec.VocabWord;
import org.deeplearning4j.models.word2vec.Word2Vec;
import org.deeplearning4j.models.word2vec.wordstore.VocabCache;
import org.deeplearning4j.ui.api.UrlResource;
import org.deeplearning4j.ui.nearestneighbors.NearestNeighborsQuery;
import org.deeplearning4j.ui.nearestneighbors.NearestNeighborsView;
import org.deeplearning4j.ui.uploads.FileResource;
import org.deeplearning4j.util.SerializationUtils;

@Path(value="/nearestneighbors")
public class NearestNeighborsResource
extends FileResource {
    private VPTree tree;
    private List<VocabWord> words;
    private Map<Integer, VocabWord> theVocab;
    private VocabCache vocab;
    private WordVectors wordVectors;
    private File localFile;

    public NearestNeighborsResource(String filePath) {
        super(filePath);
    }

    @GET
    public View get() {
        return new NearestNeighborsView();
    }

    @POST
    @Path(value="/update")
    @Produces(value={"application/json"})
    public Response updateFilePath(UrlResource resource) {
        if (!resource.getUrl().startsWith("http")) {
            this.localFile = new File(".", resource.getUrl());
            this.handleUpload(this.localFile);
        } else {
            File dl = new File(this.filePath, UUID.randomUUID().toString());
            try {
                FileUtils.copyURLToFile((URL)new URL(resource.getUrl()), (File)dl);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.handleUpload(dl);
        }
        return Response.ok(Collections.singletonMap("message", "Uploaded file")).build();
    }

    @POST
    @Path(value="/vocab")
    @Produces(value={"application/json"})
    public Response getVocab() {
        ArrayList<String> words = new ArrayList<String>();
        if (this.wordVectors != null) {
            words.addAll(this.wordVectors.vocab().words());
        } else {
            for (VocabWord word : this.words) {
                words.add(word.getWord());
            }
        }
        return Response.ok(new ArrayList(words)).build();
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="/words")
    public Response getWords(NearestNeighborsQuery query) {
        HashMap<String, Double> map = new HashMap<String, Double>();
        if (this.wordVectors != null) {
            Collection words = this.wordVectors.wordsNearest(query.getWord(), query.getNumWords());
            for (String word : words) {
                map.put(word, this.wordVectors.similarity(query.getWord(), word));
            }
        } else {
            ArrayList results = new ArrayList();
            ArrayList distances = new ArrayList();
            this.tree.search((DataPoint)this.tree.getItems().get(this.vocab.indexOf(query.getWord())), query.getNumWords(), results, distances);
            for (int i = 0; i < results.size(); ++i) {
                map.put(this.theVocab.get(((DataPoint)results.get(i)).getIndex()).getWord(), (Double)distances.get(i));
            }
        }
        return Response.ok(map).build();
    }

    @Override
    public void handleUpload(File path) {
        try {
            if (path.getAbsolutePath().endsWith(".ser")) {
                WordVectors vectors = (WordVectors)SerializationUtils.readObject((File)path);
                InMemoryLookupTable table = (InMemoryLookupTable)vectors.lookupTable();
                this.tree = new VPTree(table.getSyn0(), "dot", true);
                this.words = new ArrayList<VocabWord>(vectors.vocab().vocabWords());
                this.theVocab = new HashMap<Integer, VocabWord>();
                for (VocabWord word : this.words) {
                    this.theVocab.put(word.getIndex(), word);
                }
                this.vocab = vectors.vocab();
            } else if (path.getAbsolutePath().contains("Google")) {
                Word2Vec vectors = WordVectorSerializer.loadGoogleModel((File)path, (boolean)true);
                this.wordVectors = vectors;
            } else {
                Pair vocab = WordVectorSerializer.loadTxt((File)path);
                this.wordVectors = WordVectorSerializer.fromPair((Pair)vocab);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

