define(['../internal/baseToString'], function(baseToString) {

  /**
   * Capitalizes the first character of `string`.
   *
   * @static
   * @memberOf _
   * @category String
   * @param {string} [string=''] The string to capitalize.
   * @returns {string} Returns the capitalized string.
   * @example
   *
   * _.capitalize('fred');
   * // => 'Fred'
   */
  function capitalize(string) {
    string = baseToString(string);
    return string && (string.charAt(0).toUpperCase() + string.slice(1));
  }

  return capitalize;
});
