/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.ui.stats.sbe;

import java.io.UnsupportedEncodingException;
import java.nio.ByteOrder;
import java.util.NoSuchElementException;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.deeplearning4j.ui.stats.sbe.GroupSizeEncodingEncoder;
import org.deeplearning4j.ui.stats.sbe.MemoryType;
import org.deeplearning4j.ui.stats.sbe.MetaAttribute;
import org.deeplearning4j.ui.stats.sbe.StatsType;
import org.deeplearning4j.ui.stats.sbe.SummaryType;
import org.deeplearning4j.ui.stats.sbe.UpdateDecoder;
import org.deeplearning4j.ui.stats.sbe.UpdateFieldsPresentEncoder;

public class UpdateEncoder {
    public static final int BLOCK_LENGTH = 32;
    public static final int TEMPLATE_ID = 2;
    public static final int SCHEMA_ID = 1;
    public static final int SCHEMA_VERSION = 0;
    private final UpdateEncoder parentMessage = this;
    private MutableDirectBuffer buffer;
    protected int offset;
    protected int limit;
    protected int actingBlockLength;
    protected int actingVersion;
    private final UpdateFieldsPresentEncoder fieldsPresent = new UpdateFieldsPresentEncoder();
    private final MemoryUseEncoder memoryUse = new MemoryUseEncoder();
    private final PerformanceEncoder performance = new PerformanceEncoder();
    private final GcStatsEncoder gcStats = new GcStatsEncoder();
    private final ParamNamesEncoder paramNames = new ParamNamesEncoder();
    private final LayerNamesEncoder layerNames = new LayerNamesEncoder();
    private final PerParameterStatsEncoder perParameterStats = new PerParameterStatsEncoder();
    private final DataSetMetaDataBytesEncoder dataSetMetaDataBytes = new DataSetMetaDataBytesEncoder();

    public int sbeBlockLength() {
        return 32;
    }

    public int sbeTemplateId() {
        return 2;
    }

    public int sbeSchemaId() {
        return 1;
    }

    public int sbeSchemaVersion() {
        return 0;
    }

    public String sbeSemanticType() {
        return "";
    }

    public int offset() {
        return this.offset;
    }

    public UpdateEncoder wrap(MutableDirectBuffer buffer, int offset) {
        this.buffer = buffer;
        this.offset = offset;
        this.limit(offset + 32);
        return this;
    }

    public int encodedLength() {
        return this.limit - this.offset;
    }

    public int limit() {
        return this.limit;
    }

    public void limit(int limit) {
        this.limit = limit;
    }

    public static long timeNullValue() {
        return Long.MIN_VALUE;
    }

    public static long timeMinValue() {
        return -9223372036854775807L;
    }

    public static long timeMaxValue() {
        return Long.MAX_VALUE;
    }

    public UpdateEncoder time(long value) {
        this.buffer.putLong(this.offset + 0, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int deltaTimeNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int deltaTimeMinValue() {
        return -2147483647;
    }

    public static int deltaTimeMaxValue() {
        return Integer.MAX_VALUE;
    }

    public UpdateEncoder deltaTime(int value) {
        this.buffer.putInt(this.offset + 8, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int iterationCountNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int iterationCountMinValue() {
        return -2147483647;
    }

    public static int iterationCountMaxValue() {
        return Integer.MAX_VALUE;
    }

    public UpdateEncoder iterationCount(int value) {
        this.buffer.putInt(this.offset + 12, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public UpdateFieldsPresentEncoder fieldsPresent() {
        this.fieldsPresent.wrap(this.buffer, this.offset + 16);
        return this.fieldsPresent;
    }

    public static int statsCollectionDurationNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int statsCollectionDurationMinValue() {
        return -2147483647;
    }

    public static int statsCollectionDurationMaxValue() {
        return Integer.MAX_VALUE;
    }

    public UpdateEncoder statsCollectionDuration(int value) {
        this.buffer.putInt(this.offset + 20, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static double scoreNullValue() {
        return Double.NaN;
    }

    public static double scoreMinValue() {
        return Double.MIN_VALUE;
    }

    public static double scoreMaxValue() {
        return Double.MAX_VALUE;
    }

    public UpdateEncoder score(double value) {
        this.buffer.putDouble(this.offset + 24, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static long memoryUseId() {
        return 100L;
    }

    public MemoryUseEncoder memoryUseCount(int count) {
        this.memoryUse.wrap(this.parentMessage, this.buffer, count);
        return this.memoryUse;
    }

    public static long performanceId() {
        return 200L;
    }

    public PerformanceEncoder performanceCount(int count) {
        this.performance.wrap(this.parentMessage, this.buffer, count);
        return this.performance;
    }

    public static long gcStatsId() {
        return 300L;
    }

    public GcStatsEncoder gcStatsCount(int count) {
        this.gcStats.wrap(this.parentMessage, this.buffer, count);
        return this.gcStats;
    }

    public static long paramNamesId() {
        return 350L;
    }

    public ParamNamesEncoder paramNamesCount(int count) {
        this.paramNames.wrap(this.parentMessage, this.buffer, count);
        return this.paramNames;
    }

    public static long layerNamesId() {
        return 351L;
    }

    public LayerNamesEncoder layerNamesCount(int count) {
        this.layerNames.wrap(this.parentMessage, this.buffer, count);
        return this.layerNames;
    }

    public static long perParameterStatsId() {
        return 400L;
    }

    public PerParameterStatsEncoder perParameterStatsCount(int count) {
        this.perParameterStats.wrap(this.parentMessage, this.buffer, count);
        return this.perParameterStats;
    }

    public static long dataSetMetaDataBytesId() {
        return 500L;
    }

    public DataSetMetaDataBytesEncoder dataSetMetaDataBytesCount(int count) {
        this.dataSetMetaDataBytes.wrap(this.parentMessage, this.buffer, count);
        return this.dataSetMetaDataBytes;
    }

    public static int sessionIDId() {
        return 1200;
    }

    public static String sessionIDCharacterEncoding() {
        return "UTF-8";
    }

    public static String sessionIDMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "unix";
            }
            case TIME_UNIT: {
                return "nanosecond";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
        }
        return "";
    }

    public static int sessionIDHeaderLength() {
        return 4;
    }

    public UpdateEncoder putSessionID(DirectBuffer src, int srcOffset, int length) {
        if (length > 0x40000000) {
            throw new IllegalArgumentException("length > max value for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 4, src, srcOffset, length);
        return this;
    }

    public UpdateEncoder putSessionID(byte[] src, int srcOffset, int length) {
        if (length > 0x40000000) {
            throw new IllegalArgumentException("length > max value for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 4, src, srcOffset, length);
        return this;
    }

    public UpdateEncoder sessionID(String value) {
        byte[] bytes;
        try {
            bytes = value.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
        int length = bytes.length;
        if (length > 0x40000000) {
            throw new IllegalArgumentException("length > max value for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 4, bytes, 0, length);
        return this;
    }

    public static int typeIDId() {
        return 1201;
    }

    public static String typeIDCharacterEncoding() {
        return "UTF-8";
    }

    public static String typeIDMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "unix";
            }
            case TIME_UNIT: {
                return "nanosecond";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
        }
        return "";
    }

    public static int typeIDHeaderLength() {
        return 4;
    }

    public UpdateEncoder putTypeID(DirectBuffer src, int srcOffset, int length) {
        if (length > 0x40000000) {
            throw new IllegalArgumentException("length > max value for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 4, src, srcOffset, length);
        return this;
    }

    public UpdateEncoder putTypeID(byte[] src, int srcOffset, int length) {
        if (length > 0x40000000) {
            throw new IllegalArgumentException("length > max value for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 4, src, srcOffset, length);
        return this;
    }

    public UpdateEncoder typeID(String value) {
        byte[] bytes;
        try {
            bytes = value.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
        int length = bytes.length;
        if (length > 0x40000000) {
            throw new IllegalArgumentException("length > max value for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 4, bytes, 0, length);
        return this;
    }

    public static int workerIDId() {
        return 1202;
    }

    public static String workerIDCharacterEncoding() {
        return "UTF-8";
    }

    public static String workerIDMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "unix";
            }
            case TIME_UNIT: {
                return "nanosecond";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
        }
        return "";
    }

    public static int workerIDHeaderLength() {
        return 4;
    }

    public UpdateEncoder putWorkerID(DirectBuffer src, int srcOffset, int length) {
        if (length > 0x40000000) {
            throw new IllegalArgumentException("length > max value for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 4, src, srcOffset, length);
        return this;
    }

    public UpdateEncoder putWorkerID(byte[] src, int srcOffset, int length) {
        if (length > 0x40000000) {
            throw new IllegalArgumentException("length > max value for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 4, src, srcOffset, length);
        return this;
    }

    public UpdateEncoder workerID(String value) {
        byte[] bytes;
        try {
            bytes = value.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
        int length = bytes.length;
        if (length > 0x40000000) {
            throw new IllegalArgumentException("length > max value for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 4, bytes, 0, length);
        return this;
    }

    public static int dataSetMetaDataClassNameId() {
        return 1300;
    }

    public static String dataSetMetaDataClassNameCharacterEncoding() {
        return "UTF-8";
    }

    public static String dataSetMetaDataClassNameMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "unix";
            }
            case TIME_UNIT: {
                return "nanosecond";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
        }
        return "";
    }

    public static int dataSetMetaDataClassNameHeaderLength() {
        return 4;
    }

    public UpdateEncoder putDataSetMetaDataClassName(DirectBuffer src, int srcOffset, int length) {
        if (length > 0x40000000) {
            throw new IllegalArgumentException("length > max value for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 4, src, srcOffset, length);
        return this;
    }

    public UpdateEncoder putDataSetMetaDataClassName(byte[] src, int srcOffset, int length) {
        if (length > 0x40000000) {
            throw new IllegalArgumentException("length > max value for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 4, src, srcOffset, length);
        return this;
    }

    public UpdateEncoder dataSetMetaDataClassName(String value) {
        byte[] bytes;
        try {
            bytes = value.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
        int length = bytes.length;
        if (length > 0x40000000) {
            throw new IllegalArgumentException("length > max value for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 4, bytes, 0, length);
        return this;
    }

    public String toString() {
        return this.appendTo(new StringBuilder(100)).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        UpdateDecoder writer = new UpdateDecoder();
        writer.wrap((DirectBuffer)this.buffer, this.offset, 32, 0);
        return writer.appendTo(builder);
    }

    public static class DataSetMetaDataBytesEncoder {
        private static final int HEADER_SIZE = 4;
        private final GroupSizeEncodingEncoder dimensions = new GroupSizeEncodingEncoder();
        private UpdateEncoder parentMessage;
        private MutableDirectBuffer buffer;
        private int blockLength;
        private int actingVersion;
        private int count;
        private int index;
        private int offset;
        private final MetaDataBytesEncoder metaDataBytes = new MetaDataBytesEncoder();

        public void wrap(UpdateEncoder parentMessage, MutableDirectBuffer buffer, int count) {
            if (count < 0 || count > 65534) {
                throw new IllegalArgumentException("count outside allowed range: count=" + count);
            }
            this.parentMessage = parentMessage;
            this.buffer = buffer;
            this.actingVersion = 0;
            this.dimensions.wrap(buffer, parentMessage.limit());
            this.dimensions.blockLength(0);
            this.dimensions.numInGroup(count);
            this.index = -1;
            this.count = count;
            this.blockLength = 0;
            parentMessage.limit(parentMessage.limit() + 4);
        }

        public static int sbeHeaderSize() {
            return 4;
        }

        public static int sbeBlockLength() {
            return 0;
        }

        public DataSetMetaDataBytesEncoder next() {
            if (this.index + 1 >= this.count) {
                throw new NoSuchElementException();
            }
            this.offset = this.parentMessage.limit();
            this.parentMessage.limit(this.offset + this.blockLength);
            ++this.index;
            return this;
        }

        public static long metaDataBytesId() {
            return 501L;
        }

        public MetaDataBytesEncoder metaDataBytesCount(int count) {
            this.metaDataBytes.wrap(this.parentMessage, this.buffer, count);
            return this.metaDataBytes;
        }

        public static class MetaDataBytesEncoder {
            private static final int HEADER_SIZE = 4;
            private final GroupSizeEncodingEncoder dimensions = new GroupSizeEncodingEncoder();
            private UpdateEncoder parentMessage;
            private MutableDirectBuffer buffer;
            private int blockLength;
            private int actingVersion;
            private int count;
            private int index;
            private int offset;

            public void wrap(UpdateEncoder parentMessage, MutableDirectBuffer buffer, int count) {
                if (count < 0 || count > 65534) {
                    throw new IllegalArgumentException("count outside allowed range: count=" + count);
                }
                this.parentMessage = parentMessage;
                this.buffer = buffer;
                this.actingVersion = 0;
                this.dimensions.wrap(buffer, parentMessage.limit());
                this.dimensions.blockLength(1);
                this.dimensions.numInGroup(count);
                this.index = -1;
                this.count = count;
                this.blockLength = 1;
                parentMessage.limit(parentMessage.limit() + 4);
            }

            public static int sbeHeaderSize() {
                return 4;
            }

            public static int sbeBlockLength() {
                return 1;
            }

            public MetaDataBytesEncoder next() {
                if (this.index + 1 >= this.count) {
                    throw new NoSuchElementException();
                }
                this.offset = this.parentMessage.limit();
                this.parentMessage.limit(this.offset + this.blockLength);
                ++this.index;
                return this;
            }

            public static byte bytesNullValue() {
                return -128;
            }

            public static byte bytesMinValue() {
                return -127;
            }

            public static byte bytesMaxValue() {
                return 127;
            }

            public MetaDataBytesEncoder bytes(byte value) {
                this.buffer.putByte(this.offset + 0, value);
                return this;
            }
        }
    }

    public static class PerParameterStatsEncoder {
        private static final int HEADER_SIZE = 4;
        private final GroupSizeEncodingEncoder dimensions = new GroupSizeEncodingEncoder();
        private UpdateEncoder parentMessage;
        private MutableDirectBuffer buffer;
        private int blockLength;
        private int actingVersion;
        private int count;
        private int index;
        private int offset;
        private final SummaryStatEncoder summaryStat = new SummaryStatEncoder();
        private final HistogramsEncoder histograms = new HistogramsEncoder();

        public void wrap(UpdateEncoder parentMessage, MutableDirectBuffer buffer, int count) {
            if (count < 0 || count > 65534) {
                throw new IllegalArgumentException("count outside allowed range: count=" + count);
            }
            this.parentMessage = parentMessage;
            this.buffer = buffer;
            this.actingVersion = 0;
            this.dimensions.wrap(buffer, parentMessage.limit());
            this.dimensions.blockLength(4);
            this.dimensions.numInGroup(count);
            this.index = -1;
            this.count = count;
            this.blockLength = 4;
            parentMessage.limit(parentMessage.limit() + 4);
        }

        public static int sbeHeaderSize() {
            return 4;
        }

        public static int sbeBlockLength() {
            return 4;
        }

        public PerParameterStatsEncoder next() {
            if (this.index + 1 >= this.count) {
                throw new NoSuchElementException();
            }
            this.offset = this.parentMessage.limit();
            this.parentMessage.limit(this.offset + this.blockLength);
            ++this.index;
            return this;
        }

        public static float learningRateNullValue() {
            return Float.NaN;
        }

        public static float learningRateMinValue() {
            return Float.MIN_VALUE;
        }

        public static float learningRateMaxValue() {
            return Float.MAX_VALUE;
        }

        public PerParameterStatsEncoder learningRate(float value) {
            this.buffer.putFloat(this.offset + 0, value, ByteOrder.LITTLE_ENDIAN);
            return this;
        }

        public static long summaryStatId() {
            return 402L;
        }

        public SummaryStatEncoder summaryStatCount(int count) {
            this.summaryStat.wrap(this.parentMessage, this.buffer, count);
            return this.summaryStat;
        }

        public static long histogramsId() {
            return 406L;
        }

        public HistogramsEncoder histogramsCount(int count) {
            this.histograms.wrap(this.parentMessage, this.buffer, count);
            return this.histograms;
        }

        public static class HistogramsEncoder {
            private static final int HEADER_SIZE = 4;
            private final GroupSizeEncodingEncoder dimensions = new GroupSizeEncodingEncoder();
            private UpdateEncoder parentMessage;
            private MutableDirectBuffer buffer;
            private int blockLength;
            private int actingVersion;
            private int count;
            private int index;
            private int offset;
            private final HistogramCountsEncoder histogramCounts = new HistogramCountsEncoder();

            public void wrap(UpdateEncoder parentMessage, MutableDirectBuffer buffer, int count) {
                if (count < 0 || count > 65534) {
                    throw new IllegalArgumentException("count outside allowed range: count=" + count);
                }
                this.parentMessage = parentMessage;
                this.buffer = buffer;
                this.actingVersion = 0;
                this.dimensions.wrap(buffer, parentMessage.limit());
                this.dimensions.blockLength(21);
                this.dimensions.numInGroup(count);
                this.index = -1;
                this.count = count;
                this.blockLength = 21;
                parentMessage.limit(parentMessage.limit() + 4);
            }

            public static int sbeHeaderSize() {
                return 4;
            }

            public static int sbeBlockLength() {
                return 21;
            }

            public HistogramsEncoder next() {
                if (this.index + 1 >= this.count) {
                    throw new NoSuchElementException();
                }
                this.offset = this.parentMessage.limit();
                this.parentMessage.limit(this.offset + this.blockLength);
                ++this.index;
                return this;
            }

            public HistogramsEncoder statType(StatsType value) {
                this.buffer.putByte(this.offset + 0, (byte)value.value());
                return this;
            }

            public static double minValueNullValue() {
                return Double.NaN;
            }

            public static double minValueMinValue() {
                return Double.MIN_VALUE;
            }

            public static double minValueMaxValue() {
                return Double.MAX_VALUE;
            }

            public HistogramsEncoder minValue(double value) {
                this.buffer.putDouble(this.offset + 1, value, ByteOrder.LITTLE_ENDIAN);
                return this;
            }

            public static double maxValueNullValue() {
                return Double.NaN;
            }

            public static double maxValueMinValue() {
                return Double.MIN_VALUE;
            }

            public static double maxValueMaxValue() {
                return Double.MAX_VALUE;
            }

            public HistogramsEncoder maxValue(double value) {
                this.buffer.putDouble(this.offset + 9, value, ByteOrder.LITTLE_ENDIAN);
                return this;
            }

            public static int nBinsNullValue() {
                return Integer.MIN_VALUE;
            }

            public static int nBinsMinValue() {
                return -2147483647;
            }

            public static int nBinsMaxValue() {
                return Integer.MAX_VALUE;
            }

            public HistogramsEncoder nBins(int value) {
                this.buffer.putInt(this.offset + 17, value, ByteOrder.LITTLE_ENDIAN);
                return this;
            }

            public static long histogramCountsId() {
                return 411L;
            }

            public HistogramCountsEncoder histogramCountsCount(int count) {
                this.histogramCounts.wrap(this.parentMessage, this.buffer, count);
                return this.histogramCounts;
            }

            public static class HistogramCountsEncoder {
                private static final int HEADER_SIZE = 4;
                private final GroupSizeEncodingEncoder dimensions = new GroupSizeEncodingEncoder();
                private UpdateEncoder parentMessage;
                private MutableDirectBuffer buffer;
                private int blockLength;
                private int actingVersion;
                private int count;
                private int index;
                private int offset;

                public void wrap(UpdateEncoder parentMessage, MutableDirectBuffer buffer, int count) {
                    if (count < 0 || count > 65534) {
                        throw new IllegalArgumentException("count outside allowed range: count=" + count);
                    }
                    this.parentMessage = parentMessage;
                    this.buffer = buffer;
                    this.actingVersion = 0;
                    this.dimensions.wrap(buffer, parentMessage.limit());
                    this.dimensions.blockLength(4);
                    this.dimensions.numInGroup(count);
                    this.index = -1;
                    this.count = count;
                    this.blockLength = 4;
                    parentMessage.limit(parentMessage.limit() + 4);
                }

                public static int sbeHeaderSize() {
                    return 4;
                }

                public static int sbeBlockLength() {
                    return 4;
                }

                public HistogramCountsEncoder next() {
                    if (this.index + 1 >= this.count) {
                        throw new NoSuchElementException();
                    }
                    this.offset = this.parentMessage.limit();
                    this.parentMessage.limit(this.offset + this.blockLength);
                    ++this.index;
                    return this;
                }

                public static long binCountNullValue() {
                    return 0xFFFFFFFEL;
                }

                public static long binCountMinValue() {
                    return 0L;
                }

                public static long binCountMaxValue() {
                    return 0xFFFFFFFDL;
                }

                public HistogramCountsEncoder binCount(long value) {
                    this.buffer.putInt(this.offset + 0, (int)value, ByteOrder.LITTLE_ENDIAN);
                    return this;
                }
            }
        }

        public static class SummaryStatEncoder {
            private static final int HEADER_SIZE = 4;
            private final GroupSizeEncodingEncoder dimensions = new GroupSizeEncodingEncoder();
            private UpdateEncoder parentMessage;
            private MutableDirectBuffer buffer;
            private int blockLength;
            private int actingVersion;
            private int count;
            private int index;
            private int offset;

            public void wrap(UpdateEncoder parentMessage, MutableDirectBuffer buffer, int count) {
                if (count < 0 || count > 65534) {
                    throw new IllegalArgumentException("count outside allowed range: count=" + count);
                }
                this.parentMessage = parentMessage;
                this.buffer = buffer;
                this.actingVersion = 0;
                this.dimensions.wrap(buffer, parentMessage.limit());
                this.dimensions.blockLength(10);
                this.dimensions.numInGroup(count);
                this.index = -1;
                this.count = count;
                this.blockLength = 10;
                parentMessage.limit(parentMessage.limit() + 4);
            }

            public static int sbeHeaderSize() {
                return 4;
            }

            public static int sbeBlockLength() {
                return 10;
            }

            public SummaryStatEncoder next() {
                if (this.index + 1 >= this.count) {
                    throw new NoSuchElementException();
                }
                this.offset = this.parentMessage.limit();
                this.parentMessage.limit(this.offset + this.blockLength);
                ++this.index;
                return this;
            }

            public SummaryStatEncoder statType(StatsType value) {
                this.buffer.putByte(this.offset + 0, (byte)value.value());
                return this;
            }

            public SummaryStatEncoder summaryType(SummaryType value) {
                this.buffer.putByte(this.offset + 1, (byte)value.value());
                return this;
            }

            public static double valueNullValue() {
                return Double.NaN;
            }

            public static double valueMinValue() {
                return Double.MIN_VALUE;
            }

            public static double valueMaxValue() {
                return Double.MAX_VALUE;
            }

            public SummaryStatEncoder value(double value) {
                this.buffer.putDouble(this.offset + 2, value, ByteOrder.LITTLE_ENDIAN);
                return this;
            }
        }
    }

    public static class LayerNamesEncoder {
        private static final int HEADER_SIZE = 4;
        private final GroupSizeEncodingEncoder dimensions = new GroupSizeEncodingEncoder();
        private UpdateEncoder parentMessage;
        private MutableDirectBuffer buffer;
        private int blockLength;
        private int actingVersion;
        private int count;
        private int index;
        private int offset;

        public void wrap(UpdateEncoder parentMessage, MutableDirectBuffer buffer, int count) {
            if (count < 0 || count > 65534) {
                throw new IllegalArgumentException("count outside allowed range: count=" + count);
            }
            this.parentMessage = parentMessage;
            this.buffer = buffer;
            this.actingVersion = 0;
            this.dimensions.wrap(buffer, parentMessage.limit());
            this.dimensions.blockLength(0);
            this.dimensions.numInGroup(count);
            this.index = -1;
            this.count = count;
            this.blockLength = 0;
            parentMessage.limit(parentMessage.limit() + 4);
        }

        public static int sbeHeaderSize() {
            return 4;
        }

        public static int sbeBlockLength() {
            return 0;
        }

        public LayerNamesEncoder next() {
            if (this.index + 1 >= this.count) {
                throw new NoSuchElementException();
            }
            this.offset = this.parentMessage.limit();
            this.parentMessage.limit(this.offset + this.blockLength);
            ++this.index;
            return this;
        }

        public static int layerNameId() {
            return 1101;
        }

        public static String layerNameCharacterEncoding() {
            return "UTF-8";
        }

        public static String layerNameMetaAttribute(MetaAttribute metaAttribute) {
            switch (metaAttribute) {
                case EPOCH: {
                    return "unix";
                }
                case TIME_UNIT: {
                    return "nanosecond";
                }
                case SEMANTIC_TYPE: {
                    return "";
                }
            }
            return "";
        }

        public static int layerNameHeaderLength() {
            return 4;
        }

        public LayerNamesEncoder putLayerName(DirectBuffer src, int srcOffset, int length) {
            if (length > 0x40000000) {
                throw new IllegalArgumentException("length > max value for type: " + length);
            }
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            this.parentMessage.limit(limit + 4 + length);
            this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
            this.buffer.putBytes(limit + 4, src, srcOffset, length);
            return this;
        }

        public LayerNamesEncoder putLayerName(byte[] src, int srcOffset, int length) {
            if (length > 0x40000000) {
                throw new IllegalArgumentException("length > max value for type: " + length);
            }
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            this.parentMessage.limit(limit + 4 + length);
            this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
            this.buffer.putBytes(limit + 4, src, srcOffset, length);
            return this;
        }

        public LayerNamesEncoder layerName(String value) {
            byte[] bytes;
            try {
                bytes = value.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException ex) {
                throw new RuntimeException(ex);
            }
            int length = bytes.length;
            if (length > 0x40000000) {
                throw new IllegalArgumentException("length > max value for type: " + length);
            }
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            this.parentMessage.limit(limit + 4 + length);
            this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
            this.buffer.putBytes(limit + 4, bytes, 0, length);
            return this;
        }
    }

    public static class ParamNamesEncoder {
        private static final int HEADER_SIZE = 4;
        private final GroupSizeEncodingEncoder dimensions = new GroupSizeEncodingEncoder();
        private UpdateEncoder parentMessage;
        private MutableDirectBuffer buffer;
        private int blockLength;
        private int actingVersion;
        private int count;
        private int index;
        private int offset;

        public void wrap(UpdateEncoder parentMessage, MutableDirectBuffer buffer, int count) {
            if (count < 0 || count > 65534) {
                throw new IllegalArgumentException("count outside allowed range: count=" + count);
            }
            this.parentMessage = parentMessage;
            this.buffer = buffer;
            this.actingVersion = 0;
            this.dimensions.wrap(buffer, parentMessage.limit());
            this.dimensions.blockLength(0);
            this.dimensions.numInGroup(count);
            this.index = -1;
            this.count = count;
            this.blockLength = 0;
            parentMessage.limit(parentMessage.limit() + 4);
        }

        public static int sbeHeaderSize() {
            return 4;
        }

        public static int sbeBlockLength() {
            return 0;
        }

        public ParamNamesEncoder next() {
            if (this.index + 1 >= this.count) {
                throw new NoSuchElementException();
            }
            this.offset = this.parentMessage.limit();
            this.parentMessage.limit(this.offset + this.blockLength);
            ++this.index;
            return this;
        }

        public static int paramNameId() {
            return 1100;
        }

        public static String paramNameCharacterEncoding() {
            return "UTF-8";
        }

        public static String paramNameMetaAttribute(MetaAttribute metaAttribute) {
            switch (metaAttribute) {
                case EPOCH: {
                    return "unix";
                }
                case TIME_UNIT: {
                    return "nanosecond";
                }
                case SEMANTIC_TYPE: {
                    return "";
                }
            }
            return "";
        }

        public static int paramNameHeaderLength() {
            return 4;
        }

        public ParamNamesEncoder putParamName(DirectBuffer src, int srcOffset, int length) {
            if (length > 0x40000000) {
                throw new IllegalArgumentException("length > max value for type: " + length);
            }
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            this.parentMessage.limit(limit + 4 + length);
            this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
            this.buffer.putBytes(limit + 4, src, srcOffset, length);
            return this;
        }

        public ParamNamesEncoder putParamName(byte[] src, int srcOffset, int length) {
            if (length > 0x40000000) {
                throw new IllegalArgumentException("length > max value for type: " + length);
            }
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            this.parentMessage.limit(limit + 4 + length);
            this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
            this.buffer.putBytes(limit + 4, src, srcOffset, length);
            return this;
        }

        public ParamNamesEncoder paramName(String value) {
            byte[] bytes;
            try {
                bytes = value.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException ex) {
                throw new RuntimeException(ex);
            }
            int length = bytes.length;
            if (length > 0x40000000) {
                throw new IllegalArgumentException("length > max value for type: " + length);
            }
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            this.parentMessage.limit(limit + 4 + length);
            this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
            this.buffer.putBytes(limit + 4, bytes, 0, length);
            return this;
        }
    }

    public static class GcStatsEncoder {
        private static final int HEADER_SIZE = 4;
        private final GroupSizeEncodingEncoder dimensions = new GroupSizeEncodingEncoder();
        private UpdateEncoder parentMessage;
        private MutableDirectBuffer buffer;
        private int blockLength;
        private int actingVersion;
        private int count;
        private int index;
        private int offset;

        public void wrap(UpdateEncoder parentMessage, MutableDirectBuffer buffer, int count) {
            if (count < 0 || count > 65534) {
                throw new IllegalArgumentException("count outside allowed range: count=" + count);
            }
            this.parentMessage = parentMessage;
            this.buffer = buffer;
            this.actingVersion = 0;
            this.dimensions.wrap(buffer, parentMessage.limit());
            this.dimensions.blockLength(8);
            this.dimensions.numInGroup(count);
            this.index = -1;
            this.count = count;
            this.blockLength = 8;
            parentMessage.limit(parentMessage.limit() + 4);
        }

        public static int sbeHeaderSize() {
            return 4;
        }

        public static int sbeBlockLength() {
            return 8;
        }

        public GcStatsEncoder next() {
            if (this.index + 1 >= this.count) {
                throw new NoSuchElementException();
            }
            this.offset = this.parentMessage.limit();
            this.parentMessage.limit(this.offset + this.blockLength);
            ++this.index;
            return this;
        }

        public static int deltaGCCountNullValue() {
            return Integer.MIN_VALUE;
        }

        public static int deltaGCCountMinValue() {
            return -2147483647;
        }

        public static int deltaGCCountMaxValue() {
            return Integer.MAX_VALUE;
        }

        public GcStatsEncoder deltaGCCount(int value) {
            this.buffer.putInt(this.offset + 0, value, ByteOrder.LITTLE_ENDIAN);
            return this;
        }

        public static int deltaGCTimeMsNullValue() {
            return Integer.MIN_VALUE;
        }

        public static int deltaGCTimeMsMinValue() {
            return -2147483647;
        }

        public static int deltaGCTimeMsMaxValue() {
            return Integer.MAX_VALUE;
        }

        public GcStatsEncoder deltaGCTimeMs(int value) {
            this.buffer.putInt(this.offset + 4, value, ByteOrder.LITTLE_ENDIAN);
            return this;
        }

        public static int gcNameId() {
            return 1000;
        }

        public static String gcNameCharacterEncoding() {
            return "UTF-8";
        }

        public static String gcNameMetaAttribute(MetaAttribute metaAttribute) {
            switch (metaAttribute) {
                case EPOCH: {
                    return "unix";
                }
                case TIME_UNIT: {
                    return "nanosecond";
                }
                case SEMANTIC_TYPE: {
                    return "";
                }
            }
            return "";
        }

        public static int gcNameHeaderLength() {
            return 4;
        }

        public GcStatsEncoder putGcName(DirectBuffer src, int srcOffset, int length) {
            if (length > 0x40000000) {
                throw new IllegalArgumentException("length > max value for type: " + length);
            }
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            this.parentMessage.limit(limit + 4 + length);
            this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
            this.buffer.putBytes(limit + 4, src, srcOffset, length);
            return this;
        }

        public GcStatsEncoder putGcName(byte[] src, int srcOffset, int length) {
            if (length > 0x40000000) {
                throw new IllegalArgumentException("length > max value for type: " + length);
            }
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            this.parentMessage.limit(limit + 4 + length);
            this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
            this.buffer.putBytes(limit + 4, src, srcOffset, length);
            return this;
        }

        public GcStatsEncoder gcName(String value) {
            byte[] bytes;
            try {
                bytes = value.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException ex) {
                throw new RuntimeException(ex);
            }
            int length = bytes.length;
            if (length > 0x40000000) {
                throw new IllegalArgumentException("length > max value for type: " + length);
            }
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            this.parentMessage.limit(limit + 4 + length);
            this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
            this.buffer.putBytes(limit + 4, bytes, 0, length);
            return this;
        }
    }

    public static class PerformanceEncoder {
        private static final int HEADER_SIZE = 4;
        private final GroupSizeEncodingEncoder dimensions = new GroupSizeEncodingEncoder();
        private UpdateEncoder parentMessage;
        private MutableDirectBuffer buffer;
        private int blockLength;
        private int actingVersion;
        private int count;
        private int index;
        private int offset;

        public void wrap(UpdateEncoder parentMessage, MutableDirectBuffer buffer, int count) {
            if (count < 0 || count > 65534) {
                throw new IllegalArgumentException("count outside allowed range: count=" + count);
            }
            this.parentMessage = parentMessage;
            this.buffer = buffer;
            this.actingVersion = 0;
            this.dimensions.wrap(buffer, parentMessage.limit());
            this.dimensions.blockLength(32);
            this.dimensions.numInGroup(count);
            this.index = -1;
            this.count = count;
            this.blockLength = 32;
            parentMessage.limit(parentMessage.limit() + 4);
        }

        public static int sbeHeaderSize() {
            return 4;
        }

        public static int sbeBlockLength() {
            return 32;
        }

        public PerformanceEncoder next() {
            if (this.index + 1 >= this.count) {
                throw new NoSuchElementException();
            }
            this.offset = this.parentMessage.limit();
            this.parentMessage.limit(this.offset + this.blockLength);
            ++this.index;
            return this;
        }

        public static long totalRuntimeMsNullValue() {
            return Long.MIN_VALUE;
        }

        public static long totalRuntimeMsMinValue() {
            return -9223372036854775807L;
        }

        public static long totalRuntimeMsMaxValue() {
            return Long.MAX_VALUE;
        }

        public PerformanceEncoder totalRuntimeMs(long value) {
            this.buffer.putLong(this.offset + 0, value, ByteOrder.LITTLE_ENDIAN);
            return this;
        }

        public static long totalExamplesNullValue() {
            return Long.MIN_VALUE;
        }

        public static long totalExamplesMinValue() {
            return -9223372036854775807L;
        }

        public static long totalExamplesMaxValue() {
            return Long.MAX_VALUE;
        }

        public PerformanceEncoder totalExamples(long value) {
            this.buffer.putLong(this.offset + 8, value, ByteOrder.LITTLE_ENDIAN);
            return this;
        }

        public static long totalMinibatchesNullValue() {
            return Long.MIN_VALUE;
        }

        public static long totalMinibatchesMinValue() {
            return -9223372036854775807L;
        }

        public static long totalMinibatchesMaxValue() {
            return Long.MAX_VALUE;
        }

        public PerformanceEncoder totalMinibatches(long value) {
            this.buffer.putLong(this.offset + 16, value, ByteOrder.LITTLE_ENDIAN);
            return this;
        }

        public static float examplesPerSecondNullValue() {
            return Float.NaN;
        }

        public static float examplesPerSecondMinValue() {
            return Float.MIN_VALUE;
        }

        public static float examplesPerSecondMaxValue() {
            return Float.MAX_VALUE;
        }

        public PerformanceEncoder examplesPerSecond(float value) {
            this.buffer.putFloat(this.offset + 24, value, ByteOrder.LITTLE_ENDIAN);
            return this;
        }

        public static float minibatchesPerSecondNullValue() {
            return Float.NaN;
        }

        public static float minibatchesPerSecondMinValue() {
            return Float.MIN_VALUE;
        }

        public static float minibatchesPerSecondMaxValue() {
            return Float.MAX_VALUE;
        }

        public PerformanceEncoder minibatchesPerSecond(float value) {
            this.buffer.putFloat(this.offset + 28, value, ByteOrder.LITTLE_ENDIAN);
            return this;
        }
    }

    public static class MemoryUseEncoder {
        private static final int HEADER_SIZE = 4;
        private final GroupSizeEncodingEncoder dimensions = new GroupSizeEncodingEncoder();
        private UpdateEncoder parentMessage;
        private MutableDirectBuffer buffer;
        private int blockLength;
        private int actingVersion;
        private int count;
        private int index;
        private int offset;

        public void wrap(UpdateEncoder parentMessage, MutableDirectBuffer buffer, int count) {
            if (count < 0 || count > 65534) {
                throw new IllegalArgumentException("count outside allowed range: count=" + count);
            }
            this.parentMessage = parentMessage;
            this.buffer = buffer;
            this.actingVersion = 0;
            this.dimensions.wrap(buffer, parentMessage.limit());
            this.dimensions.blockLength(9);
            this.dimensions.numInGroup(count);
            this.index = -1;
            this.count = count;
            this.blockLength = 9;
            parentMessage.limit(parentMessage.limit() + 4);
        }

        public static int sbeHeaderSize() {
            return 4;
        }

        public static int sbeBlockLength() {
            return 9;
        }

        public MemoryUseEncoder next() {
            if (this.index + 1 >= this.count) {
                throw new NoSuchElementException();
            }
            this.offset = this.parentMessage.limit();
            this.parentMessage.limit(this.offset + this.blockLength);
            ++this.index;
            return this;
        }

        public MemoryUseEncoder memoryType(MemoryType value) {
            this.buffer.putByte(this.offset + 0, (byte)value.value());
            return this;
        }

        public static long memoryBytesNullValue() {
            return Long.MIN_VALUE;
        }

        public static long memoryBytesMinValue() {
            return -9223372036854775807L;
        }

        public static long memoryBytesMaxValue() {
            return Long.MAX_VALUE;
        }

        public MemoryUseEncoder memoryBytes(long value) {
            this.buffer.putLong(this.offset + 1, value, ByteOrder.LITTLE_ENDIAN);
            return this;
        }
    }
}

