/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.ui.model.stats;

import org.deeplearning4j.core.storage.StatsStorageRouter;
import org.deeplearning4j.core.storage.StorageMetaData;
import org.deeplearning4j.ui.model.stats.BaseStatsListener;
import org.deeplearning4j.ui.model.stats.api.StatsInitializationConfiguration;
import org.deeplearning4j.ui.model.stats.api.StatsInitializationReport;
import org.deeplearning4j.ui.model.stats.api.StatsReport;
import org.deeplearning4j.ui.model.stats.api.StatsUpdateConfiguration;
import org.deeplearning4j.ui.model.stats.impl.DefaultStatsUpdateConfiguration;
import org.deeplearning4j.ui.model.stats.impl.SbeStatsInitializationReport;
import org.deeplearning4j.ui.model.stats.impl.SbeStatsReport;
import org.deeplearning4j.ui.model.storage.impl.SbeStorageMetaData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatsListener
extends BaseStatsListener {
    private static final Logger log = LoggerFactory.getLogger(StatsListener.class);

    public StatsListener(StatsStorageRouter router) {
        this(router, null, null, null, null);
    }

    public StatsListener(StatsStorageRouter router, int listenerFrequency) {
        this(router, listenerFrequency, null);
    }

    public StatsListener(StatsStorageRouter router, int listenerFrequency, String sessionId) {
        this(router, null, new DefaultStatsUpdateConfiguration.Builder().reportingFrequency(listenerFrequency).build(), sessionId, null);
    }

    public StatsListener(StatsStorageRouter router, StatsInitializationConfiguration initConfig, StatsUpdateConfiguration updateConfig, String sessionID, String workerID) {
        super(router, initConfig, updateConfig, sessionID, workerID);
    }

    @Override
    public StatsListener clone() {
        return new StatsListener(this.getStorageRouter(), this.getInitConfig(), this.getUpdateConfig(), null, null);
    }

    @Override
    public StatsInitializationReport getNewInitializationReport() {
        return new SbeStatsInitializationReport();
    }

    @Override
    public StatsReport getNewStatsReport() {
        return new SbeStatsReport();
    }

    @Override
    public StorageMetaData getNewStorageMetaData(long initTime, String sessionID, String workerID) {
        return new SbeStorageMetaData(initTime, sessionID, "StatsListener", workerID, SbeStatsInitializationReport.class, SbeStatsReport.class);
    }
}

