/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.ui.model.storage.sqlite;

import it.unimi.dsi.fastutil.longs.LongArrayList;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import lombok.NonNull;
import org.deeplearning4j.core.storage.Persistable;
import org.deeplearning4j.core.storage.StatsStorage;
import org.deeplearning4j.core.storage.StatsStorageEvent;
import org.deeplearning4j.core.storage.StatsStorageListener;
import org.deeplearning4j.core.storage.StorageMetaData;
import org.nd4j.common.primitives.Pair;

public class J7FileStatsStorage
implements StatsStorage {
    private static final String TABLE_NAME_METADATA = "StorageMetaData";
    private static final String TABLE_NAME_STATIC_INFO = "StaticInfo";
    private static final String TABLE_NAME_UPDATES = "Updates";
    private static final String INSERT_META_SQL = "INSERT OR REPLACE INTO StorageMetaData (SessionID, TypeID, ObjectClass, ObjectBytes) VALUES ( ?, ?, ?, ? );";
    private static final String INSERT_STATIC_SQL = "INSERT OR REPLACE INTO StaticInfo (SessionID, TypeID, WorkerID, ObjectClass, ObjectBytes) VALUES ( ?, ?, ?, ?, ? );";
    private static final String INSERT_UPDATE_SQL = "INSERT OR REPLACE INTO Updates (SessionID, TypeID, WorkerID, Timestamp, ObjectClass, ObjectBytes) VALUES ( ?, ?, ?, ?, ?, ? );";
    private final File file;
    private final Connection connection;
    private List<StatsStorageListener> listeners = new ArrayList<StatsStorageListener>();

    public J7FileStatsStorage(@NonNull File file) {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        this.file = file;
        try {
            this.connection = DriverManager.getConnection("jdbc:sqlite:" + file.getAbsolutePath());
        }
        catch (Exception e) {
            throw new RuntimeException("Error ninializing J7FileStatsStorage instance", e);
        }
        try {
            this.initializeTables();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    private void initializeTables() throws SQLException {
        DatabaseMetaData meta = this.connection.getMetaData();
        ResultSet rs = meta.getTables(null, null, "%", null);
        boolean hasStorageMetaDataTable = false;
        boolean hasStaticInfoTable = false;
        boolean hasUpdatesTable = false;
        while (rs.next()) {
            String name = rs.getString(3);
            if (TABLE_NAME_METADATA.equals(name)) {
                hasStorageMetaDataTable = true;
                continue;
            }
            if (TABLE_NAME_STATIC_INFO.equals(name)) {
                hasStaticInfoTable = true;
                continue;
            }
            if (!TABLE_NAME_UPDATES.equals(name)) continue;
            hasUpdatesTable = true;
        }
        Statement statement = this.connection.createStatement();
        if (!hasStorageMetaDataTable) {
            statement.executeUpdate("CREATE TABLE StorageMetaData (SessionID TEXT NOT NULL, TypeID TEXT NOT NULL, ObjectClass TEXT NOT NULL, ObjectBytes BLOB NOT NULL, PRIMARY KEY ( SessionID, TypeID ));");
        }
        if (!hasStaticInfoTable) {
            statement.executeUpdate("CREATE TABLE StaticInfo (SessionID TEXT NOT NULL, TypeID TEXT NOT NULL, WorkerID TEXT NOT NULL, ObjectClass TEXT NOT NULL, ObjectBytes BLOB NOT NULL, PRIMARY KEY ( SessionID, TypeID, WorkerID ));");
        }
        if (!hasUpdatesTable) {
            statement.executeUpdate("CREATE TABLE Updates (SessionID TEXT NOT NULL, TypeID TEXT NOT NULL, WorkerID TEXT NOT NULL, Timestamp INTEGER NOT NULL, ObjectClass TEXT NOT NULL, ObjectBytes BLOB NOT NULL, PRIMARY KEY ( SessionID, TypeID, WorkerID, Timestamp ));");
        }
        statement.close();
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static Pair<String, byte[]> serializeForDB(Object object) {
        String classStr = object.getClass().getName();
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            Pair pair;
            try (ObjectOutputStream oos = new ObjectOutputStream(baos);){
                oos.writeObject(object);
                oos.close();
                byte[] bytes = baos.toByteArray();
                pair = new Pair((Object)classStr, (Object)bytes);
            }
            return pair;
        }
        catch (IOException e) {
            throw new RuntimeException("Error serializing object for storage", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static <T> T deserialize(byte[] bytes) {
        try (ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(bytes));){
            Object object = ois.readObject();
            return (T)object;
        }
        catch (IOException | ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T> T queryAndGet(String sql, int columnIndex) {
        try (Statement statement = this.connection.createStatement();){
            ResultSet rs = statement.executeQuery(sql);
            if (!rs.next()) {
                T t = null;
                return t;
            }
            byte[] bytes = rs.getBytes(columnIndex);
            T t = J7FileStatsStorage.deserialize(bytes);
            return t;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    private List<String> selectDistinct(String columnName, boolean queryMeta, boolean queryStatic, boolean queryUpdates, String conditionColumn, String conditionValue) {
        HashSet<String> unique = new HashSet<String>();
        try (Statement statement = this.connection.createStatement();){
            if (queryMeta) {
                this.queryHelper(statement, this.querySqlHelper(columnName, TABLE_NAME_METADATA, conditionColumn, conditionValue), unique);
            }
            if (queryStatic) {
                this.queryHelper(statement, this.querySqlHelper(columnName, TABLE_NAME_STATIC_INFO, conditionColumn, conditionValue), unique);
            }
            if (queryUpdates) {
                this.queryHelper(statement, this.querySqlHelper(columnName, TABLE_NAME_UPDATES, conditionColumn, conditionValue), unique);
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        return new ArrayList<String>(unique);
    }

    private String querySqlHelper(String columnName, String table, String conditionColumn, String conditionValue) {
        String unique = "SELECT DISTINCT " + columnName + " FROM " + table;
        if (conditionColumn != null) {
            unique = unique + " WHERE " + conditionColumn + " = '" + conditionValue + "'";
        }
        unique = unique + ";";
        return unique;
    }

    private void queryHelper(Statement statement, String q, Set<String> unique) throws SQLException {
        ResultSet rs = statement.executeQuery(q);
        while (rs.next()) {
            String str = rs.getString(1);
            unique.add(str);
        }
    }

    protected List<StatsStorageEvent> checkStorageEvents(Persistable p) {
        if (this.listeners.isEmpty()) {
            return null;
        }
        StatsStorageEvent newSID = null;
        StatsStorageEvent newTID = null;
        StatsStorageEvent newWID = null;
        String sid = p.getSessionID();
        String tid = p.getTypeID();
        String wid = p.getWorkerID();
        boolean isNewSID = false;
        boolean isNewTID = false;
        boolean isNewWID = false;
        if (!this.listSessionIDs().contains(sid)) {
            isNewSID = true;
            isNewTID = true;
            isNewWID = true;
        }
        if (!isNewTID && !this.listTypeIDsForSession(sid).contains(tid)) {
            isNewTID = true;
        }
        if (!isNewWID && !this.listWorkerIDsForSessionAndType(sid, tid).contains(wid)) {
            isNewWID = true;
        }
        if (isNewSID) {
            newSID = new StatsStorageEvent((StatsStorage)this, StatsStorageListener.EventType.NewSessionID, p.getSessionID(), p.getTypeID(), p.getWorkerID(), p.getTimeStamp());
        }
        if (isNewTID) {
            newTID = new StatsStorageEvent((StatsStorage)this, StatsStorageListener.EventType.NewTypeID, p.getSessionID(), p.getTypeID(), p.getWorkerID(), p.getTimeStamp());
        }
        if (isNewWID) {
            newWID = new StatsStorageEvent((StatsStorage)this, StatsStorageListener.EventType.NewWorkerID, p.getSessionID(), p.getTypeID(), p.getWorkerID(), p.getTimeStamp());
        }
        if (!(isNewSID || isNewTID || isNewWID)) {
            return null;
        }
        ArrayList<StatsStorageEvent> sses = new ArrayList<StatsStorageEvent>(3);
        if (newSID != null) {
            sses.add(newSID);
        }
        if (newTID != null) {
            sses.add(newTID);
        }
        if (newWID != null) {
            sses.add(newWID);
        }
        return sses;
    }

    public void putStorageMetaData(StorageMetaData storageMetaData) {
        this.putStorageMetaData(Collections.singletonList(storageMetaData));
    }

    public void putStorageMetaData(Collection<? extends StorageMetaData> collection) {
        List<StatsStorageEvent> sses = null;
        try {
            PreparedStatement ps = this.connection.prepareStatement(INSERT_META_SQL);
            for (StorageMetaData storageMetaData : collection) {
                List<StatsStorageEvent> ssesTemp = this.checkStorageEvents((Persistable)storageMetaData);
                if (ssesTemp != null) {
                    if (sses == null) {
                        sses = ssesTemp;
                    } else {
                        sses.addAll(ssesTemp);
                    }
                }
                if (!this.listeners.isEmpty()) {
                    StatsStorageEvent sse = new StatsStorageEvent((StatsStorage)this, StatsStorageListener.EventType.PostMetaData, storageMetaData.getSessionID(), storageMetaData.getTypeID(), storageMetaData.getWorkerID(), storageMetaData.getTimeStamp());
                    if (sses == null) {
                        sses = new ArrayList<StatsStorageEvent>();
                    }
                    sses.add(sse);
                }
                Pair<String, byte[]> p = J7FileStatsStorage.serializeForDB(storageMetaData);
                ps.setString(1, storageMetaData.getSessionID());
                ps.setString(2, storageMetaData.getTypeID());
                ps.setString(3, (String)p.getFirst());
                ps.setObject(4, p.getSecond());
                ps.executeUpdate();
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        this.notifyListeners(sses);
    }

    public void putStaticInfo(Persistable staticInfo) {
        this.putStaticInfo(Collections.singletonList(staticInfo));
    }

    public void putStaticInfo(Collection<? extends Persistable> collection) {
        List<StatsStorageEvent> sses = null;
        try {
            PreparedStatement ps = this.connection.prepareStatement(INSERT_STATIC_SQL);
            for (Persistable persistable : collection) {
                List<StatsStorageEvent> ssesTemp = this.checkStorageEvents(persistable);
                if (ssesTemp != null) {
                    if (sses == null) {
                        sses = ssesTemp;
                    } else {
                        sses.addAll(ssesTemp);
                    }
                }
                if (!this.listeners.isEmpty()) {
                    StatsStorageEvent sse = new StatsStorageEvent((StatsStorage)this, StatsStorageListener.EventType.PostStaticInfo, persistable.getSessionID(), persistable.getTypeID(), persistable.getWorkerID(), persistable.getTimeStamp());
                    if (sses == null) {
                        sses = new ArrayList<StatsStorageEvent>();
                    }
                    sses.add(sse);
                }
                Pair<String, byte[]> pair = J7FileStatsStorage.serializeForDB(persistable);
                ps.setString(1, persistable.getSessionID());
                ps.setString(2, persistable.getTypeID());
                ps.setString(3, persistable.getWorkerID());
                ps.setString(4, (String)pair.getFirst());
                ps.setBytes(5, (byte[])pair.getSecond());
                ps.executeUpdate();
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        this.notifyListeners(sses);
    }

    public void putUpdate(Persistable update) {
        this.putUpdate(Collections.singletonList(update));
    }

    public void putUpdate(Collection<? extends Persistable> collection) {
        List<StatsStorageEvent> sses = null;
        try {
            PreparedStatement ps = this.connection.prepareStatement(INSERT_UPDATE_SQL);
            for (Persistable persistable : collection) {
                List<StatsStorageEvent> ssesTemp = this.checkStorageEvents(persistable);
                if (ssesTemp != null) {
                    if (sses == null) {
                        sses = ssesTemp;
                    } else {
                        sses.addAll(ssesTemp);
                    }
                }
                if (!this.listeners.isEmpty()) {
                    StatsStorageEvent sse = new StatsStorageEvent((StatsStorage)this, StatsStorageListener.EventType.PostUpdate, persistable.getSessionID(), persistable.getTypeID(), persistable.getWorkerID(), persistable.getTimeStamp());
                    if (sses == null) {
                        sses = new ArrayList<StatsStorageEvent>();
                    }
                    sses.add(sse);
                }
                Pair<String, byte[]> pair = J7FileStatsStorage.serializeForDB(persistable);
                ps.setString(1, persistable.getSessionID());
                ps.setString(2, persistable.getTypeID());
                ps.setString(3, persistable.getWorkerID());
                ps.setLong(4, persistable.getTimeStamp());
                ps.setString(5, (String)pair.getFirst());
                ps.setObject(6, pair.getSecond());
                ps.executeUpdate();
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        this.notifyListeners(sses);
    }

    public void close() throws IOException {
        try {
            this.connection.close();
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public boolean isClosed() {
        try {
            return this.connection.isClosed();
        }
        catch (Exception e) {
            return true;
        }
    }

    public List<String> listSessionIDs() {
        return this.selectDistinct("SessionID", true, true, false, null, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean sessionExists(String sessionID) {
        String existsMetaSQL = "SELECT 1 FROM StorageMetaData WHERE SessionID = '" + sessionID + "';";
        String existsStaticSQL = "SELECT 1 FROM StaticInfo WHERE SessionID = '" + sessionID + "';";
        try (Statement statement = this.connection.createStatement();){
            ResultSet rs = statement.executeQuery(existsMetaSQL);
            if (rs.next()) {
                boolean bl2 = true;
                return bl2;
            }
            rs = statement.executeQuery(existsStaticSQL);
            boolean bl = rs.next();
            return bl;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public Persistable getStaticInfo(String sessionID, String typeID, String workerID) {
        String selectStaticSQL = "SELECT ObjectBytes FROM StaticInfo WHERE SessionID = '" + sessionID + "' AND TypeID = '" + typeID + "' AND WorkerID = '" + workerID + "';";
        return (Persistable)this.queryAndGet(selectStaticSQL, 1);
    }

    public List<Persistable> getAllStaticInfos(String sessionID, String typeID) {
        ArrayList<Persistable> arrayList;
        block9: {
            String selectStaticSQL = "SELECT * FROM StaticInfo WHERE SessionID = '" + sessionID + "' AND TypeID = '" + typeID + "';";
            Statement statement = this.connection.createStatement();
            try {
                ResultSet rs = statement.executeQuery(selectStaticSQL);
                ArrayList<Persistable> out = new ArrayList<Persistable>();
                while (rs.next()) {
                    byte[] bytes = rs.getBytes(5);
                    out.add((Persistable)J7FileStatsStorage.deserialize(bytes));
                }
                arrayList = out;
                if (statement == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
            }
            statement.close();
        }
        return arrayList;
    }

    public List<String> listTypeIDsForSession(String sessionID) {
        return this.selectDistinct("TypeID", true, true, true, "SessionID", sessionID);
    }

    public List<String> listWorkerIDsForSession(String sessionID) {
        return this.selectDistinct("WorkerID", false, true, true, "SessionID", sessionID);
    }

    public List<String> listWorkerIDsForSessionAndType(String sessionID, String typeID) {
        String uniqueStatic = "SELECT DISTINCT WorkerID FROM StaticInfo WHERE SessionID = '" + sessionID + "' AND TypeID = '" + typeID + "';";
        String uniqueUpdates = "SELECT DISTINCT WorkerID FROM Updates WHERE SessionID = '" + sessionID + "' AND TypeID = '" + typeID + "';";
        HashSet<String> unique = new HashSet<String>();
        try (Statement statement = this.connection.createStatement();){
            String str;
            ResultSet rs = statement.executeQuery(uniqueStatic);
            while (rs.next()) {
                str = rs.getString(1);
                unique.add(str);
            }
            rs = statement.executeQuery(uniqueUpdates);
            while (rs.next()) {
                str = rs.getString(1);
                unique.add(str);
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        return new ArrayList<String>(unique);
    }

    public int getNumUpdateRecordsFor(String sessionID) {
        int n;
        block8: {
            String sql = "SELECT COUNT(*) FROM Updates WHERE SessionID = '" + sessionID + "';";
            Statement statement = this.connection.createStatement();
            try {
                n = statement.executeQuery(sql).getInt(1);
                if (statement == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
            }
            statement.close();
        }
        return n;
    }

    public int getNumUpdateRecordsFor(String sessionID, String typeID, String workerID) {
        int n;
        block8: {
            String sql = "SELECT COUNT(*) FROM Updates WHERE SessionID = '" + sessionID + "' AND TypeID = '" + typeID + "' AND WorkerID = '" + workerID + "';";
            Statement statement = this.connection.createStatement();
            try {
                n = statement.executeQuery(sql).getInt(1);
                if (statement == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
            }
            statement.close();
        }
        return n;
    }

    public Persistable getLatestUpdate(String sessionID, String typeID, String workerID) {
        String sql = "SELECT ObjectBytes FROM Updates WHERE SessionID = '" + sessionID + "' AND TypeID = '" + typeID + "' AND WorkerID = '" + workerID + "' ORDER BY Timestamp DESC LIMIT 1;";
        return (Persistable)this.queryAndGet(sql, 1);
    }

    public Persistable getUpdate(String sessionID, String typeId, String workerID, long timestamp) {
        String sql = "SELECT ObjectBytes FROM Updates WHERE SessionID = '" + sessionID + "' AND TypeID = '" + typeId + "' AND WorkerID = '" + workerID + "' AND Timestamp = '" + timestamp + "';";
        return (Persistable)this.queryAndGet(sql, 1);
    }

    public List<Persistable> getLatestUpdateAllWorkers(String sessionID, String typeID) {
        String sql = "SELECT workerId, MAX(Timestamp) FROM Updates WHERE SessionID ='" + sessionID + "' AND TypeID = '" + typeID + "' GROUP BY workerId";
        HashMap<String, Long> m = new HashMap<String, Long>();
        try (Statement statement = this.connection.createStatement();){
            ResultSet rs = statement.executeQuery(sql);
            while (rs.next()) {
                String wid = rs.getString(1);
                long ts = rs.getLong(2);
                m.put(wid, ts);
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        ArrayList<Persistable> out = new ArrayList<Persistable>();
        for (String s : m.keySet()) {
            out.add(this.getUpdate(sessionID, typeID, s, (Long)m.get(s)));
        }
        return out;
    }

    public List<Persistable> getAllUpdatesAfter(String sessionID, String typeID, String workerID, long timestamp) {
        ArrayList<Persistable> arrayList;
        block9: {
            String sql = "SELECT * FROM Updates WHERE SessionID = '" + sessionID + "' AND TypeID = '" + typeID + "' AND workerId = '" + workerID + "' AND Timestamp > " + timestamp + ";";
            Statement statement = this.connection.createStatement();
            try {
                ResultSet rs = statement.executeQuery(sql);
                ArrayList<Persistable> out = new ArrayList<Persistable>();
                while (rs.next()) {
                    byte[] bytes = rs.getBytes(6);
                    out.add((Persistable)J7FileStatsStorage.deserialize(bytes));
                }
                arrayList = out;
                if (statement == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
            }
            statement.close();
        }
        return arrayList;
    }

    public List<Persistable> getAllUpdatesAfter(String sessionID, String typeID, long timestamp) {
        String sql = "SELECT ObjectBytes FROM Updates WHERE SessionID = '" + sessionID + "'  AND TypeID = '" + typeID + "' AND Timestamp > " + timestamp + ";";
        return this.queryUpdates(sql);
    }

    public long[] getAllUpdateTimes(String sessionID, String typeID, String workerID) {
        long[] lArray;
        block9: {
            String sql = "SELECT Timestamp FROM Updates WHERE SessionID = '" + sessionID + "'  AND TypeID = '" + typeID + "' AND workerID = '" + workerID + "';";
            Statement statement = this.connection.createStatement();
            try {
                ResultSet rs = statement.executeQuery(sql);
                LongArrayList list = new LongArrayList();
                while (rs.next()) {
                    list.add(rs.getLong(1));
                }
                lArray = list.toLongArray();
                if (statement == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
            }
            statement.close();
        }
        return lArray;
    }

    public List<Persistable> getUpdates(String sessionID, String typeID, String workerID, long[] timestamps) {
        if (timestamps == null || timestamps.length == 0) {
            return Collections.emptyList();
        }
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT ObjectBytes FROM ").append(TABLE_NAME_UPDATES).append(" WHERE SessionID = '").append(sessionID).append("' AND TypeID = '").append(typeID).append("' AND workerID='").append(workerID).append("'  AND Timestamp IN (");
        for (int i = 0; i < timestamps.length; ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(timestamps[i]);
        }
        sb.append(");");
        String sql = sb.toString();
        return this.queryUpdates(sql);
    }

    private List<Persistable> queryUpdates(String sql) {
        ArrayList<Persistable> arrayList;
        block9: {
            Statement statement = this.connection.createStatement();
            try {
                ResultSet rs = statement.executeQuery(sql);
                ArrayList<Persistable> out = new ArrayList<Persistable>();
                while (rs.next()) {
                    byte[] bytes = rs.getBytes(1);
                    out.add((Persistable)J7FileStatsStorage.deserialize(bytes));
                }
                arrayList = out;
                if (statement == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
            }
            statement.close();
        }
        return arrayList;
    }

    public StorageMetaData getStorageMetaData(String sessionID, String typeID) {
        String sql = "SELECT ObjectBytes FROM StorageMetaData WHERE SessionID = '" + sessionID + "' AND TypeID = '" + typeID + "' LIMIT 1;";
        return (StorageMetaData)this.queryAndGet(sql, 1);
    }

    public void registerStatsStorageListener(StatsStorageListener listener) {
        this.listeners.add(listener);
    }

    public void deregisterStatsStorageListener(StatsStorageListener listener) {
        this.listeners.remove(listener);
    }

    public void removeAllListeners() {
        this.listeners.clear();
    }

    public List<StatsStorageListener> getListeners() {
        return new ArrayList<StatsStorageListener>(this.listeners);
    }

    public String toString() {
        return "J7FileStatsStorage(file=" + this.file + ")";
    }

    protected void notifyListeners(List<StatsStorageEvent> sses) {
        if (sses == null || sses.isEmpty() || this.listeners.isEmpty()) {
            return;
        }
        for (StatsStorageListener l : this.listeners) {
            for (StatsStorageEvent e : sses) {
                l.notify(e);
            }
        }
    }
}

