/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.ui.model.stats.impl.java;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Map;
import org.apache.commons.compress.utils.IOUtils;
import org.deeplearning4j.ui.model.stats.api.StatsInitializationReport;

public class JavaStatsInitializationReport
implements StatsInitializationReport {
    private String sessionID;
    private String typeID;
    private String workerID;
    private long timeStamp;
    private boolean hasSoftwareInfo;
    private boolean hasHardwareInfo;
    private boolean hasModelInfo;
    private String swArch;
    private String swOsName;
    private String swJvmName;
    private String swJvmVersion;
    private String swJvmSpecVersion;
    private String swNd4jBackendClass;
    private String swNd4jDataTypeName;
    private String swHostName;
    private String swJvmUID;
    private Map<String, String> swEnvironmentInfo;
    private int hwJvmAvailableProcessors;
    private int hwNumDevices;
    private long hwJvmMaxMemory;
    private long hwOffHeapMaxMemory;
    private long[] hwDeviceTotalMemory;
    private String[] hwDeviceDescription;
    private String hwHardwareUID;
    private String modelClassName;
    private String modelConfigJson;
    private String[] modelParamNames;
    private int modelNumLayers;
    private long modelNumParams;

    @Override
    public void reportIDs(String sessionID, String typeID, String workerID, long timeStamp) {
        this.sessionID = sessionID;
        this.typeID = typeID;
        this.workerID = workerID;
        this.timeStamp = timeStamp;
    }

    @Override
    public void reportSoftwareInfo(String arch, String osName, String jvmName, String jvmVersion, String jvmSpecVersion, String nd4jBackendClass, String nd4jDataTypeName, String hostname, String jvmUid, Map<String, String> swEnvironmentInfo) {
        this.swArch = arch;
        this.swOsName = osName;
        this.swJvmName = jvmName;
        this.swJvmVersion = jvmVersion;
        this.swJvmSpecVersion = jvmSpecVersion;
        this.swNd4jBackendClass = nd4jBackendClass;
        this.swNd4jDataTypeName = nd4jDataTypeName;
        this.swHostName = hostname;
        this.swJvmUID = jvmUid;
        this.swEnvironmentInfo = swEnvironmentInfo;
        this.hasSoftwareInfo = true;
    }

    @Override
    public void reportHardwareInfo(int jvmAvailableProcessors, int numDevices, long jvmMaxMemory, long offHeapMaxMemory, long[] deviceTotalMemory, String[] deviceDescription, String hardwareUID) {
        this.hwJvmAvailableProcessors = jvmAvailableProcessors;
        this.hwNumDevices = numDevices;
        this.hwJvmMaxMemory = jvmMaxMemory;
        this.hwOffHeapMaxMemory = offHeapMaxMemory;
        this.hwDeviceTotalMemory = deviceTotalMemory;
        this.hwDeviceDescription = deviceDescription;
        this.hwHardwareUID = hardwareUID;
        this.hasHardwareInfo = true;
    }

    @Override
    public void reportModelInfo(String modelClassName, String modelConfigJson, String[] modelParamNames, int numLayers, long numParams) {
        this.modelClassName = modelClassName;
        this.modelConfigJson = modelConfigJson;
        this.modelParamNames = modelParamNames;
        this.modelNumLayers = numLayers;
        this.modelNumParams = numParams;
        this.hasModelInfo = true;
    }

    @Override
    public boolean hasSoftwareInfo() {
        return this.hasSoftwareInfo;
    }

    @Override
    public boolean hasHardwareInfo() {
        return this.hasHardwareInfo;
    }

    @Override
    public boolean hasModelInfo() {
        return this.hasModelInfo;
    }

    public int encodingLengthBytes() {
        byte[] encoded = this.encode();
        return encoded.length;
    }

    public byte[] encode() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (ObjectOutputStream oos = new ObjectOutputStream(baos);){
            oos.writeObject(this);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return baos.toByteArray();
    }

    public void encode(ByteBuffer buffer) {
        buffer.put(this.encode());
    }

    public void encode(OutputStream outputStream) throws IOException {
        try (ObjectOutputStream oos = new ObjectOutputStream(outputStream);){
            oos.writeObject(this);
        }
    }

    public void decode(byte[] decode) {
        Field[] fields;
        JavaStatsInitializationReport r;
        try {
            Field[] fieldArray = null;
            try (ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(decode));){
                r = (JavaStatsInitializationReport)ois.readObject();
            }
            catch (Throwable object) {
                fieldArray = object;
                throw object;
            }
        }
        catch (IOException | ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        for (Field f : fields = JavaStatsInitializationReport.class.getDeclaredFields()) {
            f.setAccessible(true);
            try {
                f.set(this, f.get(r));
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void decode(ByteBuffer buffer) {
        byte[] bytes = new byte[buffer.remaining()];
        buffer.get(bytes);
        this.decode(bytes);
    }

    public void decode(InputStream inputStream) throws IOException {
        this.decode(IOUtils.toByteArray((InputStream)inputStream));
    }

    public String getSessionID() {
        return this.sessionID;
    }

    public String getTypeID() {
        return this.typeID;
    }

    public String getWorkerID() {
        return this.workerID;
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public boolean isHasSoftwareInfo() {
        return this.hasSoftwareInfo;
    }

    public boolean isHasHardwareInfo() {
        return this.hasHardwareInfo;
    }

    public boolean isHasModelInfo() {
        return this.hasModelInfo;
    }

    @Override
    public String getSwArch() {
        return this.swArch;
    }

    @Override
    public String getSwOsName() {
        return this.swOsName;
    }

    @Override
    public String getSwJvmName() {
        return this.swJvmName;
    }

    @Override
    public String getSwJvmVersion() {
        return this.swJvmVersion;
    }

    @Override
    public String getSwJvmSpecVersion() {
        return this.swJvmSpecVersion;
    }

    @Override
    public String getSwNd4jBackendClass() {
        return this.swNd4jBackendClass;
    }

    @Override
    public String getSwNd4jDataTypeName() {
        return this.swNd4jDataTypeName;
    }

    @Override
    public String getSwHostName() {
        return this.swHostName;
    }

    @Override
    public String getSwJvmUID() {
        return this.swJvmUID;
    }

    @Override
    public Map<String, String> getSwEnvironmentInfo() {
        return this.swEnvironmentInfo;
    }

    @Override
    public int getHwJvmAvailableProcessors() {
        return this.hwJvmAvailableProcessors;
    }

    @Override
    public int getHwNumDevices() {
        return this.hwNumDevices;
    }

    @Override
    public long getHwJvmMaxMemory() {
        return this.hwJvmMaxMemory;
    }

    @Override
    public long getHwOffHeapMaxMemory() {
        return this.hwOffHeapMaxMemory;
    }

    @Override
    public long[] getHwDeviceTotalMemory() {
        return this.hwDeviceTotalMemory;
    }

    @Override
    public String[] getHwDeviceDescription() {
        return this.hwDeviceDescription;
    }

    @Override
    public String getHwHardwareUID() {
        return this.hwHardwareUID;
    }

    @Override
    public String getModelClassName() {
        return this.modelClassName;
    }

    @Override
    public String getModelConfigJson() {
        return this.modelConfigJson;
    }

    @Override
    public String[] getModelParamNames() {
        return this.modelParamNames;
    }

    @Override
    public int getModelNumLayers() {
        return this.modelNumLayers;
    }

    @Override
    public long getModelNumParams() {
        return this.modelNumParams;
    }

    public void setSessionID(String sessionID) {
        this.sessionID = sessionID;
    }

    public void setTypeID(String typeID) {
        this.typeID = typeID;
    }

    public void setWorkerID(String workerID) {
        this.workerID = workerID;
    }

    public void setTimeStamp(long timeStamp) {
        this.timeStamp = timeStamp;
    }

    public void setHasSoftwareInfo(boolean hasSoftwareInfo) {
        this.hasSoftwareInfo = hasSoftwareInfo;
    }

    public void setHasHardwareInfo(boolean hasHardwareInfo) {
        this.hasHardwareInfo = hasHardwareInfo;
    }

    public void setHasModelInfo(boolean hasModelInfo) {
        this.hasModelInfo = hasModelInfo;
    }

    public void setSwArch(String swArch) {
        this.swArch = swArch;
    }

    public void setSwOsName(String swOsName) {
        this.swOsName = swOsName;
    }

    public void setSwJvmName(String swJvmName) {
        this.swJvmName = swJvmName;
    }

    public void setSwJvmVersion(String swJvmVersion) {
        this.swJvmVersion = swJvmVersion;
    }

    public void setSwJvmSpecVersion(String swJvmSpecVersion) {
        this.swJvmSpecVersion = swJvmSpecVersion;
    }

    public void setSwNd4jBackendClass(String swNd4jBackendClass) {
        this.swNd4jBackendClass = swNd4jBackendClass;
    }

    public void setSwNd4jDataTypeName(String swNd4jDataTypeName) {
        this.swNd4jDataTypeName = swNd4jDataTypeName;
    }

    public void setSwHostName(String swHostName) {
        this.swHostName = swHostName;
    }

    public void setSwJvmUID(String swJvmUID) {
        this.swJvmUID = swJvmUID;
    }

    public void setSwEnvironmentInfo(Map<String, String> swEnvironmentInfo) {
        this.swEnvironmentInfo = swEnvironmentInfo;
    }

    public void setHwJvmAvailableProcessors(int hwJvmAvailableProcessors) {
        this.hwJvmAvailableProcessors = hwJvmAvailableProcessors;
    }

    public void setHwNumDevices(int hwNumDevices) {
        this.hwNumDevices = hwNumDevices;
    }

    public void setHwJvmMaxMemory(long hwJvmMaxMemory) {
        this.hwJvmMaxMemory = hwJvmMaxMemory;
    }

    public void setHwOffHeapMaxMemory(long hwOffHeapMaxMemory) {
        this.hwOffHeapMaxMemory = hwOffHeapMaxMemory;
    }

    public void setHwDeviceTotalMemory(long[] hwDeviceTotalMemory) {
        this.hwDeviceTotalMemory = hwDeviceTotalMemory;
    }

    public void setHwDeviceDescription(String[] hwDeviceDescription) {
        this.hwDeviceDescription = hwDeviceDescription;
    }

    public void setHwHardwareUID(String hwHardwareUID) {
        this.hwHardwareUID = hwHardwareUID;
    }

    public void setModelClassName(String modelClassName) {
        this.modelClassName = modelClassName;
    }

    public void setModelConfigJson(String modelConfigJson) {
        this.modelConfigJson = modelConfigJson;
    }

    public void setModelParamNames(String[] modelParamNames) {
        this.modelParamNames = modelParamNames;
    }

    public void setModelNumLayers(int modelNumLayers) {
        this.modelNumLayers = modelNumLayers;
    }

    public void setModelNumParams(long modelNumParams) {
        this.modelNumParams = modelNumParams;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JavaStatsInitializationReport)) {
            return false;
        }
        JavaStatsInitializationReport other = (JavaStatsInitializationReport)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getTimeStamp() != other.getTimeStamp()) {
            return false;
        }
        if (this.isHasSoftwareInfo() != other.isHasSoftwareInfo()) {
            return false;
        }
        if (this.isHasHardwareInfo() != other.isHasHardwareInfo()) {
            return false;
        }
        if (this.isHasModelInfo() != other.isHasModelInfo()) {
            return false;
        }
        if (this.getHwJvmAvailableProcessors() != other.getHwJvmAvailableProcessors()) {
            return false;
        }
        if (this.getHwNumDevices() != other.getHwNumDevices()) {
            return false;
        }
        if (this.getHwJvmMaxMemory() != other.getHwJvmMaxMemory()) {
            return false;
        }
        if (this.getHwOffHeapMaxMemory() != other.getHwOffHeapMaxMemory()) {
            return false;
        }
        if (this.getModelNumLayers() != other.getModelNumLayers()) {
            return false;
        }
        if (this.getModelNumParams() != other.getModelNumParams()) {
            return false;
        }
        String this$sessionID = this.getSessionID();
        String other$sessionID = other.getSessionID();
        if (this$sessionID == null ? other$sessionID != null : !this$sessionID.equals(other$sessionID)) {
            return false;
        }
        String this$typeID = this.getTypeID();
        String other$typeID = other.getTypeID();
        if (this$typeID == null ? other$typeID != null : !this$typeID.equals(other$typeID)) {
            return false;
        }
        String this$workerID = this.getWorkerID();
        String other$workerID = other.getWorkerID();
        if (this$workerID == null ? other$workerID != null : !this$workerID.equals(other$workerID)) {
            return false;
        }
        String this$swArch = this.getSwArch();
        String other$swArch = other.getSwArch();
        if (this$swArch == null ? other$swArch != null : !this$swArch.equals(other$swArch)) {
            return false;
        }
        String this$swOsName = this.getSwOsName();
        String other$swOsName = other.getSwOsName();
        if (this$swOsName == null ? other$swOsName != null : !this$swOsName.equals(other$swOsName)) {
            return false;
        }
        String this$swJvmName = this.getSwJvmName();
        String other$swJvmName = other.getSwJvmName();
        if (this$swJvmName == null ? other$swJvmName != null : !this$swJvmName.equals(other$swJvmName)) {
            return false;
        }
        String this$swJvmVersion = this.getSwJvmVersion();
        String other$swJvmVersion = other.getSwJvmVersion();
        if (this$swJvmVersion == null ? other$swJvmVersion != null : !this$swJvmVersion.equals(other$swJvmVersion)) {
            return false;
        }
        String this$swJvmSpecVersion = this.getSwJvmSpecVersion();
        String other$swJvmSpecVersion = other.getSwJvmSpecVersion();
        if (this$swJvmSpecVersion == null ? other$swJvmSpecVersion != null : !this$swJvmSpecVersion.equals(other$swJvmSpecVersion)) {
            return false;
        }
        String this$swNd4jBackendClass = this.getSwNd4jBackendClass();
        String other$swNd4jBackendClass = other.getSwNd4jBackendClass();
        if (this$swNd4jBackendClass == null ? other$swNd4jBackendClass != null : !this$swNd4jBackendClass.equals(other$swNd4jBackendClass)) {
            return false;
        }
        String this$swNd4jDataTypeName = this.getSwNd4jDataTypeName();
        String other$swNd4jDataTypeName = other.getSwNd4jDataTypeName();
        if (this$swNd4jDataTypeName == null ? other$swNd4jDataTypeName != null : !this$swNd4jDataTypeName.equals(other$swNd4jDataTypeName)) {
            return false;
        }
        String this$swHostName = this.getSwHostName();
        String other$swHostName = other.getSwHostName();
        if (this$swHostName == null ? other$swHostName != null : !this$swHostName.equals(other$swHostName)) {
            return false;
        }
        String this$swJvmUID = this.getSwJvmUID();
        String other$swJvmUID = other.getSwJvmUID();
        if (this$swJvmUID == null ? other$swJvmUID != null : !this$swJvmUID.equals(other$swJvmUID)) {
            return false;
        }
        Map<String, String> this$swEnvironmentInfo = this.getSwEnvironmentInfo();
        Map<String, String> other$swEnvironmentInfo = other.getSwEnvironmentInfo();
        if (this$swEnvironmentInfo == null ? other$swEnvironmentInfo != null : !((Object)this$swEnvironmentInfo).equals(other$swEnvironmentInfo)) {
            return false;
        }
        if (!Arrays.equals(this.getHwDeviceTotalMemory(), other.getHwDeviceTotalMemory())) {
            return false;
        }
        if (!Arrays.deepEquals(this.getHwDeviceDescription(), other.getHwDeviceDescription())) {
            return false;
        }
        String this$hwHardwareUID = this.getHwHardwareUID();
        String other$hwHardwareUID = other.getHwHardwareUID();
        if (this$hwHardwareUID == null ? other$hwHardwareUID != null : !this$hwHardwareUID.equals(other$hwHardwareUID)) {
            return false;
        }
        String this$modelClassName = this.getModelClassName();
        String other$modelClassName = other.getModelClassName();
        if (this$modelClassName == null ? other$modelClassName != null : !this$modelClassName.equals(other$modelClassName)) {
            return false;
        }
        String this$modelConfigJson = this.getModelConfigJson();
        String other$modelConfigJson = other.getModelConfigJson();
        if (this$modelConfigJson == null ? other$modelConfigJson != null : !this$modelConfigJson.equals(other$modelConfigJson)) {
            return false;
        }
        return Arrays.deepEquals(this.getModelParamNames(), other.getModelParamNames());
    }

    protected boolean canEqual(Object other) {
        return other instanceof JavaStatsInitializationReport;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $timeStamp = this.getTimeStamp();
        result = result * 59 + (int)($timeStamp >>> 32 ^ $timeStamp);
        result = result * 59 + (this.isHasSoftwareInfo() ? 79 : 97);
        result = result * 59 + (this.isHasHardwareInfo() ? 79 : 97);
        result = result * 59 + (this.isHasModelInfo() ? 79 : 97);
        result = result * 59 + this.getHwJvmAvailableProcessors();
        result = result * 59 + this.getHwNumDevices();
        long $hwJvmMaxMemory = this.getHwJvmMaxMemory();
        result = result * 59 + (int)($hwJvmMaxMemory >>> 32 ^ $hwJvmMaxMemory);
        long $hwOffHeapMaxMemory = this.getHwOffHeapMaxMemory();
        result = result * 59 + (int)($hwOffHeapMaxMemory >>> 32 ^ $hwOffHeapMaxMemory);
        result = result * 59 + this.getModelNumLayers();
        long $modelNumParams = this.getModelNumParams();
        result = result * 59 + (int)($modelNumParams >>> 32 ^ $modelNumParams);
        String $sessionID = this.getSessionID();
        result = result * 59 + ($sessionID == null ? 43 : $sessionID.hashCode());
        String $typeID = this.getTypeID();
        result = result * 59 + ($typeID == null ? 43 : $typeID.hashCode());
        String $workerID = this.getWorkerID();
        result = result * 59 + ($workerID == null ? 43 : $workerID.hashCode());
        String $swArch = this.getSwArch();
        result = result * 59 + ($swArch == null ? 43 : $swArch.hashCode());
        String $swOsName = this.getSwOsName();
        result = result * 59 + ($swOsName == null ? 43 : $swOsName.hashCode());
        String $swJvmName = this.getSwJvmName();
        result = result * 59 + ($swJvmName == null ? 43 : $swJvmName.hashCode());
        String $swJvmVersion = this.getSwJvmVersion();
        result = result * 59 + ($swJvmVersion == null ? 43 : $swJvmVersion.hashCode());
        String $swJvmSpecVersion = this.getSwJvmSpecVersion();
        result = result * 59 + ($swJvmSpecVersion == null ? 43 : $swJvmSpecVersion.hashCode());
        String $swNd4jBackendClass = this.getSwNd4jBackendClass();
        result = result * 59 + ($swNd4jBackendClass == null ? 43 : $swNd4jBackendClass.hashCode());
        String $swNd4jDataTypeName = this.getSwNd4jDataTypeName();
        result = result * 59 + ($swNd4jDataTypeName == null ? 43 : $swNd4jDataTypeName.hashCode());
        String $swHostName = this.getSwHostName();
        result = result * 59 + ($swHostName == null ? 43 : $swHostName.hashCode());
        String $swJvmUID = this.getSwJvmUID();
        result = result * 59 + ($swJvmUID == null ? 43 : $swJvmUID.hashCode());
        Map<String, String> $swEnvironmentInfo = this.getSwEnvironmentInfo();
        result = result * 59 + ($swEnvironmentInfo == null ? 43 : ((Object)$swEnvironmentInfo).hashCode());
        result = result * 59 + Arrays.hashCode(this.getHwDeviceTotalMemory());
        result = result * 59 + Arrays.deepHashCode(this.getHwDeviceDescription());
        String $hwHardwareUID = this.getHwHardwareUID();
        result = result * 59 + ($hwHardwareUID == null ? 43 : $hwHardwareUID.hashCode());
        String $modelClassName = this.getModelClassName();
        result = result * 59 + ($modelClassName == null ? 43 : $modelClassName.hashCode());
        String $modelConfigJson = this.getModelConfigJson();
        result = result * 59 + ($modelConfigJson == null ? 43 : $modelConfigJson.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getModelParamNames());
        return result;
    }

    public String toString() {
        return "JavaStatsInitializationReport(sessionID=" + this.getSessionID() + ", typeID=" + this.getTypeID() + ", workerID=" + this.getWorkerID() + ", timeStamp=" + this.getTimeStamp() + ", hasSoftwareInfo=" + this.isHasSoftwareInfo() + ", hasHardwareInfo=" + this.isHasHardwareInfo() + ", hasModelInfo=" + this.isHasModelInfo() + ", swArch=" + this.getSwArch() + ", swOsName=" + this.getSwOsName() + ", swJvmName=" + this.getSwJvmName() + ", swJvmVersion=" + this.getSwJvmVersion() + ", swJvmSpecVersion=" + this.getSwJvmSpecVersion() + ", swNd4jBackendClass=" + this.getSwNd4jBackendClass() + ", swNd4jDataTypeName=" + this.getSwNd4jDataTypeName() + ", swHostName=" + this.getSwHostName() + ", swJvmUID=" + this.getSwJvmUID() + ", swEnvironmentInfo=" + this.getSwEnvironmentInfo() + ", hwJvmAvailableProcessors=" + this.getHwJvmAvailableProcessors() + ", hwNumDevices=" + this.getHwNumDevices() + ", hwJvmMaxMemory=" + this.getHwJvmMaxMemory() + ", hwOffHeapMaxMemory=" + this.getHwOffHeapMaxMemory() + ", hwDeviceTotalMemory=" + Arrays.toString(this.getHwDeviceTotalMemory()) + ", hwDeviceDescription=" + Arrays.deepToString(this.getHwDeviceDescription()) + ", hwHardwareUID=" + this.getHwHardwareUID() + ", modelClassName=" + this.getModelClassName() + ", modelConfigJson=" + this.getModelConfigJson() + ", modelParamNames=" + Arrays.deepToString(this.getModelParamNames()) + ", modelNumLayers=" + this.getModelNumLayers() + ", modelNumParams=" + this.getModelNumParams() + ")";
    }
}

