/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.ui.stats.impl.java;

import java.beans.ConstructorProperties;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.compress.utils.IOUtils;
import org.deeplearning4j.ui.stats.api.Histogram;
import org.deeplearning4j.ui.stats.api.StatsReport;
import org.deeplearning4j.ui.stats.api.StatsType;
import org.deeplearning4j.ui.stats.api.SummaryType;
import org.nd4j.linalg.primitives.Pair;

public class JavaStatsReport
implements StatsReport {
    private String sessionID;
    private String typeID;
    private String workerID;
    private long timeStamp;
    private int iterationCount;
    private int statsCollectionDurationMs;
    private double score;
    private long jvmCurrentBytes;
    private long jvmMaxBytes;
    private long offHeapCurrentBytes;
    private long offHeapMaxBytes;
    private long[] deviceCurrentBytes;
    private long[] deviceMaxBytes;
    private long totalRuntimeMs;
    private long totalExamples;
    private long totalMinibatches;
    private double examplesPerSecond;
    private double minibatchesPerSecond;
    private List<GCStats> gcStats;
    private Map<String, Double> learningRatesByParam;
    private Map<StatsType, Map<String, Histogram>> histograms;
    private Map<StatsType, Map<String, Double>> meanValues;
    private Map<StatsType, Map<String, Double>> stdevValues;
    private Map<StatsType, Map<String, Double>> meanMagnitudeValues;
    private String metaDataClassName;
    private List<byte[]> dataSetMetaData;
    private boolean scorePresent;
    private boolean memoryUsePresent;
    private boolean performanceStatsPresent;

    @Override
    public void reportIDs(String sessionID, String typeID, String workerID, long timeStamp) {
        this.sessionID = sessionID;
        this.typeID = typeID;
        this.workerID = workerID;
        this.timeStamp = timeStamp;
    }

    @Override
    public void reportIterationCount(int iterationCount) {
        this.iterationCount = iterationCount;
    }

    @Override
    public void reportStatsCollectionDurationMS(int statsCollectionDurationMS) {
        this.statsCollectionDurationMs = statsCollectionDurationMS;
    }

    @Override
    public void reportScore(double currentScore) {
        this.score = currentScore;
        this.scorePresent = true;
    }

    @Override
    public void reportLearningRates(Map<String, Double> learningRatesByParam) {
        this.learningRatesByParam = learningRatesByParam;
    }

    @Override
    public void reportMemoryUse(long jvmCurrentBytes, long jvmMaxBytes, long offHeapCurrentBytes, long offHeapMaxBytes, long[] deviceCurrentBytes, long[] deviceMaxBytes) {
        this.jvmCurrentBytes = jvmCurrentBytes;
        this.jvmMaxBytes = jvmMaxBytes;
        this.offHeapCurrentBytes = offHeapCurrentBytes;
        this.offHeapMaxBytes = offHeapMaxBytes;
        this.deviceCurrentBytes = deviceCurrentBytes;
        this.deviceMaxBytes = deviceMaxBytes;
        this.memoryUsePresent = true;
    }

    @Override
    public void reportPerformance(long totalRuntimeMs, long totalExamples, long totalMinibatches, double examplesPerSecond, double minibatchesPerSecond) {
        this.totalRuntimeMs = totalRuntimeMs;
        this.totalExamples = totalExamples;
        this.totalMinibatches = totalMinibatches;
        this.examplesPerSecond = examplesPerSecond;
        this.minibatchesPerSecond = minibatchesPerSecond;
        this.performanceStatsPresent = true;
    }

    @Override
    public void reportGarbageCollection(String gcName, int deltaGCCount, int deltaGCTime) {
        if (this.gcStats == null) {
            this.gcStats = new ArrayList<GCStats>();
        }
        this.gcStats.add(new GCStats(gcName, deltaGCCount, deltaGCTime));
    }

    @Override
    public List<Pair<String, int[]>> getGarbageCollectionStats() {
        if (this.gcStats == null) {
            return null;
        }
        ArrayList<Pair<String, int[]>> temp = new ArrayList<Pair<String, int[]>>();
        for (GCStats g : this.gcStats) {
            temp.add((Pair<String, int[]>)new Pair((Object)g.gcName, (Object)new int[]{g.getDeltaGCCount(), g.getDeltaGCTime()}));
        }
        return temp;
    }

    @Override
    public void reportHistograms(StatsType statsType, Map<String, Histogram> histogram) {
        if (this.histograms == null) {
            this.histograms = new HashMap<StatsType, Map<String, Histogram>>();
        }
        this.histograms.put(statsType, histogram);
    }

    @Override
    public Map<String, Histogram> getHistograms(StatsType statsType) {
        if (this.histograms == null) {
            return null;
        }
        return this.histograms.get((Object)statsType);
    }

    @Override
    public void reportMean(StatsType statsType, Map<String, Double> mean) {
        if (this.meanValues == null) {
            this.meanValues = new HashMap<StatsType, Map<String, Double>>();
        }
        this.meanValues.put(statsType, mean);
    }

    @Override
    public Map<String, Double> getMean(StatsType statsType) {
        if (this.meanValues == null) {
            return null;
        }
        return this.meanValues.get((Object)statsType);
    }

    @Override
    public void reportStdev(StatsType statsType, Map<String, Double> stdev) {
        if (this.stdevValues == null) {
            this.stdevValues = new HashMap<StatsType, Map<String, Double>>();
        }
        this.stdevValues.put(statsType, stdev);
    }

    @Override
    public Map<String, Double> getStdev(StatsType statsType) {
        if (this.stdevValues == null) {
            return null;
        }
        return this.stdevValues.get((Object)statsType);
    }

    @Override
    public void reportMeanMagnitudes(StatsType statsType, Map<String, Double> meanMagnitudes) {
        if (this.meanMagnitudeValues == null) {
            this.meanMagnitudeValues = new HashMap<StatsType, Map<String, Double>>();
        }
        this.meanMagnitudeValues.put(statsType, meanMagnitudes);
    }

    @Override
    public void reportDataSetMetaData(List<Serializable> dataSetMetaData, Class<?> metaDataClass) {
        this.reportDataSetMetaData(dataSetMetaData, metaDataClass == null ? null : metaDataClass.getName());
    }

    @Override
    public void reportDataSetMetaData(List<Serializable> dataSetMetaData, String metaDataClass) {
        if (dataSetMetaData != null) {
            this.dataSetMetaData = new ArrayList<byte[]>();
            for (Serializable s : dataSetMetaData) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                try (ObjectOutputStream oos = new ObjectOutputStream(baos);){
                    oos.writeObject(s);
                    oos.flush();
                    oos.close();
                }
                catch (IOException e) {
                    throw new RuntimeException("Unexpected IOException from ByteArrayOutputStream", e);
                }
                byte[] b = baos.toByteArray();
                this.dataSetMetaData.add(b);
            }
        } else {
            this.dataSetMetaData = null;
        }
        this.metaDataClassName = metaDataClass;
    }

    @Override
    public Map<String, Double> getMeanMagnitudes(StatsType statsType) {
        if (this.meanMagnitudeValues == null) {
            return null;
        }
        return this.meanMagnitudeValues.get((Object)statsType);
    }

    @Override
    public List<Serializable> getDataSetMetaData() {
        if (this.dataSetMetaData == null || this.dataSetMetaData.size() == 0) {
            return null;
        }
        ArrayList<Serializable> l = new ArrayList<Serializable>();
        for (byte[] b : this.dataSetMetaData) {
            try {
                ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(b));
                Throwable throwable = null;
                try {
                    l.add((Serializable)ois.readObject());
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (ois == null) continue;
                    if (throwable != null) {
                        try {
                            ois.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    ois.close();
                }
            }
            catch (IOException | ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        return l;
    }

    @Override
    public String getDataSetMetaDataClassName() {
        return this.metaDataClassName;
    }

    @Override
    public Map<String, Double> getLearningRates() {
        return this.learningRatesByParam;
    }

    @Override
    public boolean hasScore() {
        return this.scorePresent;
    }

    @Override
    public boolean hasLearningRates() {
        return this.learningRatesByParam != null;
    }

    @Override
    public boolean hasMemoryUse() {
        return this.memoryUsePresent;
    }

    @Override
    public boolean hasPerformance() {
        return this.performanceStatsPresent;
    }

    @Override
    public boolean hasGarbageCollection() {
        return this.gcStats != null && this.gcStats.size() > 0;
    }

    @Override
    public boolean hasHistograms(StatsType statsType) {
        if (this.histograms == null) {
            return false;
        }
        return this.histograms.containsKey((Object)statsType);
    }

    @Override
    public boolean hasSummaryStats(StatsType statsType, SummaryType summaryType) {
        switch (summaryType) {
            case Mean: {
                return this.meanValues != null && this.meanValues.containsKey((Object)statsType);
            }
            case Stdev: {
                return this.stdevValues != null && this.stdevValues.containsKey((Object)statsType);
            }
            case MeanMagnitudes: {
                return this.meanMagnitudeValues != null && this.meanMagnitudeValues.containsKey((Object)statsType);
            }
        }
        return false;
    }

    @Override
    public boolean hasDataSetMetaData() {
        return this.dataSetMetaData != null || this.metaDataClassName != null;
    }

    public int encodingLengthBytes() {
        byte[] encoded = this.encode();
        return encoded.length;
    }

    public byte[] encode() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (ObjectOutputStream oos = new ObjectOutputStream(baos);){
            oos.writeObject(this);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return baos.toByteArray();
    }

    public void encode(ByteBuffer buffer) {
        buffer.put(this.encode());
    }

    public void encode(OutputStream outputStream) throws IOException {
        try (ObjectOutputStream oos = new ObjectOutputStream(outputStream);){
            oos.writeObject(this);
        }
    }

    public void decode(byte[] decode) {
        Field[] fields;
        JavaStatsReport r;
        try {
            Field[] fieldArray = null;
            try (ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(decode));){
                r = (JavaStatsReport)ois.readObject();
            }
            catch (Throwable object) {
                fieldArray = object;
                throw object;
            }
        }
        catch (IOException | ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        for (Field f : fields = JavaStatsReport.class.getDeclaredFields()) {
            f.setAccessible(true);
            try {
                f.set(this, f.get(r));
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void decode(ByteBuffer buffer) {
        byte[] bytes = new byte[buffer.remaining()];
        buffer.get(bytes);
        this.decode(bytes);
    }

    public void decode(InputStream inputStream) throws IOException {
        this.decode(IOUtils.toByteArray((InputStream)inputStream));
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JavaStatsReport)) {
            return false;
        }
        JavaStatsReport other = (JavaStatsReport)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$sessionID = this.getSessionID();
        String other$sessionID = other.getSessionID();
        if (this$sessionID == null ? other$sessionID != null : !this$sessionID.equals(other$sessionID)) {
            return false;
        }
        String this$typeID = this.getTypeID();
        String other$typeID = other.getTypeID();
        if (this$typeID == null ? other$typeID != null : !this$typeID.equals(other$typeID)) {
            return false;
        }
        String this$workerID = this.getWorkerID();
        String other$workerID = other.getWorkerID();
        if (this$workerID == null ? other$workerID != null : !this$workerID.equals(other$workerID)) {
            return false;
        }
        if (this.getTimeStamp() != other.getTimeStamp()) {
            return false;
        }
        if (this.getIterationCount() != other.getIterationCount()) {
            return false;
        }
        if (this.getStatsCollectionDurationMs() != other.getStatsCollectionDurationMs()) {
            return false;
        }
        if (Double.compare(this.getScore(), other.getScore()) != 0) {
            return false;
        }
        if (this.getJvmCurrentBytes() != other.getJvmCurrentBytes()) {
            return false;
        }
        if (this.getJvmMaxBytes() != other.getJvmMaxBytes()) {
            return false;
        }
        if (this.getOffHeapCurrentBytes() != other.getOffHeapCurrentBytes()) {
            return false;
        }
        if (this.getOffHeapMaxBytes() != other.getOffHeapMaxBytes()) {
            return false;
        }
        if (!Arrays.equals(this.getDeviceCurrentBytes(), other.getDeviceCurrentBytes())) {
            return false;
        }
        if (!Arrays.equals(this.getDeviceMaxBytes(), other.getDeviceMaxBytes())) {
            return false;
        }
        if (this.getTotalRuntimeMs() != other.getTotalRuntimeMs()) {
            return false;
        }
        if (this.getTotalExamples() != other.getTotalExamples()) {
            return false;
        }
        if (this.getTotalMinibatches() != other.getTotalMinibatches()) {
            return false;
        }
        if (Double.compare(this.getExamplesPerSecond(), other.getExamplesPerSecond()) != 0) {
            return false;
        }
        if (Double.compare(this.getMinibatchesPerSecond(), other.getMinibatchesPerSecond()) != 0) {
            return false;
        }
        List<GCStats> this$gcStats = this.getGcStats();
        List<GCStats> other$gcStats = other.getGcStats();
        if (this$gcStats == null ? other$gcStats != null : !((Object)this$gcStats).equals(other$gcStats)) {
            return false;
        }
        Map<String, Double> this$learningRatesByParam = this.getLearningRatesByParam();
        Map<String, Double> other$learningRatesByParam = other.getLearningRatesByParam();
        if (this$learningRatesByParam == null ? other$learningRatesByParam != null : !((Object)this$learningRatesByParam).equals(other$learningRatesByParam)) {
            return false;
        }
        Map<StatsType, Map<String, Histogram>> this$histograms = this.getHistograms();
        Map<StatsType, Map<String, Histogram>> other$histograms = other.getHistograms();
        if (this$histograms == null ? other$histograms != null : !((Object)this$histograms).equals(other$histograms)) {
            return false;
        }
        Map<StatsType, Map<String, Double>> this$meanValues = this.getMeanValues();
        Map<StatsType, Map<String, Double>> other$meanValues = other.getMeanValues();
        if (this$meanValues == null ? other$meanValues != null : !((Object)this$meanValues).equals(other$meanValues)) {
            return false;
        }
        Map<StatsType, Map<String, Double>> this$stdevValues = this.getStdevValues();
        Map<StatsType, Map<String, Double>> other$stdevValues = other.getStdevValues();
        if (this$stdevValues == null ? other$stdevValues != null : !((Object)this$stdevValues).equals(other$stdevValues)) {
            return false;
        }
        Map<StatsType, Map<String, Double>> this$meanMagnitudeValues = this.getMeanMagnitudeValues();
        Map<StatsType, Map<String, Double>> other$meanMagnitudeValues = other.getMeanMagnitudeValues();
        if (this$meanMagnitudeValues == null ? other$meanMagnitudeValues != null : !((Object)this$meanMagnitudeValues).equals(other$meanMagnitudeValues)) {
            return false;
        }
        String this$metaDataClassName = this.getMetaDataClassName();
        String other$metaDataClassName = other.getMetaDataClassName();
        if (this$metaDataClassName == null ? other$metaDataClassName != null : !this$metaDataClassName.equals(other$metaDataClassName)) {
            return false;
        }
        List<Serializable> this$dataSetMetaData = this.getDataSetMetaData();
        List<Serializable> other$dataSetMetaData = other.getDataSetMetaData();
        if (this$dataSetMetaData == null ? other$dataSetMetaData != null : !((Object)this$dataSetMetaData).equals(other$dataSetMetaData)) {
            return false;
        }
        if (this.isScorePresent() != other.isScorePresent()) {
            return false;
        }
        if (this.isMemoryUsePresent() != other.isMemoryUsePresent()) {
            return false;
        }
        return this.isPerformanceStatsPresent() == other.isPerformanceStatsPresent();
    }

    protected boolean canEqual(Object other) {
        return other instanceof JavaStatsReport;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $sessionID = this.getSessionID();
        result = result * 59 + ($sessionID == null ? 43 : $sessionID.hashCode());
        String $typeID = this.getTypeID();
        result = result * 59 + ($typeID == null ? 43 : $typeID.hashCode());
        String $workerID = this.getWorkerID();
        result = result * 59 + ($workerID == null ? 43 : $workerID.hashCode());
        long $timeStamp = this.getTimeStamp();
        result = result * 59 + (int)($timeStamp >>> 32 ^ $timeStamp);
        result = result * 59 + this.getIterationCount();
        result = result * 59 + this.getStatsCollectionDurationMs();
        long $score = Double.doubleToLongBits(this.getScore());
        result = result * 59 + (int)($score >>> 32 ^ $score);
        long $jvmCurrentBytes = this.getJvmCurrentBytes();
        result = result * 59 + (int)($jvmCurrentBytes >>> 32 ^ $jvmCurrentBytes);
        long $jvmMaxBytes = this.getJvmMaxBytes();
        result = result * 59 + (int)($jvmMaxBytes >>> 32 ^ $jvmMaxBytes);
        long $offHeapCurrentBytes = this.getOffHeapCurrentBytes();
        result = result * 59 + (int)($offHeapCurrentBytes >>> 32 ^ $offHeapCurrentBytes);
        long $offHeapMaxBytes = this.getOffHeapMaxBytes();
        result = result * 59 + (int)($offHeapMaxBytes >>> 32 ^ $offHeapMaxBytes);
        result = result * 59 + Arrays.hashCode(this.getDeviceCurrentBytes());
        result = result * 59 + Arrays.hashCode(this.getDeviceMaxBytes());
        long $totalRuntimeMs = this.getTotalRuntimeMs();
        result = result * 59 + (int)($totalRuntimeMs >>> 32 ^ $totalRuntimeMs);
        long $totalExamples = this.getTotalExamples();
        result = result * 59 + (int)($totalExamples >>> 32 ^ $totalExamples);
        long $totalMinibatches = this.getTotalMinibatches();
        result = result * 59 + (int)($totalMinibatches >>> 32 ^ $totalMinibatches);
        long $examplesPerSecond = Double.doubleToLongBits(this.getExamplesPerSecond());
        result = result * 59 + (int)($examplesPerSecond >>> 32 ^ $examplesPerSecond);
        long $minibatchesPerSecond = Double.doubleToLongBits(this.getMinibatchesPerSecond());
        result = result * 59 + (int)($minibatchesPerSecond >>> 32 ^ $minibatchesPerSecond);
        List<GCStats> $gcStats = this.getGcStats();
        result = result * 59 + ($gcStats == null ? 43 : ((Object)$gcStats).hashCode());
        Map<String, Double> $learningRatesByParam = this.getLearningRatesByParam();
        result = result * 59 + ($learningRatesByParam == null ? 43 : ((Object)$learningRatesByParam).hashCode());
        Map<StatsType, Map<String, Histogram>> $histograms = this.getHistograms();
        result = result * 59 + ($histograms == null ? 43 : ((Object)$histograms).hashCode());
        Map<StatsType, Map<String, Double>> $meanValues = this.getMeanValues();
        result = result * 59 + ($meanValues == null ? 43 : ((Object)$meanValues).hashCode());
        Map<StatsType, Map<String, Double>> $stdevValues = this.getStdevValues();
        result = result * 59 + ($stdevValues == null ? 43 : ((Object)$stdevValues).hashCode());
        Map<StatsType, Map<String, Double>> $meanMagnitudeValues = this.getMeanMagnitudeValues();
        result = result * 59 + ($meanMagnitudeValues == null ? 43 : ((Object)$meanMagnitudeValues).hashCode());
        String $metaDataClassName = this.getMetaDataClassName();
        result = result * 59 + ($metaDataClassName == null ? 43 : $metaDataClassName.hashCode());
        List<Serializable> $dataSetMetaData = this.getDataSetMetaData();
        result = result * 59 + ($dataSetMetaData == null ? 43 : ((Object)$dataSetMetaData).hashCode());
        result = result * 59 + (this.isScorePresent() ? 79 : 97);
        result = result * 59 + (this.isMemoryUsePresent() ? 79 : 97);
        result = result * 59 + (this.isPerformanceStatsPresent() ? 79 : 97);
        return result;
    }

    public String toString() {
        return "JavaStatsReport(sessionID=" + this.getSessionID() + ", typeID=" + this.getTypeID() + ", workerID=" + this.getWorkerID() + ", timeStamp=" + this.getTimeStamp() + ", iterationCount=" + this.getIterationCount() + ", statsCollectionDurationMs=" + this.getStatsCollectionDurationMs() + ", score=" + this.getScore() + ", jvmCurrentBytes=" + this.getJvmCurrentBytes() + ", jvmMaxBytes=" + this.getJvmMaxBytes() + ", offHeapCurrentBytes=" + this.getOffHeapCurrentBytes() + ", offHeapMaxBytes=" + this.getOffHeapMaxBytes() + ", deviceCurrentBytes=" + Arrays.toString(this.getDeviceCurrentBytes()) + ", deviceMaxBytes=" + Arrays.toString(this.getDeviceMaxBytes()) + ", totalRuntimeMs=" + this.getTotalRuntimeMs() + ", totalExamples=" + this.getTotalExamples() + ", totalMinibatches=" + this.getTotalMinibatches() + ", examplesPerSecond=" + this.getExamplesPerSecond() + ", minibatchesPerSecond=" + this.getMinibatchesPerSecond() + ", gcStats=" + this.getGcStats() + ", learningRatesByParam=" + this.getLearningRatesByParam() + ", histograms=" + this.getHistograms() + ", meanValues=" + this.getMeanValues() + ", stdevValues=" + this.getStdevValues() + ", meanMagnitudeValues=" + this.getMeanMagnitudeValues() + ", metaDataClassName=" + this.getMetaDataClassName() + ", dataSetMetaData=" + this.getDataSetMetaData() + ", scorePresent=" + this.isScorePresent() + ", memoryUsePresent=" + this.isMemoryUsePresent() + ", performanceStatsPresent=" + this.isPerformanceStatsPresent() + ")";
    }

    public String getSessionID() {
        return this.sessionID;
    }

    public String getTypeID() {
        return this.typeID;
    }

    public String getWorkerID() {
        return this.workerID;
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    @Override
    public int getIterationCount() {
        return this.iterationCount;
    }

    @Override
    public int getStatsCollectionDurationMs() {
        return this.statsCollectionDurationMs;
    }

    @Override
    public double getScore() {
        return this.score;
    }

    @Override
    public long getJvmCurrentBytes() {
        return this.jvmCurrentBytes;
    }

    @Override
    public long getJvmMaxBytes() {
        return this.jvmMaxBytes;
    }

    @Override
    public long getOffHeapCurrentBytes() {
        return this.offHeapCurrentBytes;
    }

    @Override
    public long getOffHeapMaxBytes() {
        return this.offHeapMaxBytes;
    }

    @Override
    public long[] getDeviceCurrentBytes() {
        return this.deviceCurrentBytes;
    }

    @Override
    public long[] getDeviceMaxBytes() {
        return this.deviceMaxBytes;
    }

    @Override
    public long getTotalRuntimeMs() {
        return this.totalRuntimeMs;
    }

    @Override
    public long getTotalExamples() {
        return this.totalExamples;
    }

    @Override
    public long getTotalMinibatches() {
        return this.totalMinibatches;
    }

    @Override
    public double getExamplesPerSecond() {
        return this.examplesPerSecond;
    }

    @Override
    public double getMinibatchesPerSecond() {
        return this.minibatchesPerSecond;
    }

    public List<GCStats> getGcStats() {
        return this.gcStats;
    }

    public Map<String, Double> getLearningRatesByParam() {
        return this.learningRatesByParam;
    }

    public Map<StatsType, Map<String, Histogram>> getHistograms() {
        return this.histograms;
    }

    public Map<StatsType, Map<String, Double>> getMeanValues() {
        return this.meanValues;
    }

    public Map<StatsType, Map<String, Double>> getStdevValues() {
        return this.stdevValues;
    }

    public Map<StatsType, Map<String, Double>> getMeanMagnitudeValues() {
        return this.meanMagnitudeValues;
    }

    public String getMetaDataClassName() {
        return this.metaDataClassName;
    }

    public boolean isScorePresent() {
        return this.scorePresent;
    }

    public boolean isMemoryUsePresent() {
        return this.memoryUsePresent;
    }

    public boolean isPerformanceStatsPresent() {
        return this.performanceStatsPresent;
    }

    public void setSessionID(String sessionID) {
        this.sessionID = sessionID;
    }

    public void setTypeID(String typeID) {
        this.typeID = typeID;
    }

    public void setWorkerID(String workerID) {
        this.workerID = workerID;
    }

    public void setTimeStamp(long timeStamp) {
        this.timeStamp = timeStamp;
    }

    public void setIterationCount(int iterationCount) {
        this.iterationCount = iterationCount;
    }

    public void setStatsCollectionDurationMs(int statsCollectionDurationMs) {
        this.statsCollectionDurationMs = statsCollectionDurationMs;
    }

    public void setScore(double score) {
        this.score = score;
    }

    public void setJvmCurrentBytes(long jvmCurrentBytes) {
        this.jvmCurrentBytes = jvmCurrentBytes;
    }

    public void setJvmMaxBytes(long jvmMaxBytes) {
        this.jvmMaxBytes = jvmMaxBytes;
    }

    public void setOffHeapCurrentBytes(long offHeapCurrentBytes) {
        this.offHeapCurrentBytes = offHeapCurrentBytes;
    }

    public void setOffHeapMaxBytes(long offHeapMaxBytes) {
        this.offHeapMaxBytes = offHeapMaxBytes;
    }

    public void setDeviceCurrentBytes(long[] deviceCurrentBytes) {
        this.deviceCurrentBytes = deviceCurrentBytes;
    }

    public void setDeviceMaxBytes(long[] deviceMaxBytes) {
        this.deviceMaxBytes = deviceMaxBytes;
    }

    public void setTotalRuntimeMs(long totalRuntimeMs) {
        this.totalRuntimeMs = totalRuntimeMs;
    }

    public void setTotalExamples(long totalExamples) {
        this.totalExamples = totalExamples;
    }

    public void setTotalMinibatches(long totalMinibatches) {
        this.totalMinibatches = totalMinibatches;
    }

    public void setExamplesPerSecond(double examplesPerSecond) {
        this.examplesPerSecond = examplesPerSecond;
    }

    public void setMinibatchesPerSecond(double minibatchesPerSecond) {
        this.minibatchesPerSecond = minibatchesPerSecond;
    }

    public void setGcStats(List<GCStats> gcStats) {
        this.gcStats = gcStats;
    }

    public void setLearningRatesByParam(Map<String, Double> learningRatesByParam) {
        this.learningRatesByParam = learningRatesByParam;
    }

    public void setHistograms(Map<StatsType, Map<String, Histogram>> histograms) {
        this.histograms = histograms;
    }

    public void setMeanValues(Map<StatsType, Map<String, Double>> meanValues) {
        this.meanValues = meanValues;
    }

    public void setStdevValues(Map<StatsType, Map<String, Double>> stdevValues) {
        this.stdevValues = stdevValues;
    }

    public void setMeanMagnitudeValues(Map<StatsType, Map<String, Double>> meanMagnitudeValues) {
        this.meanMagnitudeValues = meanMagnitudeValues;
    }

    public void setMetaDataClassName(String metaDataClassName) {
        this.metaDataClassName = metaDataClassName;
    }

    public void setDataSetMetaData(List<byte[]> dataSetMetaData) {
        this.dataSetMetaData = dataSetMetaData;
    }

    public void setScorePresent(boolean scorePresent) {
        this.scorePresent = scorePresent;
    }

    public void setMemoryUsePresent(boolean memoryUsePresent) {
        this.memoryUsePresent = memoryUsePresent;
    }

    public void setPerformanceStatsPresent(boolean performanceStatsPresent) {
        this.performanceStatsPresent = performanceStatsPresent;
    }

    private static class GCStats
    implements Serializable {
        private String gcName;
        private int deltaGCCount;
        private int deltaGCTime;

        @ConstructorProperties(value={"gcName", "deltaGCCount", "deltaGCTime"})
        public GCStats(String gcName, int deltaGCCount, int deltaGCTime) {
            this.gcName = gcName;
            this.deltaGCCount = deltaGCCount;
            this.deltaGCTime = deltaGCTime;
        }

        public String getGcName() {
            return this.gcName;
        }

        public int getDeltaGCCount() {
            return this.deltaGCCount;
        }

        public int getDeltaGCTime() {
            return this.deltaGCTime;
        }

        public void setGcName(String gcName) {
            this.gcName = gcName;
        }

        public void setDeltaGCCount(int deltaGCCount) {
            this.deltaGCCount = deltaGCCount;
        }

        public void setDeltaGCTime(int deltaGCTime) {
            this.deltaGCTime = deltaGCTime;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof GCStats)) {
                return false;
            }
            GCStats other = (GCStats)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$gcName = this.getGcName();
            String other$gcName = other.getGcName();
            if (this$gcName == null ? other$gcName != null : !this$gcName.equals(other$gcName)) {
                return false;
            }
            if (this.getDeltaGCCount() != other.getDeltaGCCount()) {
                return false;
            }
            return this.getDeltaGCTime() == other.getDeltaGCTime();
        }

        protected boolean canEqual(Object other) {
            return other instanceof GCStats;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $gcName = this.getGcName();
            result = result * 59 + ($gcName == null ? 43 : $gcName.hashCode());
            result = result * 59 + this.getDeltaGCCount();
            result = result * 59 + this.getDeltaGCTime();
            return result;
        }

        public String toString() {
            return "JavaStatsReport.GCStats(gcName=" + this.getGcName() + ", deltaGCCount=" + this.getDeltaGCCount() + ", deltaGCTime=" + this.getDeltaGCTime() + ")";
        }
    }
}

