/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.ui.flow.beans;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.deeplearning4j.ui.flow.beans.LayerParams;

public class ModelState
implements Serializable {
    private float score = 0.0f;
    private String trainingTime;
    private List<Float> scores = new ArrayList<Float>();
    private float performanceBatches;
    private float performanceSamples;
    private long iterationTime;
    private Map<String, Map> parameters = new HashMap<String, Map>();
    private Map<String, Map> gradients = new HashMap<String, Map>();
    private List<Double> learningRates = new ArrayList<Double>();
    private Map<Integer, LayerParams> layerParams = new LinkedHashMap<Integer, LayerParams>();

    public void addScore(float score) {
        if (this.scores.size() > 1000) {
            this.scores.remove(0);
        }
        this.scores.add(Float.valueOf(score));
    }

    public void addPerformanceBatches(float perf) {
        this.performanceBatches = perf;
    }

    public void addPerformanceSamples(float perf) {
        this.performanceSamples = perf;
    }

    public float getScore() {
        return this.score;
    }

    public String getTrainingTime() {
        return this.trainingTime;
    }

    public List<Float> getScores() {
        return this.scores;
    }

    public float getPerformanceBatches() {
        return this.performanceBatches;
    }

    public float getPerformanceSamples() {
        return this.performanceSamples;
    }

    public long getIterationTime() {
        return this.iterationTime;
    }

    public Map<String, Map> getParameters() {
        return this.parameters;
    }

    public Map<String, Map> getGradients() {
        return this.gradients;
    }

    public List<Double> getLearningRates() {
        return this.learningRates;
    }

    public Map<Integer, LayerParams> getLayerParams() {
        return this.layerParams;
    }

    public void setScore(float score) {
        this.score = score;
    }

    public void setTrainingTime(String trainingTime) {
        this.trainingTime = trainingTime;
    }

    public void setScores(List<Float> scores) {
        this.scores = scores;
    }

    public void setPerformanceBatches(float performanceBatches) {
        this.performanceBatches = performanceBatches;
    }

    public void setPerformanceSamples(float performanceSamples) {
        this.performanceSamples = performanceSamples;
    }

    public void setIterationTime(long iterationTime) {
        this.iterationTime = iterationTime;
    }

    public void setParameters(Map<String, Map> parameters) {
        this.parameters = parameters;
    }

    public void setGradients(Map<String, Map> gradients) {
        this.gradients = gradients;
    }

    public void setLearningRates(List<Double> learningRates) {
        this.learningRates = learningRates;
    }

    public void setLayerParams(Map<Integer, LayerParams> layerParams) {
        this.layerParams = layerParams;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ModelState)) {
            return false;
        }
        ModelState other = (ModelState)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Float.compare(this.getScore(), other.getScore()) != 0) {
            return false;
        }
        String this$trainingTime = this.getTrainingTime();
        String other$trainingTime = other.getTrainingTime();
        if (this$trainingTime == null ? other$trainingTime != null : !this$trainingTime.equals(other$trainingTime)) {
            return false;
        }
        List<Float> this$scores = this.getScores();
        List<Float> other$scores = other.getScores();
        if (this$scores == null ? other$scores != null : !((Object)this$scores).equals(other$scores)) {
            return false;
        }
        if (Float.compare(this.getPerformanceBatches(), other.getPerformanceBatches()) != 0) {
            return false;
        }
        if (Float.compare(this.getPerformanceSamples(), other.getPerformanceSamples()) != 0) {
            return false;
        }
        if (this.getIterationTime() != other.getIterationTime()) {
            return false;
        }
        Map<String, Map> this$parameters = this.getParameters();
        Map<String, Map> other$parameters = other.getParameters();
        if (this$parameters == null ? other$parameters != null : !((Object)this$parameters).equals(other$parameters)) {
            return false;
        }
        Map<String, Map> this$gradients = this.getGradients();
        Map<String, Map> other$gradients = other.getGradients();
        if (this$gradients == null ? other$gradients != null : !((Object)this$gradients).equals(other$gradients)) {
            return false;
        }
        List<Double> this$learningRates = this.getLearningRates();
        List<Double> other$learningRates = other.getLearningRates();
        if (this$learningRates == null ? other$learningRates != null : !((Object)this$learningRates).equals(other$learningRates)) {
            return false;
        }
        Map<Integer, LayerParams> this$layerParams = this.getLayerParams();
        Map<Integer, LayerParams> other$layerParams = other.getLayerParams();
        return !(this$layerParams == null ? other$layerParams != null : !((Object)this$layerParams).equals(other$layerParams));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ModelState;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Float.floatToIntBits(this.getScore());
        String $trainingTime = this.getTrainingTime();
        result = result * 59 + ($trainingTime == null ? 43 : $trainingTime.hashCode());
        List<Float> $scores = this.getScores();
        result = result * 59 + ($scores == null ? 43 : ((Object)$scores).hashCode());
        result = result * 59 + Float.floatToIntBits(this.getPerformanceBatches());
        result = result * 59 + Float.floatToIntBits(this.getPerformanceSamples());
        long $iterationTime = this.getIterationTime();
        result = result * 59 + (int)($iterationTime >>> 32 ^ $iterationTime);
        Map<String, Map> $parameters = this.getParameters();
        result = result * 59 + ($parameters == null ? 43 : ((Object)$parameters).hashCode());
        Map<String, Map> $gradients = this.getGradients();
        result = result * 59 + ($gradients == null ? 43 : ((Object)$gradients).hashCode());
        List<Double> $learningRates = this.getLearningRates();
        result = result * 59 + ($learningRates == null ? 43 : ((Object)$learningRates).hashCode());
        Map<Integer, LayerParams> $layerParams = this.getLayerParams();
        result = result * 59 + ($layerParams == null ? 43 : ((Object)$layerParams).hashCode());
        return result;
    }

    public String toString() {
        return "ModelState(score=" + this.getScore() + ", trainingTime=" + this.getTrainingTime() + ", scores=" + this.getScores() + ", performanceBatches=" + this.getPerformanceBatches() + ", performanceSamples=" + this.getPerformanceSamples() + ", iterationTime=" + this.getIterationTime() + ", parameters=" + this.getParameters() + ", gradients=" + this.getGradients() + ", learningRates=" + this.getLearningRates() + ", layerParams=" + this.getLayerParams() + ")";
    }
}

