/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.ui.components.table.style;

import java.awt.Color;
import java.util.Arrays;
import org.deeplearning4j.ui.api.LengthUnit;
import org.deeplearning4j.ui.api.Style;
import org.deeplearning4j.ui.api.Utils;
import org.nd4j.shade.jackson.annotation.JsonInclude;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class StyleTable
extends Style {
    private double[] columnWidths;
    private LengthUnit columnWidthUnit;
    private Integer borderWidthPx;
    private String headerColor;
    private String backgroundColor;
    private String whitespaceMode;

    private StyleTable(Builder builder) {
        super(builder);
        this.columnWidths = builder.columnWidths;
        this.columnWidthUnit = builder.columnWidthUnit;
        this.borderWidthPx = builder.borderWidthPx;
        this.headerColor = builder.headerColor;
        this.backgroundColor = builder.backgroundColor;
        this.whitespaceMode = builder.whitespaceMode;
    }

    private StyleTable() {
    }

    public double[] getColumnWidths() {
        return this.columnWidths;
    }

    public LengthUnit getColumnWidthUnit() {
        return this.columnWidthUnit;
    }

    public Integer getBorderWidthPx() {
        return this.borderWidthPx;
    }

    public String getHeaderColor() {
        return this.headerColor;
    }

    @Override
    public String getBackgroundColor() {
        return this.backgroundColor;
    }

    public String getWhitespaceMode() {
        return this.whitespaceMode;
    }

    public void setColumnWidths(double[] columnWidths) {
        this.columnWidths = columnWidths;
    }

    public void setColumnWidthUnit(LengthUnit columnWidthUnit) {
        this.columnWidthUnit = columnWidthUnit;
    }

    public void setBorderWidthPx(Integer borderWidthPx) {
        this.borderWidthPx = borderWidthPx;
    }

    public void setHeaderColor(String headerColor) {
        this.headerColor = headerColor;
    }

    @Override
    public void setBackgroundColor(String backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public void setWhitespaceMode(String whitespaceMode) {
        this.whitespaceMode = whitespaceMode;
    }

    @Override
    public String toString() {
        return "StyleTable(columnWidths=" + Arrays.toString(this.getColumnWidths()) + ", columnWidthUnit=" + (Object)((Object)this.getColumnWidthUnit()) + ", borderWidthPx=" + this.getBorderWidthPx() + ", headerColor=" + this.getHeaderColor() + ", backgroundColor=" + this.getBackgroundColor() + ", whitespaceMode=" + this.getWhitespaceMode() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StyleTable)) {
            return false;
        }
        StyleTable other = (StyleTable)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (!Arrays.equals(this.getColumnWidths(), other.getColumnWidths())) {
            return false;
        }
        LengthUnit this$columnWidthUnit = this.getColumnWidthUnit();
        LengthUnit other$columnWidthUnit = other.getColumnWidthUnit();
        if (this$columnWidthUnit == null ? other$columnWidthUnit != null : !((Object)((Object)this$columnWidthUnit)).equals((Object)other$columnWidthUnit)) {
            return false;
        }
        Integer this$borderWidthPx = this.getBorderWidthPx();
        Integer other$borderWidthPx = other.getBorderWidthPx();
        if (this$borderWidthPx == null ? other$borderWidthPx != null : !((Object)this$borderWidthPx).equals(other$borderWidthPx)) {
            return false;
        }
        String this$headerColor = this.getHeaderColor();
        String other$headerColor = other.getHeaderColor();
        if (this$headerColor == null ? other$headerColor != null : !this$headerColor.equals(other$headerColor)) {
            return false;
        }
        String this$backgroundColor = this.getBackgroundColor();
        String other$backgroundColor = other.getBackgroundColor();
        if (this$backgroundColor == null ? other$backgroundColor != null : !this$backgroundColor.equals(other$backgroundColor)) {
            return false;
        }
        String this$whitespaceMode = this.getWhitespaceMode();
        String other$whitespaceMode = other.getWhitespaceMode();
        return !(this$whitespaceMode == null ? other$whitespaceMode != null : !this$whitespaceMode.equals(other$whitespaceMode));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof StyleTable;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        result = result * 59 + Arrays.hashCode(this.getColumnWidths());
        LengthUnit $columnWidthUnit = this.getColumnWidthUnit();
        result = result * 59 + ($columnWidthUnit == null ? 43 : ((Object)((Object)$columnWidthUnit)).hashCode());
        Integer $borderWidthPx = this.getBorderWidthPx();
        result = result * 59 + ($borderWidthPx == null ? 43 : ((Object)$borderWidthPx).hashCode());
        String $headerColor = this.getHeaderColor();
        result = result * 59 + ($headerColor == null ? 43 : $headerColor.hashCode());
        String $backgroundColor = this.getBackgroundColor();
        result = result * 59 + ($backgroundColor == null ? 43 : $backgroundColor.hashCode());
        String $whitespaceMode = this.getWhitespaceMode();
        result = result * 59 + ($whitespaceMode == null ? 43 : $whitespaceMode.hashCode());
        return result;
    }

    public static class Builder
    extends Style.Builder<Builder> {
        private double[] columnWidths;
        private LengthUnit columnWidthUnit;
        private Integer borderWidthPx;
        private String headerColor;
        private String backgroundColor;
        private String whitespaceMode;

        public Builder columnWidths(LengthUnit unit, double ... widths) {
            this.columnWidthUnit = unit;
            this.columnWidths = widths;
            return this;
        }

        public Builder borderWidth(int borderWidthPx) {
            this.borderWidthPx = borderWidthPx;
            return this;
        }

        public Builder headerColor(Color color) {
            String hex = Utils.colorToHex(color);
            return this.headerColor(hex);
        }

        public Builder headerColor(String color) {
            if (!color.toLowerCase().matches("#[a-f0-9]{6}")) {
                throw new IllegalArgumentException("Invalid color: must be hex format. Got: " + color);
            }
            this.headerColor = color;
            return this;
        }

        @Override
        public Builder backgroundColor(Color color) {
            String hex = Utils.colorToHex(color);
            return this.backgroundColor(hex);
        }

        @Override
        public Builder backgroundColor(String color) {
            if (!color.toLowerCase().matches("#[a-f0-9]{6}")) {
                throw new IllegalArgumentException("Invalid color: must be hex format. Got: " + color);
            }
            this.backgroundColor = color;
            return this;
        }

        public Builder whitespaceMode(String whitespaceMode) {
            this.whitespaceMode = whitespaceMode;
            return this;
        }

        public StyleTable build() {
            return new StyleTable(this);
        }
    }
}

