/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.scaleout.statetracker.updatesaver;

import com.hazelcast.core.EntryEvent;
import com.hazelcast.core.EntryListener;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import com.hazelcast.core.MapEvent;
import java.io.File;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.deeplearning4j.scaleout.api.statetracker.UpdateSaver;
import org.deeplearning4j.scaleout.job.Job;
import org.deeplearning4j.util.SerializationUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalFileUpdateSaver
implements UpdateSaver {
    private Map<String, String> paths;
    private IMap<String, Job> updateableIMap;
    private String baseDir;
    public static final String UPDATE_SAVER = "updatesaver";
    private static final Logger log = LoggerFactory.getLogger(LocalFileUpdateSaver.class);

    public LocalFileUpdateSaver(String baseDir, HazelcastInstance instance) {
        this.baseDir = baseDir;
        File dir = new File(baseDir);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        this.paths = new ConcurrentHashMap<String, String>();
        if (instance != null) {
            this.updateableIMap = instance.getMap(UPDATE_SAVER);
            this.updateableIMap.addEntryListener((EntryListener)new EntryListener<String, Job>(){

                public void entryAdded(EntryEvent<String, Job> event) {
                    File saveFile;
                    String fileName = (String)event.getKey();
                    if (((String)event.getKey()).equals(".")) {
                        fileName = UUID.randomUUID().toString();
                    }
                    if ((saveFile = new File(LocalFileUpdateSaver.this.baseDir, fileName)).isDirectory()) {
                        saveFile = new File(LocalFileUpdateSaver.this.baseDir, UUID.randomUUID().toString());
                    }
                    SerializationUtils.saveObject((Object)event.getValue(), (File)saveFile);
                    LocalFileUpdateSaver.this.paths.put(event.getKey(), saveFile.getAbsolutePath());
                    LocalFileUpdateSaver.this.updateableIMap.remove(event.getKey());
                }

                public void entryRemoved(EntryEvent<String, Job> event) {
                }

                public void entryUpdated(EntryEvent<String, Job> event) {
                }

                public void entryEvicted(EntryEvent<String, Job> event) {
                }

                public void mapEvicted(MapEvent mapEvent) {
                }

                public void mapCleared(MapEvent mapEvent) {
                }
            }, true);
        }
    }

    public LocalFileUpdateSaver(String baseDir) {
        this(baseDir, null);
    }

    public LocalFileUpdateSaver() {
        this(System.getProperty("java.io.tmpdir"));
    }

    public synchronized Job load(String id) throws Exception {
        String path = this.paths.remove(id);
        if (path == null) {
            log.warn("Tried loading work from id " + id + " but path was null");
            return null;
        }
        File load = new File(path);
        Job u = (Job)SerializationUtils.readObject((File)load);
        load.deleteOnExit();
        return u;
    }

    public void cleanup() {
        for (String s : this.paths.values()) {
            new File(s).delete();
        }
    }

    public void save(String id, Job save) throws Exception {
        if (save == null) {
            throw new IllegalArgumentException("Saving null network not allowed");
        }
        if (this.updateableIMap != null) {
            this.updateableIMap.put((Object)id, (Object)save);
        } else {
            File saveFile = new File(this.baseDir, id);
            SerializationUtils.saveObject((Object)save, (File)saveFile);
            boolean loadedProperly = false;
            while (!loadedProperly) {
                try {
                    SerializationUtils.readObject((File)saveFile);
                }
                catch (Exception e) {
                    // empty catch block
                }
                loadedProperly = true;
            }
            this.paths.put(id, saveFile.getAbsolutePath());
        }
    }
}

