/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.scaleout.actor.core.actor;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.UntypedActor;
import akka.cluster.Cluster;
import akka.contrib.pattern.DistributedPubSubExtension;
import akka.contrib.pattern.DistributedPubSubMediator;
import akka.event.Logging;
import akka.event.LoggingAdapter;
import java.io.File;
import org.deeplearning4j.scaleout.actor.core.DefaultModelSaver;
import org.deeplearning4j.scaleout.actor.core.ModelSaver;
import org.deeplearning4j.scaleout.actor.core.actor.MasterActor;
import org.deeplearning4j.scaleout.api.statetracker.StateTracker;
import org.deeplearning4j.scaleout.job.Job;
import org.deeplearning4j.scaleout.messages.MoreWorkMessage;

public class ModelSavingActor
extends UntypedActor {
    public static final String SAVE = "save";
    private String pathToSave;
    private ActorRef mediator = DistributedPubSubExtension.get((ActorSystem)this.getContext().system()).mediator();
    private LoggingAdapter log = Logging.getLogger((ActorSystem)this.getContext().system(), (Object)((Object)this));
    private Cluster cluster = Cluster.get((ActorSystem)this.context().system());
    private ModelSaver modelSaver = new DefaultModelSaver();
    private StateTracker stateTracker;

    public ModelSavingActor(String pathToSave, StateTracker stateTracker) {
        this.mediator.tell((Object)new DistributedPubSubMediator.Subscribe(SAVE, this.getSelf()), this.getSelf());
        this.mediator.tell((Object)new DistributedPubSubMediator.Subscribe(MasterActor.SHUTDOWN, this.getSelf()), this.getSelf());
        this.pathToSave = pathToSave;
        this.modelSaver = new DefaultModelSaver(new File(pathToSave));
        this.stateTracker = stateTracker;
    }

    public ModelSavingActor(ModelSaver saver, StateTracker stateTracker) {
        this.mediator.tell((Object)new DistributedPubSubMediator.Subscribe(SAVE, this.getSelf()), this.getSelf());
        this.mediator.tell((Object)new DistributedPubSubMediator.Subscribe(MasterActor.SHUTDOWN, this.getSelf()), this.getSelf());
        this.modelSaver = saver;
        this.stateTracker = stateTracker;
    }

    public void postStop() throws Exception {
        super.postStop();
        this.log.info("Post stop on model saver");
        this.cluster.unsubscribe(this.getSelf());
    }

    public void preStart() throws Exception {
        super.preStart();
        this.log.info("Pre start on model saver");
    }

    public void onReceive(Object message) throws Exception {
        if (message instanceof MoreWorkMessage) {
            if (this.stateTracker.getCurrent() != null) {
                Job j = (Job)this.stateTracker.getCurrent();
                this.modelSaver.save(j.getResult());
            }
        } else if (message instanceof DistributedPubSubMediator.UnsubscribeAck || message instanceof DistributedPubSubMediator.SubscribeAck) {
            this.mediator.tell((Object)new DistributedPubSubMediator.Publish("topics", message), this.getSelf());
            this.log.info("Sending sub/unsub over");
        } else {
            this.unhandled(message);
        }
    }
}

