/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.conf.layers;

import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.deeplearning4j.nn.api.Layer;
import org.deeplearning4j.nn.api.ParamInitializer;
import org.deeplearning4j.nn.conf.ConvolutionMode;
import org.deeplearning4j.nn.conf.InputPreProcessor;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.conf.inputs.InputType;
import org.deeplearning4j.nn.conf.layers.InputTypeUtil;
import org.deeplearning4j.nn.conf.layers.Layer;
import org.deeplearning4j.nn.conf.layers.NoParamLayer;
import org.deeplearning4j.nn.conf.memory.LayerMemoryReport;
import org.deeplearning4j.nn.conf.memory.MemoryReport;
import org.deeplearning4j.nn.params.EmptyParamInitializer;
import org.deeplearning4j.optimize.api.TrainingListener;
import org.deeplearning4j.util.ConvolutionUtils;
import org.deeplearning4j.util.ValidationUtils;
import org.nd4j.base.Preconditions;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;

public class SubsamplingLayer
extends NoParamLayer {
    protected ConvolutionMode convolutionMode = ConvolutionMode.Truncate;
    protected org.deeplearning4j.nn.conf.layers.PoolingType poolingType;
    protected int[] kernelSize;
    protected int[] stride;
    protected int[] padding;
    protected int[] dilation = new int[]{1, 1};
    protected int pnorm;
    protected double eps;
    protected boolean cudnnAllowFallback = true;
    protected boolean avgPoolIncludePadInDivisor = true;

    protected SubsamplingLayer(BaseSubsamplingBuilder builder) {
        super(builder);
        this.poolingType = builder.poolingType;
        if (builder.kernelSize.length != 2) {
            throw new IllegalArgumentException("Kernel size of should be rows x columns (a 2d array)");
        }
        this.kernelSize = builder.kernelSize;
        if (builder.stride.length != 2) {
            throw new IllegalArgumentException("Invalid stride, must be length 2");
        }
        this.stride = builder.stride;
        this.padding = builder.padding;
        this.convolutionMode = builder.convolutionMode;
        if (builder instanceof Builder) {
            this.dilation = ((Builder)builder).dilation;
        }
        this.pnorm = builder.pnorm;
        this.eps = builder.eps;
        this.cudnnAllowFallback = builder.cudnnAllowFallback;
        this.avgPoolIncludePadInDivisor = builder.avgPoolIncludePadInDivisor;
    }

    @Override
    public SubsamplingLayer clone() {
        SubsamplingLayer clone = (SubsamplingLayer)super.clone();
        if (clone.kernelSize != null) {
            clone.kernelSize = (int[])clone.kernelSize.clone();
        }
        if (clone.stride != null) {
            clone.stride = (int[])clone.stride.clone();
        }
        if (clone.padding != null) {
            clone.padding = (int[])clone.padding.clone();
        }
        if (clone.dilation != null) {
            clone.dilation = (int[])clone.dilation.clone();
        }
        return clone;
    }

    @Override
    public Layer instantiate(NeuralNetConfiguration conf, Collection<TrainingListener> trainingListeners, int layerIndex, INDArray layerParamsView, boolean initializeParams, DataType networkDataType) {
        org.deeplearning4j.nn.layers.convolution.subsampling.SubsamplingLayer ret = new org.deeplearning4j.nn.layers.convolution.subsampling.SubsamplingLayer(conf, networkDataType);
        ret.setListeners(trainingListeners);
        ret.setIndex(layerIndex);
        ret.setParamsViewArray(layerParamsView);
        Map<String, INDArray> paramTable = this.initializer().init(conf, layerParamsView, initializeParams);
        ret.setParamTable(paramTable);
        ret.setConf(conf);
        return ret;
    }

    @Override
    public ParamInitializer initializer() {
        return EmptyParamInitializer.getInstance();
    }

    @Override
    public InputType getOutputType(int layerIndex, InputType inputType) {
        if (inputType == null || inputType.getType() != InputType.Type.CNN) {
            throw new IllegalStateException("Invalid input for Subsampling layer (layer name=\"" + this.getLayerName() + "\"): Expected CNN input, got " + inputType);
        }
        return InputTypeUtil.getOutputTypeCnnLayers(inputType, this.kernelSize, this.stride, this.padding, this.dilation, this.convolutionMode, ((InputType.InputTypeConvolutional)inputType).getChannels(), layerIndex, this.getLayerName(), SubsamplingLayer.class);
    }

    @Override
    public void setNIn(InputType inputType, boolean override) {
    }

    @Override
    public InputPreProcessor getPreProcessorForInputType(InputType inputType) {
        if (inputType == null) {
            throw new IllegalStateException("Invalid input for Subsampling layer (layer name=\"" + this.getLayerName() + "\"): input is null");
        }
        return InputTypeUtil.getPreProcessorForInputTypeCnnLayers(inputType, this.getLayerName());
    }

    @Override
    public boolean isPretrainParam(String paramName) {
        throw new UnsupportedOperationException("SubsamplingLayer does not contain parameters");
    }

    @Override
    public LayerMemoryReport getMemoryReport(InputType inputType) {
        long im2colSizePerEx;
        InputType.InputTypeConvolutional c = (InputType.InputTypeConvolutional)inputType;
        InputType.InputTypeConvolutional outputType = (InputType.InputTypeConvolutional)this.getOutputType(-1, inputType);
        long actElementsPerEx = outputType.arrayElementsPerExample();
        long trainingWorkingSizePerEx = im2colSizePerEx = c.getChannels() * outputType.getHeight() * outputType.getWidth() * (long)this.kernelSize[0] * (long)this.kernelSize[1];
        if (this.getIDropout() != null) {
            trainingWorkingSizePerEx += inputType.arrayElementsPerExample();
        }
        return new LayerMemoryReport.Builder(this.layerName, SubsamplingLayer.class, inputType, outputType).standardMemory(0L, 0L).workingMemory(0L, im2colSizePerEx, 0L, trainingWorkingSizePerEx).cacheMemory(MemoryReport.CACHE_MODE_ALL_ZEROS, MemoryReport.CACHE_MODE_ALL_ZEROS).build();
    }

    public int getPnorm() {
        return this.pnorm;
    }

    public double getEps() {
        return this.eps;
    }

    public ConvolutionMode getConvolutionMode() {
        return this.convolutionMode;
    }

    public org.deeplearning4j.nn.conf.layers.PoolingType getPoolingType() {
        return this.poolingType;
    }

    public int[] getKernelSize() {
        return this.kernelSize;
    }

    public int[] getStride() {
        return this.stride;
    }

    public int[] getPadding() {
        return this.padding;
    }

    public int[] getDilation() {
        return this.dilation;
    }

    public boolean isCudnnAllowFallback() {
        return this.cudnnAllowFallback;
    }

    public boolean isAvgPoolIncludePadInDivisor() {
        return this.avgPoolIncludePadInDivisor;
    }

    public void setConvolutionMode(ConvolutionMode convolutionMode) {
        this.convolutionMode = convolutionMode;
    }

    public void setPoolingType(org.deeplearning4j.nn.conf.layers.PoolingType poolingType) {
        this.poolingType = poolingType;
    }

    public void setKernelSize(int[] kernelSize) {
        this.kernelSize = kernelSize;
    }

    public void setStride(int[] stride) {
        this.stride = stride;
    }

    public void setPadding(int[] padding) {
        this.padding = padding;
    }

    public void setDilation(int[] dilation) {
        this.dilation = dilation;
    }

    public void setPnorm(int pnorm) {
        this.pnorm = pnorm;
    }

    public void setEps(double eps) {
        this.eps = eps;
    }

    public void setCudnnAllowFallback(boolean cudnnAllowFallback) {
        this.cudnnAllowFallback = cudnnAllowFallback;
    }

    public void setAvgPoolIncludePadInDivisor(boolean avgPoolIncludePadInDivisor) {
        this.avgPoolIncludePadInDivisor = avgPoolIncludePadInDivisor;
    }

    public SubsamplingLayer() {
    }

    @Override
    public String toString() {
        return "SubsamplingLayer(super=" + super.toString() + ", convolutionMode=" + (Object)((Object)this.getConvolutionMode()) + ", poolingType=" + (Object)((Object)this.getPoolingType()) + ", kernelSize=" + Arrays.toString(this.getKernelSize()) + ", stride=" + Arrays.toString(this.getStride()) + ", padding=" + Arrays.toString(this.getPadding()) + ", dilation=" + Arrays.toString(this.getDilation()) + ", pnorm=" + this.getPnorm() + ", eps=" + this.getEps() + ", cudnnAllowFallback=" + this.isCudnnAllowFallback() + ", avgPoolIncludePadInDivisor=" + this.isAvgPoolIncludePadInDivisor() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SubsamplingLayer)) {
            return false;
        }
        SubsamplingLayer other = (SubsamplingLayer)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ConvolutionMode this$convolutionMode = this.getConvolutionMode();
        ConvolutionMode other$convolutionMode = other.getConvolutionMode();
        if (this$convolutionMode == null ? other$convolutionMode != null : !((Object)((Object)this$convolutionMode)).equals((Object)other$convolutionMode)) {
            return false;
        }
        org.deeplearning4j.nn.conf.layers.PoolingType this$poolingType = this.getPoolingType();
        org.deeplearning4j.nn.conf.layers.PoolingType other$poolingType = other.getPoolingType();
        if (this$poolingType == null ? other$poolingType != null : !((Object)((Object)this$poolingType)).equals((Object)other$poolingType)) {
            return false;
        }
        if (!Arrays.equals(this.getKernelSize(), other.getKernelSize())) {
            return false;
        }
        if (!Arrays.equals(this.getStride(), other.getStride())) {
            return false;
        }
        if (!Arrays.equals(this.getPadding(), other.getPadding())) {
            return false;
        }
        if (!Arrays.equals(this.getDilation(), other.getDilation())) {
            return false;
        }
        if (this.getPnorm() != other.getPnorm()) {
            return false;
        }
        if (Double.compare(this.getEps(), other.getEps()) != 0) {
            return false;
        }
        if (this.isCudnnAllowFallback() != other.isCudnnAllowFallback()) {
            return false;
        }
        return this.isAvgPoolIncludePadInDivisor() == other.isAvgPoolIncludePadInDivisor();
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof SubsamplingLayer;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        ConvolutionMode $convolutionMode = this.getConvolutionMode();
        result = result * 59 + ($convolutionMode == null ? 43 : ((Object)((Object)$convolutionMode)).hashCode());
        org.deeplearning4j.nn.conf.layers.PoolingType $poolingType = this.getPoolingType();
        result = result * 59 + ($poolingType == null ? 43 : ((Object)((Object)$poolingType)).hashCode());
        result = result * 59 + Arrays.hashCode(this.getKernelSize());
        result = result * 59 + Arrays.hashCode(this.getStride());
        result = result * 59 + Arrays.hashCode(this.getPadding());
        result = result * 59 + Arrays.hashCode(this.getDilation());
        result = result * 59 + this.getPnorm();
        long $eps = Double.doubleToLongBits(this.getEps());
        result = result * 59 + (int)($eps >>> 32 ^ $eps);
        result = result * 59 + (this.isCudnnAllowFallback() ? 79 : 97);
        result = result * 59 + (this.isAvgPoolIncludePadInDivisor() ? 79 : 97);
        return result;
    }

    protected static abstract class BaseSubsamplingBuilder<T extends BaseSubsamplingBuilder<T>>
    extends Layer.Builder<T> {
        protected org.deeplearning4j.nn.conf.layers.PoolingType poolingType = org.deeplearning4j.nn.conf.layers.PoolingType.MAX;
        protected int[] kernelSize = new int[]{1, 1};
        protected int[] stride = new int[]{2, 2};
        protected int[] padding = new int[]{0, 0};
        protected ConvolutionMode convolutionMode = null;
        protected int pnorm;
        protected double eps = 1.0E-8;
        protected boolean cudnnAllowFallback = true;
        protected boolean avgPoolIncludePadInDivisor = false;

        protected BaseSubsamplingBuilder(PoolingType poolingType, int[] kernelSize, int[] stride) {
            this.setPoolingType(poolingType.toPoolingType());
            this.setKernelSize(kernelSize);
            this.setStride(stride);
        }

        protected BaseSubsamplingBuilder(PoolingType poolingType, int[] kernelSize) {
            this.setPoolingType(poolingType.toPoolingType());
            this.setKernelSize(kernelSize);
        }

        protected BaseSubsamplingBuilder(PoolingType poolingType, int[] kernelSize, int[] stride, int[] padding) {
            this.setPoolingType(poolingType.toPoolingType());
            this.setKernelSize(kernelSize);
            this.setStride(stride);
            this.setPadding(padding);
        }

        protected BaseSubsamplingBuilder(org.deeplearning4j.nn.conf.layers.PoolingType poolingType, int[] kernelSize) {
            this.setPoolingType(poolingType);
            this.setKernelSize(kernelSize);
        }

        protected BaseSubsamplingBuilder(org.deeplearning4j.nn.conf.layers.PoolingType poolingType, int[] kernelSize, int[] stride, int[] padding) {
            this.setPoolingType(poolingType);
            this.setKernelSize(kernelSize);
            this.setStride(stride);
            this.setPadding(padding);
        }

        protected BaseSubsamplingBuilder(int[] kernelSize, int[] stride, int[] padding) {
            this.setKernelSize(kernelSize);
            this.setStride(stride);
            this.setPadding(padding);
        }

        protected BaseSubsamplingBuilder(int[] kernelSize, int[] stride) {
            this.setKernelSize(kernelSize);
            this.setStride(stride);
        }

        protected BaseSubsamplingBuilder(int ... kernelSize) {
            this.setKernelSize(kernelSize);
        }

        protected BaseSubsamplingBuilder(PoolingType poolingType) {
            this.setPoolingType(poolingType.toPoolingType());
        }

        protected BaseSubsamplingBuilder(org.deeplearning4j.nn.conf.layers.PoolingType poolingType) {
            this.setPoolingType(poolingType);
        }

        public void setPnorm(int pnorm) {
            ValidationUtils.validateNonNegative(pnorm, "pnorm");
            this.pnorm = pnorm;
        }

        public void setEps(double eps) {
            ValidationUtils.validateNonNegative(eps, "eps");
            this.eps = eps;
        }

        protected abstract boolean allowCausal();

        public void setConvolutionMode(ConvolutionMode convolutionMode) {
            Preconditions.checkState((this.allowCausal() || convolutionMode != ConvolutionMode.Causal ? 1 : 0) != 0, (String)"Causal convolution mode can only be used with 1D convolutional neural network layers");
            this.convolutionMode = convolutionMode;
        }

        public T convolutionMode(ConvolutionMode convolutionMode) {
            this.setConvolutionMode(convolutionMode);
            return (T)this;
        }

        public T poolingType(PoolingType poolingType) {
            this.setPoolingType(poolingType.toPoolingType());
            return (T)this;
        }

        public T poolingType(org.deeplearning4j.nn.conf.layers.PoolingType poolingType) {
            this.setPoolingType(poolingType);
            return (T)this;
        }

        public T pnorm(int pnorm) {
            this.setPnorm(pnorm);
            return (T)this;
        }

        public T eps(double eps) {
            this.setEps(eps);
            return (T)this;
        }

        @Deprecated
        public T cudnnAllowFallback(boolean allowFallback) {
            this.cudnnAllowFallback = allowFallback;
            return (T)this;
        }

        public T helperAllowFallback(boolean allowFallback) {
            this.cudnnAllowFallback = allowFallback;
            return (T)this;
        }

        public T avgPoolIncludePadInDivisor(boolean avgPoolIncludePadInDivisor) {
            this.avgPoolIncludePadInDivisor = avgPoolIncludePadInDivisor;
            return (T)this;
        }

        public BaseSubsamplingBuilder() {
        }

        public org.deeplearning4j.nn.conf.layers.PoolingType getPoolingType() {
            return this.poolingType;
        }

        public int[] getKernelSize() {
            return this.kernelSize;
        }

        public int[] getStride() {
            return this.stride;
        }

        public int[] getPadding() {
            return this.padding;
        }

        public ConvolutionMode getConvolutionMode() {
            return this.convolutionMode;
        }

        public int getPnorm() {
            return this.pnorm;
        }

        public double getEps() {
            return this.eps;
        }

        public boolean isCudnnAllowFallback() {
            return this.cudnnAllowFallback;
        }

        public boolean isAvgPoolIncludePadInDivisor() {
            return this.avgPoolIncludePadInDivisor;
        }

        public void setPoolingType(org.deeplearning4j.nn.conf.layers.PoolingType poolingType) {
            this.poolingType = poolingType;
        }

        public void setKernelSize(int[] kernelSize) {
            this.kernelSize = kernelSize;
        }

        public void setStride(int[] stride) {
            this.stride = stride;
        }

        public void setPadding(int[] padding) {
            this.padding = padding;
        }

        public void setCudnnAllowFallback(boolean cudnnAllowFallback) {
            this.cudnnAllowFallback = cudnnAllowFallback;
        }

        public void setAvgPoolIncludePadInDivisor(boolean avgPoolIncludePadInDivisor) {
            this.avgPoolIncludePadInDivisor = avgPoolIncludePadInDivisor;
        }
    }

    public static class Builder
    extends BaseSubsamplingBuilder<Builder> {
        private int[] dilation = new int[]{1, 1};

        public Builder(PoolingType poolingType, int[] kernelSize, int[] stride) {
            super(poolingType, kernelSize, stride);
        }

        public Builder(PoolingType poolingType, int[] kernelSize) {
            super(poolingType, kernelSize);
        }

        public Builder(PoolingType poolingType, int[] kernelSize, int[] stride, int[] padding) {
            super(poolingType, kernelSize, stride, padding);
        }

        public Builder(org.deeplearning4j.nn.conf.layers.PoolingType poolingType, int[] kernelSize) {
            super(poolingType, kernelSize);
        }

        public Builder(org.deeplearning4j.nn.conf.layers.PoolingType poolingType, int[] kernelSize, int[] stride, int[] padding) {
            super(poolingType, kernelSize, stride, padding);
        }

        public Builder(int[] kernelSize, int[] stride, int[] padding) {
            super(kernelSize, stride, padding);
        }

        public Builder(int[] kernelSize, int[] stride) {
            super(kernelSize, stride);
        }

        public Builder(int ... kernelSize) {
            super(kernelSize);
        }

        public Builder(PoolingType poolingType) {
            super(poolingType);
        }

        public Builder(org.deeplearning4j.nn.conf.layers.PoolingType poolingType) {
            super(poolingType);
        }

        @Override
        protected boolean allowCausal() {
            return false;
        }

        public Builder kernelSize(int ... kernelSize) {
            this.setKernelSize(kernelSize);
            return this;
        }

        public Builder stride(int ... stride) {
            this.setStride(stride);
            return this;
        }

        public Builder padding(int ... padding) {
            this.setPadding(padding);
            return this;
        }

        public Builder dilation(int ... dilation) {
            this.setDilation(dilation);
            return this;
        }

        @Override
        public SubsamplingLayer build() {
            if (this.poolingType == org.deeplearning4j.nn.conf.layers.PoolingType.PNORM && this.pnorm <= 0) {
                throw new IllegalStateException("Incorrect Subsampling config: p-norm must be set when using PoolingType.PNORM");
            }
            ConvolutionUtils.validateConvolutionModePadding(this.convolutionMode, this.padding);
            ConvolutionUtils.validateCnnKernelStridePadding(this.kernelSize, this.stride, this.padding);
            return new SubsamplingLayer(this);
        }

        @Override
        public void setKernelSize(int ... kernelSize) {
            this.kernelSize = ValidationUtils.validate2NonNegative(kernelSize, false, "kernelSize");
        }

        @Override
        public void setStride(int ... stride) {
            this.stride = ValidationUtils.validate2NonNegative(stride, false, "stride");
        }

        @Override
        public void setPadding(int ... padding) {
            this.padding = ValidationUtils.validate2NonNegative(padding, false, "padding");
        }

        public void setDilation(int[] dilation) {
            this.dilation = ValidationUtils.validate2NonNegative(dilation, false, "dilation");
        }

        public Builder() {
        }

        public int[] getDilation() {
            return this.dilation;
        }
    }

    public static enum PoolingType {
        MAX,
        AVG,
        SUM,
        PNORM;


        public org.deeplearning4j.nn.conf.layers.PoolingType toPoolingType() {
            switch (this) {
                case MAX: {
                    return org.deeplearning4j.nn.conf.layers.PoolingType.MAX;
                }
                case AVG: {
                    return org.deeplearning4j.nn.conf.layers.PoolingType.AVG;
                }
                case SUM: {
                    return org.deeplearning4j.nn.conf.layers.PoolingType.SUM;
                }
                case PNORM: {
                    return org.deeplearning4j.nn.conf.layers.PoolingType.PNORM;
                }
            }
            throw new UnsupportedOperationException("Unknown/not supported pooling type: " + (Object)((Object)this));
        }
    }
}

