/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.optimize.solvers.accumulation.encoding.threshold;

import org.deeplearning4j.optimize.solvers.accumulation.encoding.ThresholdAlgorithm;
import org.deeplearning4j.optimize.solvers.accumulation.encoding.ThresholdAlgorithmReducer;
import org.nd4j.base.Preconditions;
import org.nd4j.linalg.api.ndarray.INDArray;

public class FixedThresholdAlgorithm
implements ThresholdAlgorithm {
    private final double threshold;

    @Override
    public double calculateThreshold(int iteration, int epoch, Double lastThreshold, Boolean lastWasDense, Double lastSparsityRatio, INDArray updatesPlusResidual) {
        return this.threshold;
    }

    @Override
    public ThresholdAlgorithmReducer newReducer() {
        return new FixedAlgorithmThresholdReducer();
    }

    @Override
    public FixedThresholdAlgorithm clone() {
        return new FixedThresholdAlgorithm(this.threshold);
    }

    public FixedThresholdAlgorithm(double threshold) {
        this.threshold = threshold;
    }

    public double getThreshold() {
        return this.threshold;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FixedThresholdAlgorithm)) {
            return false;
        }
        FixedThresholdAlgorithm other = (FixedThresholdAlgorithm)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return Double.compare(this.getThreshold(), other.getThreshold()) == 0;
    }

    protected boolean canEqual(Object other) {
        return other instanceof FixedThresholdAlgorithm;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $threshold = Double.doubleToLongBits(this.getThreshold());
        result = result * 59 + (int)($threshold >>> 32 ^ $threshold);
        return result;
    }

    public String toString() {
        return "FixedThresholdAlgorithm(threshold=" + this.getThreshold() + ")";
    }

    public static class FixedAlgorithmThresholdReducer
    implements ThresholdAlgorithmReducer {
        private FixedThresholdAlgorithm instance;

        @Override
        public void add(ThresholdAlgorithm instance) {
            Preconditions.checkState((boolean)(instance instanceof FixedThresholdAlgorithm), (String)"Invalid threshold: cannot be reduced using this class, %s", (Object)instance.getClass().getSimpleName());
            this.instance = (FixedThresholdAlgorithm)instance;
        }

        @Override
        public ThresholdAlgorithmReducer merge(ThresholdAlgorithmReducer other) {
            if (this.instance != null || other == null) {
                return this;
            }
            this.instance = ((FixedAlgorithmThresholdReducer)other).instance;
            return this;
        }

        @Override
        public ThresholdAlgorithm getFinalResult() {
            return this.instance;
        }
    }
}

