/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.layers.wrapper;

import java.util.Collection;
import java.util.Map;
import lombok.NonNull;
import org.deeplearning4j.nn.api.Layer;
import org.deeplearning4j.nn.api.MaskState;
import org.deeplearning4j.nn.api.TrainingConfig;
import org.deeplearning4j.nn.conf.CacheMode;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.gradient.Gradient;
import org.deeplearning4j.nn.layers.LayerHelper;
import org.deeplearning4j.nn.workspace.LayerWorkspaceMgr;
import org.deeplearning4j.optimize.api.ConvexOptimizer;
import org.deeplearning4j.optimize.api.TrainingListener;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.primitives.Pair;

public abstract class BaseWrapperLayer
implements Layer {
    protected Layer underlying;

    public BaseWrapperLayer(@NonNull Layer underlying) {
        if (underlying == null) {
            throw new NullPointerException("underlying is marked @NonNull but is null");
        }
        this.underlying = underlying;
    }

    @Override
    public void setCacheMode(CacheMode mode) {
        this.underlying.setCacheMode(mode);
    }

    @Override
    public double calcRegularizationScore(boolean backpropParamsOnly) {
        return this.underlying.calcRegularizationScore(backpropParamsOnly);
    }

    @Override
    public Layer.Type type() {
        return this.underlying.type();
    }

    @Override
    public Pair<Gradient, INDArray> backpropGradient(INDArray epsilon, LayerWorkspaceMgr workspaceMgr) {
        return this.underlying.backpropGradient(epsilon, workspaceMgr);
    }

    @Override
    public INDArray activate(boolean training, LayerWorkspaceMgr workspaceMgr) {
        return this.underlying.activate(training, workspaceMgr);
    }

    @Override
    public INDArray activate(INDArray input, boolean training, LayerWorkspaceMgr workspaceMgr) {
        return this.underlying.activate(input, training, workspaceMgr);
    }

    @Override
    public Collection<TrainingListener> getListeners() {
        return this.underlying.getListeners();
    }

    @Override
    public void setListeners(TrainingListener ... listeners) {
        this.underlying.setListeners(listeners);
    }

    @Override
    public void addListeners(TrainingListener ... listener) {
        this.underlying.addListeners(listener);
    }

    @Override
    public void fit() {
        this.underlying.fit();
    }

    @Override
    public void update(Gradient gradient) {
        this.underlying.update(gradient);
    }

    @Override
    public void update(INDArray gradient, String paramType) {
        this.underlying.update(gradient, paramType);
    }

    @Override
    public double score() {
        return this.underlying.score();
    }

    @Override
    public void computeGradientAndScore(LayerWorkspaceMgr workspaceMgr) {
        this.underlying.computeGradientAndScore(workspaceMgr);
    }

    @Override
    public INDArray params() {
        return this.underlying.params();
    }

    @Override
    public long numParams() {
        return this.underlying.numParams();
    }

    @Override
    public long numParams(boolean backwards) {
        return this.underlying.numParams();
    }

    @Override
    public void setParams(INDArray params) {
        this.underlying.setParams(params);
    }

    @Override
    public void setParamsViewArray(INDArray params) {
        this.underlying.setParamsViewArray(params);
    }

    @Override
    public INDArray getGradientsViewArray() {
        return this.underlying.getGradientsViewArray();
    }

    @Override
    public void setBackpropGradientsViewArray(INDArray gradients) {
        this.underlying.setBackpropGradientsViewArray(gradients);
    }

    @Override
    public void fit(INDArray data, LayerWorkspaceMgr workspaceMgr) {
        this.underlying.fit(data, workspaceMgr);
    }

    @Override
    public Gradient gradient() {
        return this.underlying.gradient();
    }

    @Override
    public Pair<Gradient, Double> gradientAndScore() {
        return this.underlying.gradientAndScore();
    }

    @Override
    public int batchSize() {
        return this.underlying.batchSize();
    }

    @Override
    public NeuralNetConfiguration conf() {
        return this.underlying.conf();
    }

    @Override
    public void setConf(NeuralNetConfiguration conf) {
        this.underlying.setConf(conf);
    }

    @Override
    public INDArray input() {
        return this.underlying.input();
    }

    @Override
    public ConvexOptimizer getOptimizer() {
        return this.underlying.getOptimizer();
    }

    @Override
    public INDArray getParam(String param) {
        return this.underlying.getParam(param);
    }

    @Override
    public Map<String, INDArray> paramTable() {
        return this.underlying.paramTable();
    }

    @Override
    public Map<String, INDArray> paramTable(boolean backpropParamsOnly) {
        return this.underlying.paramTable(backpropParamsOnly);
    }

    @Override
    public void setParamTable(Map<String, INDArray> paramTable) {
        this.underlying.setParamTable(paramTable);
    }

    @Override
    public void setParam(String key, INDArray val) {
        this.underlying.setParam(key, val);
    }

    @Override
    public void clear() {
        this.underlying.clear();
    }

    @Override
    public void applyConstraints(int iteration, int epoch) {
        this.underlying.applyConstraints(iteration, epoch);
    }

    @Override
    public void init() {
        this.underlying.init();
    }

    @Override
    public void setListeners(Collection<TrainingListener> listeners) {
        this.underlying.setListeners(listeners);
    }

    @Override
    public void setIndex(int index) {
        this.underlying.setIndex(index);
    }

    @Override
    public int getIndex() {
        return this.underlying.getIndex();
    }

    @Override
    public int getIterationCount() {
        return this.underlying.getIterationCount();
    }

    @Override
    public int getEpochCount() {
        return this.underlying.getEpochCount();
    }

    @Override
    public void setIterationCount(int iterationCount) {
        this.underlying.setIterationCount(iterationCount);
    }

    @Override
    public void setEpochCount(int epochCount) {
        this.underlying.setEpochCount(epochCount);
    }

    @Override
    public void setInput(INDArray input, LayerWorkspaceMgr workspaceMgr) {
        this.underlying.setInput(input, workspaceMgr);
    }

    @Override
    public void setInputMiniBatchSize(int size) {
        this.underlying.setInputMiniBatchSize(size);
    }

    @Override
    public int getInputMiniBatchSize() {
        return this.underlying.getInputMiniBatchSize();
    }

    @Override
    public void setMaskArray(INDArray maskArray) {
        this.underlying.setMaskArray(maskArray);
    }

    @Override
    public INDArray getMaskArray() {
        return this.underlying.getMaskArray();
    }

    @Override
    public boolean isPretrainLayer() {
        return this.underlying.isPretrainLayer();
    }

    @Override
    public void clearNoiseWeightParams() {
        this.underlying.clearNoiseWeightParams();
    }

    @Override
    public Pair<INDArray, MaskState> feedForwardMaskArray(INDArray maskArray, MaskState currentMaskState, int minibatchSize) {
        return this.underlying.feedForwardMaskArray(maskArray, currentMaskState, minibatchSize);
    }

    @Override
    public void allowInputModification(boolean allow) {
        this.underlying.allowInputModification(allow);
    }

    @Override
    public LayerHelper getHelper() {
        return this.underlying.getHelper();
    }

    @Override
    public TrainingConfig getConfig() {
        return this.underlying.getConfig();
    }

    @Override
    public boolean updaterDivideByMinibatch(String paramName) {
        return this.underlying.updaterDivideByMinibatch(paramName);
    }

    public Layer getUnderlying() {
        return this.underlying;
    }

    public void setUnderlying(Layer underlying) {
        this.underlying = underlying;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BaseWrapperLayer)) {
            return false;
        }
        BaseWrapperLayer other = (BaseWrapperLayer)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Layer this$underlying = this.getUnderlying();
        Layer other$underlying = other.getUnderlying();
        return !(this$underlying == null ? other$underlying != null : !this$underlying.equals(other$underlying));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BaseWrapperLayer;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Layer $underlying = this.getUnderlying();
        result = result * 59 + ($underlying == null ? 43 : $underlying.hashCode());
        return result;
    }

    public String toString() {
        return "BaseWrapperLayer(underlying=" + this.getUnderlying() + ")";
    }
}

