/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.layers.mkldnn;

import java.util.Collections;
import java.util.Map;
import org.deeplearning4j.nn.conf.ConvolutionMode;
import org.deeplearning4j.nn.conf.layers.ConvolutionLayer;
import org.deeplearning4j.nn.gradient.DefaultGradient;
import org.deeplearning4j.nn.gradient.Gradient;
import org.deeplearning4j.nn.layers.convolution.ConvolutionHelper;
import org.deeplearning4j.nn.layers.mkldnn.BaseMKLDNNHelper;
import org.deeplearning4j.nn.workspace.ArrayType;
import org.deeplearning4j.nn.workspace.LayerWorkspaceMgr;
import org.deeplearning4j.util.ConvolutionUtils;
import org.nd4j.linalg.activations.IActivation;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.CustomOp;
import org.nd4j.linalg.api.ops.OpContext;
import org.nd4j.linalg.api.ops.impl.layers.convolution.Conv2D;
import org.nd4j.linalg.api.ops.impl.layers.convolution.Conv2DDerivative;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.primitives.Pair;
import org.nd4j.linalg.util.ArrayUtil;

public class MKLDNNConvHelper
implements ConvolutionHelper {
    protected OpContext context;
    protected OpContext contextBwd;

    public MKLDNNConvHelper(DataType dataType) {
    }

    @Override
    public boolean checkSupported() {
        return BaseMKLDNNHelper.mklDnnEnabled();
    }

    @Override
    public Pair<Gradient, INDArray> backpropGradient(INDArray input, INDArray weights, INDArray bias, INDArray delta, int[] kernel, int[] strides, int[] pad, INDArray biasGradView, INDArray weightGradView, IActivation afn, ConvolutionLayer.AlgoMode mode, ConvolutionLayer.BwdFilterAlgo bwdFilterAlgo, ConvolutionLayer.BwdDataAlgo bwdDataAlgo, ConvolutionMode convolutionMode, int[] dilation, LayerWorkspaceMgr workspaceMgr) {
        int i;
        INDArray[] iNDArrayArray;
        INDArray[] iNDArrayArray2;
        if (input.dataType() != DataType.FLOAT || weights.dataType() != DataType.FLOAT) {
            return null;
        }
        INDArray weightsPermute = weights.permute(new int[]{2, 3, 1, 0});
        INDArray weightGradViewPermute = weightGradView.permute(new int[]{2, 3, 1, 0});
        if (convolutionMode == ConvolutionMode.Same) {
            pad = ConvolutionUtils.getSameModeTopLeftPadding(new int[]{(int)delta.size(2), (int)delta.size(3)}, new int[]{(int)input.size(2), (int)input.size(3)}, kernel, strides, dilation);
        }
        if (this.contextBwd == null) {
            this.contextBwd = Nd4j.getExecutioner().buildContext();
            this.contextBwd.setIArguments(new long[]{kernel[0], kernel[1], strides[0], strides[1], pad[0], pad[1], dilation[0], dilation[1], ArrayUtil.fromBoolean((convolutionMode == ConvolutionMode.Same ? 1 : 0) != 0), 0L});
        }
        INDArray gradAtInput = workspaceMgr.createUninitialized(ArrayType.ACTIVATION_GRAD, input.dataType(), input.shape());
        if (biasGradView == null) {
            INDArray[] iNDArrayArray3 = new INDArray[3];
            iNDArrayArray3[0] = input;
            iNDArrayArray3[1] = weightsPermute;
            iNDArrayArray2 = iNDArrayArray3;
            iNDArrayArray3[2] = delta;
        } else {
            INDArray[] iNDArrayArray4 = new INDArray[4];
            iNDArrayArray4[0] = input;
            iNDArrayArray4[1] = weightsPermute;
            iNDArrayArray4[2] = bias;
            iNDArrayArray2 = iNDArrayArray4;
            iNDArrayArray4[3] = delta;
        }
        INDArray[] inputsArr = iNDArrayArray2;
        if (biasGradView == null) {
            INDArray[] iNDArrayArray5 = new INDArray[2];
            iNDArrayArray5[0] = gradAtInput;
            iNDArrayArray = iNDArrayArray5;
            iNDArrayArray5[1] = weightGradViewPermute;
        } else {
            INDArray[] iNDArrayArray6 = new INDArray[3];
            iNDArrayArray6[0] = gradAtInput;
            iNDArrayArray6[1] = weightGradViewPermute;
            iNDArrayArray = iNDArrayArray6;
            iNDArrayArray6[2] = biasGradView;
        }
        INDArray[] outputArr = iNDArrayArray;
        this.contextBwd.getInputArrays().clear();
        this.contextBwd.getOutputArrays().clear();
        for (i = 0; i < inputsArr.length; ++i) {
            this.contextBwd.setInputArray(i, inputsArr[i]);
        }
        for (i = 0; i < outputArr.length; ++i) {
            this.contextBwd.setOutputArray(i, outputArr[i]);
        }
        Conv2DDerivative op = new Conv2DDerivative();
        Nd4j.exec((CustomOp)op, (OpContext)this.contextBwd);
        this.contextBwd.getInputArrays().clear();
        this.contextBwd.getOutputArrays().clear();
        DefaultGradient g = new DefaultGradient();
        if (biasGradView != null) {
            g.gradientForVariable().put("b", biasGradView);
        }
        g.gradientForVariable().put("W", weightGradView);
        return new Pair((Object)g, (Object)gradAtInput);
    }

    @Override
    public INDArray preOutput(INDArray input, INDArray weights, INDArray bias, int[] kernel, int[] strides, int[] pad, ConvolutionLayer.AlgoMode mode, ConvolutionLayer.FwdAlgo fwdAlgo, ConvolutionMode convolutionMode, int[] dilation, LayerWorkspaceMgr workspaceMgr) {
        INDArray[] iNDArrayArray;
        int[] outSize;
        if (input.dataType() != DataType.FLOAT || weights.dataType() != DataType.FLOAT) {
            return null;
        }
        int inH = (int)input.size(2);
        int inW = (int)input.size(3);
        if (convolutionMode == ConvolutionMode.Same) {
            outSize = ConvolutionUtils.getOutputSize(input, kernel, strides, null, convolutionMode, dilation);
            pad = ConvolutionUtils.getSameModeTopLeftPadding(outSize, new int[]{inH, inW}, kernel, strides, dilation);
        } else {
            outSize = ConvolutionUtils.getOutputSize(input, kernel, strides, pad, convolutionMode, dilation);
        }
        if (this.context == null) {
            this.context = Nd4j.getExecutioner().buildContext();
            this.context.setIArguments(new long[]{kernel[0], kernel[1], strides[0], strides[1], pad[0], pad[1], dilation[0], dilation[1], ArrayUtil.fromBoolean((convolutionMode == ConvolutionMode.Same ? 1 : 0) != 0), 0L});
        }
        int outDepth = (int)weights.size(0);
        INDArray out = workspaceMgr.createUninitialized(ArrayType.ACTIVATIONS, input.dataType(), new long[]{input.size(0), outDepth, outSize[0], outSize[1]});
        weights = weights.permute(new int[]{2, 3, 1, 0});
        if (bias == null) {
            INDArray[] iNDArrayArray2 = new INDArray[2];
            iNDArrayArray2[0] = input;
            iNDArrayArray = iNDArrayArray2;
            iNDArrayArray2[1] = weights;
        } else {
            INDArray[] iNDArrayArray3 = new INDArray[3];
            iNDArrayArray3[0] = input;
            iNDArrayArray3[1] = weights;
            iNDArrayArray = iNDArrayArray3;
            iNDArrayArray3[2] = bias;
        }
        INDArray[] inputsArr = iNDArrayArray;
        this.context.getInputArrays().clear();
        for (int i = 0; i < inputsArr.length; ++i) {
            this.context.setInputArray(i, inputsArr[i]);
        }
        this.context.getOutputArrays().clear();
        this.context.setOutputArray(0, out);
        Conv2D op = new Conv2D();
        Nd4j.exec((CustomOp)op, (OpContext)this.context);
        this.context.getInputArrays().clear();
        this.context.getOutputArrays().clear();
        return out;
    }

    @Override
    public INDArray activate(INDArray z, IActivation afn, boolean training) {
        return afn.getActivation(z, training);
    }

    @Override
    public Map<String, Long> helperMemoryUse() {
        return Collections.emptyMap();
    }
}

