/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.layers.convolution;

import java.util.Arrays;
import org.deeplearning4j.exception.DL4JInvalidInputException;
import org.deeplearning4j.nn.api.Layer;
import org.deeplearning4j.nn.api.MaskState;
import org.deeplearning4j.nn.conf.CacheMode;
import org.deeplearning4j.nn.conf.ConvolutionMode;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.gradient.DefaultGradient;
import org.deeplearning4j.nn.gradient.Gradient;
import org.deeplearning4j.nn.layers.BaseLayer;
import org.deeplearning4j.nn.layers.LayerHelper;
import org.deeplearning4j.nn.layers.convolution.ConvolutionHelper;
import org.deeplearning4j.nn.layers.mkldnn.MKLDNNConvHelper;
import org.deeplearning4j.nn.workspace.ArrayType;
import org.deeplearning4j.nn.workspace.LayerWorkspaceMgr;
import org.deeplearning4j.util.ConvolutionUtils;
import org.nd4j.linalg.activations.IActivation;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.memory.MemoryWorkspace;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.shape.Shape;
import org.nd4j.linalg.convolution.Convolution;
import org.nd4j.linalg.exception.ND4JOpProfilerException;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.primitives.Pair;
import org.nd4j.util.OneTimeLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConvolutionLayer
extends BaseLayer<org.deeplearning4j.nn.conf.layers.ConvolutionLayer> {
    protected static final Logger log = LoggerFactory.getLogger(ConvolutionLayer.class);
    protected INDArray i2d;
    protected ConvolutionHelper helper = null;
    protected int helperCountFail = 0;
    protected ConvolutionMode convolutionMode;
    protected transient INDArray dummyBias;
    protected transient INDArray dummyBiasGrad;

    public ConvolutionLayer(NeuralNetConfiguration conf, DataType dataType) {
        super(conf, dataType);
        this.initializeHelper();
        this.convolutionMode = ((org.deeplearning4j.nn.conf.layers.ConvolutionLayer)this.conf().getLayer()).getConvolutionMode();
    }

    void initializeHelper() {
        block8: {
            String backend = Nd4j.getExecutioner().getEnvironmentInformation().getProperty("backend");
            if ("CUDA".equalsIgnoreCase(backend)) {
                try {
                    this.helper = Class.forName("org.deeplearning4j.nn.layers.convolution.CudnnConvolutionHelper").asSubclass(ConvolutionHelper.class).getConstructor(DataType.class).newInstance(this.dataType);
                    log.debug("CudnnConvolutionHelper successfully initialized");
                    if (!this.helper.checkSupported()) {
                        this.helper = null;
                    }
                }
                catch (Throwable t) {
                    if (!(t instanceof ClassNotFoundException)) {
                        log.warn("Could not initialize CudnnConvolutionHelper", t);
                        break block8;
                    }
                    OneTimeLogger.info((Logger)log, (String)"cuDNN not found: use cuDNN for better GPU performance by including the deeplearning4j-cuda module. For more information, please refer to: https://deeplearning4j.org/docs/latest/deeplearning4j-config-cudnn", (Object[])new Object[]{t});
                }
            } else if ("CPU".equalsIgnoreCase(backend)) {
                this.helper = new MKLDNNConvHelper(this.dataType);
                log.trace("Created MKLDNNConvHelper, layer {}", (Object)((org.deeplearning4j.nn.conf.layers.ConvolutionLayer)this.layerConf()).getLayerName());
            }
        }
        if (this.helper != null && !this.helper.checkSupported()) {
            log.debug("Removed helper {} as not supported", this.helper.getClass());
            this.helper = null;
        }
    }

    @Override
    public Layer.Type type() {
        return Layer.Type.CONVOLUTIONAL;
    }

    @Override
    public Pair<Gradient, INDArray> backpropGradient(INDArray epsilon, LayerWorkspaceMgr workspaceMgr) {
        int[] pad;
        int[] outSize;
        this.assertInputSet(true);
        INDArray weights = this.getParamWithNoise("W", true, workspaceMgr);
        INDArray bias = this.getParamWithNoise("b", true, workspaceMgr);
        INDArray input = this.input.castTo(this.dataType);
        if (epsilon.dataType() != this.dataType) {
            epsilon = epsilon.castTo(this.dataType);
        }
        int miniBatch = (int)input.size(0);
        int inH = (int)input.size(2);
        int inW = (int)input.size(3);
        int outDepth = (int)weights.size(0);
        int inDepth = (int)weights.size(1);
        int kH = (int)weights.size(2);
        int kW = (int)weights.size(3);
        int[] dilation = ((org.deeplearning4j.nn.conf.layers.ConvolutionLayer)this.layerConf()).getDilation();
        int[] kernel = ((org.deeplearning4j.nn.conf.layers.ConvolutionLayer)this.layerConf()).getKernelSize();
        int[] strides = ((org.deeplearning4j.nn.conf.layers.ConvolutionLayer)this.layerConf()).getStride();
        if (this.convolutionMode == ConvolutionMode.Same) {
            outSize = ConvolutionUtils.getOutputSize(input, kernel, strides, null, this.convolutionMode, dilation);
            pad = ConvolutionUtils.getSameModeTopLeftPadding(outSize, new int[]{inH, inW}, kernel, strides, dilation);
        } else {
            pad = ((org.deeplearning4j.nn.conf.layers.ConvolutionLayer)this.layerConf()).getPadding();
            outSize = ConvolutionUtils.getOutputSize(input, kernel, strides, pad, this.convolutionMode, dilation);
        }
        int outH = outSize[0];
        int outW = outSize[1];
        INDArray biasGradView = (INDArray)this.gradientViews.get("b");
        INDArray weightGradView = (INDArray)this.gradientViews.get("W");
        INDArray weightGradView2df = Shape.newShapeNoCopy((INDArray)weightGradView, (int[])new int[]{outDepth, inDepth * kH * kW}, (boolean)false).transpose();
        IActivation afn = ((org.deeplearning4j.nn.conf.layers.ConvolutionLayer)this.layerConf()).getActivationFn();
        Pair<INDArray, INDArray> p = this.preOutput4d(true, true, workspaceMgr);
        INDArray delta = (INDArray)afn.backprop((INDArray)p.getFirst(), epsilon).getFirst();
        if (!(this.helper == null || this.helperCountFail != 0 && ((org.deeplearning4j.nn.conf.layers.ConvolutionLayer)this.layerConf()).isCudnnAllowFallback())) {
            if (!this.hasBias() && !(this.helper instanceof MKLDNNConvHelper)) {
                if (this.dummyBiasGrad == null) {
                    try (MemoryWorkspace wsO = Nd4j.getMemoryManager().scopeOutOfWorkspaces();){
                        this.dummyBiasGrad = Nd4j.create((long[])new long[]{1L, ((org.deeplearning4j.nn.conf.layers.ConvolutionLayer)this.layerConf()).getNOut()});
                    }
                }
                biasGradView = this.dummyBiasGrad;
            }
            Pair<Gradient, INDArray> ret = null;
            try {
                ret = this.helper.backpropGradient(input, weights, bias, delta, kernel, strides, pad, biasGradView, weightGradView, afn, ((org.deeplearning4j.nn.conf.layers.ConvolutionLayer)this.layerConf()).getCudnnAlgoMode(), ((org.deeplearning4j.nn.conf.layers.ConvolutionLayer)this.layerConf()).getCudnnBwdFilterAlgo(), ((org.deeplearning4j.nn.conf.layers.ConvolutionLayer)this.layerConf()).getCudnnBwdDataAlgo(), this.convolutionMode, dilation, workspaceMgr);
            }
            catch (ND4JOpProfilerException e) {
                throw e;
            }
            catch (Exception e) {
                if (e.getMessage().contains("Failed to allocate")) {
                    throw e;
                }
                if (((org.deeplearning4j.nn.conf.layers.ConvolutionLayer)this.layerConf()).isCudnnAllowFallback()) {
                    ++this.helperCountFail;
                    if (this.helper instanceof MKLDNNConvHelper) {
                        log.warn("MKL-DNN execution failed - falling back on built-in implementation", (Throwable)e);
                    } else {
                        log.warn("CuDNN execution failed - falling back on built-in implementation", (Throwable)e);
                    }
                }
                throw new RuntimeException("Error during ConvolutionLayer MKL/CuDNN helper backprop - isCudnnAllowFallback() is set to false", e);
            }
            if (ret != null) {
                INDArray gradPostDropout = (INDArray)ret.getRight();
                gradPostDropout = this.backpropDropOutIfPresent(gradPostDropout);
                ret.setSecond((Object)gradPostDropout);
                return ret;
            }
        }
        delta = delta.permute(new int[]{1, 0, 2, 3});
        INDArray delta2d = delta.reshape('c', new int[]{outDepth, miniBatch * outH * outW});
        INDArray im2col2d = (INDArray)p.getSecond();
        if (im2col2d == null) {
            INDArray col = Nd4j.createUninitialized((DataType)this.dataType, (long[])new long[]{miniBatch, outH, outW, inDepth, kH, kW}, (char)'c');
            INDArray col2 = col.permute(new int[]{0, 3, 4, 5, 1, 2});
            Convolution.im2col((INDArray)input, (int)kH, (int)kW, (int)strides[0], (int)strides[1], (int)pad[0], (int)pad[1], (int)dilation[0], (int)dilation[1], (this.convolutionMode == ConvolutionMode.Same ? 1 : 0) != 0, (INDArray)col2);
            im2col2d = col.reshape('c', miniBatch * outH * outW, inDepth * kH * kW);
        }
        Nd4j.gemm((INDArray)im2col2d, (INDArray)delta2d, (INDArray)weightGradView2df, (boolean)true, (boolean)true, (double)1.0, (double)0.0);
        INDArray wPermuted = weights.permute(new int[]{3, 2, 1, 0});
        INDArray w2d = wPermuted.reshape('f', inDepth * kH * kW, outDepth);
        INDArray epsNext2d = w2d.mmul(delta2d);
        INDArray eps6d = Shape.newShapeNoCopy((INDArray)epsNext2d, (int[])new int[]{kW, kH, inDepth, outW, outH, miniBatch}, (boolean)true);
        eps6d = eps6d.permute(new int[]{5, 2, 1, 0, 4, 3});
        INDArray epsNextOrig = workspaceMgr.createUninitialized(ArrayType.ACTIVATION_GRAD, eps6d.dataType(), new long[]{inDepth, miniBatch, inH, inW}, 'c');
        INDArray epsNext = epsNextOrig.permute(new int[]{1, 0, 2, 3});
        Convolution.col2im((INDArray)eps6d, (INDArray)epsNext, (int)strides[0], (int)strides[1], (int)pad[0], (int)pad[1], (int)inH, (int)inW, (int)dilation[0], (int)dilation[1]);
        DefaultGradient retGradient = new DefaultGradient();
        if (((org.deeplearning4j.nn.conf.layers.ConvolutionLayer)this.layerConf()).hasBias()) {
            delta2d.sum(biasGradView, new int[]{1});
            retGradient.setGradientFor("b", biasGradView);
        }
        retGradient.setGradientFor("W", weightGradView, Character.valueOf('c'));
        this.weightNoiseParams.clear();
        epsNext = this.backpropDropOutIfPresent(epsNext);
        return new Pair((Object)retGradient, (Object)epsNext);
    }

    protected Pair<INDArray, INDArray> preOutput4d(boolean training, boolean forBackprop, LayerWorkspaceMgr workspaceMgr) {
        return this.preOutput(training, forBackprop, workspaceMgr);
    }

    protected void validateInputRank() {
        if (this.input.rank() != 4) {
            String layerName = this.conf.getLayer().getLayerName();
            if (layerName == null) {
                layerName = "(not named)";
            }
            throw new DL4JInvalidInputException("Got rank " + this.input.rank() + " array as input to ConvolutionLayer (layer name = " + layerName + ", layer index = " + this.index + ") with shape " + Arrays.toString(this.input.shape()) + ". Expected rank 4 array with shape [minibatchSize, layerInputDepth, inputHeight, inputWidth]." + (this.input.rank() == 2 ? " (Wrong input type (see InputType.convolutionalFlat()) or wrong data type?)" : "") + " " + this.layerId());
        }
    }

    protected void validateInputDepth(int inDepth) {
        if (this.input.size(1) != (long)inDepth) {
            String layerName = this.conf.getLayer().getLayerName();
            if (layerName == null) {
                layerName = "(not named)";
            }
            throw new DL4JInvalidInputException("Cannot do forward pass in Convolution layer (layer name = " + layerName + ", layer index = " + this.index + "): input array channels does not match CNN layer configuration (data input channels = " + this.input.size(1) + ", [minibatch,inputDepth,height,width]=" + Arrays.toString(this.input.shape()) + "; expected input channels = " + inDepth + ") " + this.layerId());
        }
    }

    protected Pair<INDArray, INDArray> preOutput(boolean training, boolean forBackprop, LayerWorkspaceMgr workspaceMgr) {
        int[] pad;
        int[] outSize;
        this.assertInputSet(false);
        INDArray bias = this.getParamWithNoise("b", training, workspaceMgr);
        INDArray weights = this.getParamWithNoise("W", training, workspaceMgr);
        this.validateInputRank();
        INDArray input = this.input.castTo(this.dataType);
        int miniBatch = (int)input.size(0);
        int outDepth = (int)weights.size(0);
        int inDepth = (int)weights.size(1);
        this.validateInputDepth(inDepth);
        int kH = (int)weights.size(2);
        int kW = (int)weights.size(3);
        int[] dilation = ((org.deeplearning4j.nn.conf.layers.ConvolutionLayer)this.layerConf()).getDilation();
        int[] kernel = ((org.deeplearning4j.nn.conf.layers.ConvolutionLayer)this.layerConf()).getKernelSize();
        int[] strides = ((org.deeplearning4j.nn.conf.layers.ConvolutionLayer)this.layerConf()).getStride();
        if (this.convolutionMode == ConvolutionMode.Same) {
            outSize = ConvolutionUtils.getOutputSize(input, kernel, strides, null, this.convolutionMode, dilation);
            pad = ConvolutionUtils.getSameModeTopLeftPadding(outSize, new int[]{(int)input.size(2), (int)input.size(3)}, kernel, strides, dilation);
        } else {
            pad = ((org.deeplearning4j.nn.conf.layers.ConvolutionLayer)this.layerConf()).getPadding();
            outSize = ConvolutionUtils.getOutputSize(input, kernel, strides, pad, this.convolutionMode, dilation);
        }
        int outH = outSize[0];
        int outW = outSize[1];
        if (!(this.helper == null || this.helperCountFail != 0 && ((org.deeplearning4j.nn.conf.layers.ConvolutionLayer)this.layerConf()).isCudnnAllowFallback())) {
            if (this.preOutput != null && forBackprop) {
                return new Pair((Object)this.preOutput, null);
            }
            if (!this.hasBias()) {
                if (this.dummyBias == null) {
                    try (MemoryWorkspace wsO = Nd4j.getMemoryManager().scopeOutOfWorkspaces();){
                        this.dummyBias = Nd4j.create((long[])new long[]{1L, ((org.deeplearning4j.nn.conf.layers.ConvolutionLayer)this.layerConf()).getNOut()});
                    }
                }
                bias = this.dummyBias;
            }
            INDArray ret = null;
            try {
                ret = this.helper.preOutput(input, weights, bias, kernel, strides, pad, ((org.deeplearning4j.nn.conf.layers.ConvolutionLayer)this.layerConf()).getCudnnAlgoMode(), ((org.deeplearning4j.nn.conf.layers.ConvolutionLayer)this.layerConf()).getCudnnFwdAlgo(), this.convolutionMode, dilation, workspaceMgr);
            }
            catch (ND4JOpProfilerException e) {
                throw e;
            }
            catch (Exception e) {
                if (e.getMessage() != null && e.getMessage().contains("Failed to allocate")) {
                    throw e;
                }
                if (((org.deeplearning4j.nn.conf.layers.ConvolutionLayer)this.layerConf()).isCudnnAllowFallback()) {
                    ++this.helperCountFail;
                    if (this.helper instanceof MKLDNNConvHelper) {
                        log.warn("MKL-DNN execution failed - falling back on built-in implementation", (Throwable)e);
                    } else {
                        log.warn("CuDNN execution failed - falling back on built-in implementation", (Throwable)e);
                    }
                }
                throw new RuntimeException("Error during ConvolutionLayer MKL/CuDNN helper forward pass - isCudnnAllowFallback() is set to false", e);
            }
            if (ret != null) {
                return new Pair((Object)ret, null);
            }
        }
        if (this.preOutput != null && this.i2d != null && forBackprop) {
            return new Pair((Object)this.preOutput, (Object)this.i2d);
        }
        INDArray col = Nd4j.createUninitialized((DataType)weights.dataType(), (long[])new long[]{miniBatch, outH, outW, inDepth, kH, kW}, (char)'c');
        INDArray col2 = col.permute(new int[]{0, 3, 4, 5, 1, 2});
        INDArray im2ColIn = input.castTo(col2.dataType());
        Convolution.im2col((INDArray)im2ColIn, (int)kH, (int)kW, (int)strides[0], (int)strides[1], (int)pad[0], (int)pad[1], (int)dilation[0], (int)dilation[1], (this.convolutionMode == ConvolutionMode.Same ? 1 : 0) != 0, (INDArray)col2);
        INDArray im2col2d = Shape.newShapeNoCopy((INDArray)col, (int[])new int[]{miniBatch * outH * outW, inDepth * kH * kW}, (boolean)false);
        INDArray permutedW = weights.permute(new int[]{3, 2, 1, 0});
        INDArray reshapedW = permutedW.reshape('f', kW * kH * inDepth, outDepth);
        INDArray z = workspaceMgr.createUninitialized(ArrayType.ACTIVATIONS, weights.dataType(), new long[]{im2col2d.size(0), reshapedW.size(1)}, 'f');
        im2col2d.mmuli(reshapedW, z);
        if (((org.deeplearning4j.nn.conf.layers.ConvolutionLayer)this.layerConf()).hasBias()) {
            z.addiRowVector(bias);
        }
        z = Shape.newShapeNoCopy((INDArray)z, (int[])new int[]{outW, outH, miniBatch, outDepth}, (boolean)true);
        z = z.permute(new int[]{2, 3, 1, 0});
        if (training && this.cacheMode != CacheMode.NONE && workspaceMgr.hasConfiguration(ArrayType.FF_CACHE) && workspaceMgr.isWorkspaceOpen(ArrayType.FF_CACHE)) {
            try (MemoryWorkspace wsB = workspaceMgr.notifyScopeBorrowed(ArrayType.FF_CACHE);){
                this.i2d = im2col2d.unsafeDuplication();
            }
        }
        return new Pair((Object)z, forBackprop ? im2col2d : null);
    }

    @Override
    public INDArray activate(boolean training, LayerWorkspaceMgr workspaceMgr) {
        if (this.input == null) {
            throw new IllegalArgumentException("Cannot perform forward pass with null input " + this.layerId());
        }
        if (this.cacheMode == null) {
            this.cacheMode = CacheMode.NONE;
        }
        this.applyDropOutIfNecessary(training, workspaceMgr);
        INDArray z = (INDArray)this.preOutput(training, false, workspaceMgr).getFirst();
        if (training && this.cacheMode != CacheMode.NONE && workspaceMgr.hasConfiguration(ArrayType.FF_CACHE) && workspaceMgr.isWorkspaceOpen(ArrayType.FF_CACHE)) {
            try (MemoryWorkspace wsB = workspaceMgr.notifyScopeBorrowed(ArrayType.FF_CACHE);){
                this.preOutput = z.unsafeDuplication();
            }
        }
        IActivation afn = ((org.deeplearning4j.nn.conf.layers.ConvolutionLayer)this.layerConf()).getActivationFn();
        if (this.helper != null && Shape.strideDescendingCAscendingF((INDArray)z) && (this.helperCountFail == 0 || !((org.deeplearning4j.nn.conf.layers.ConvolutionLayer)this.layerConf()).isCudnnAllowFallback())) {
            INDArray ret = null;
            try {
                ret = this.helper.activate(z, ((org.deeplearning4j.nn.conf.layers.ConvolutionLayer)this.layerConf()).getActivationFn(), training);
            }
            catch (ND4JOpProfilerException e) {
                throw e;
            }
            catch (Exception e) {
                if (e.getMessage() != null && e.getMessage().contains("Failed to allocate")) {
                    throw e;
                }
                if (((org.deeplearning4j.nn.conf.layers.ConvolutionLayer)this.layerConf()).isCudnnAllowFallback()) {
                    ++this.helperCountFail;
                    if (this.helper instanceof MKLDNNConvHelper) {
                        log.warn("MKL-DNN execution failed - falling back on built-in implementation", (Throwable)e);
                    } else {
                        log.warn("CuDNN execution failed - falling back on built-in implementation", (Throwable)e);
                    }
                }
                throw new RuntimeException("Error during ConvolutionLayer MKL/CuDNN helper forward pass - isCudnnAllowFallback() is set to false", e);
            }
            if (ret != null) {
                return ret;
            }
        }
        INDArray activation = afn.getActivation(z, training);
        return activation;
    }

    @Override
    public boolean hasBias() {
        return ((org.deeplearning4j.nn.conf.layers.ConvolutionLayer)this.layerConf()).hasBias();
    }

    @Override
    public boolean isPretrainLayer() {
        return false;
    }

    @Override
    public LayerHelper getHelper() {
        return this.helper;
    }

    @Override
    public void fit(INDArray input, LayerWorkspaceMgr workspaceMgr) {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public void setParams(INDArray params) {
        this.setParams(params, 'c');
    }

    @Override
    public Pair<INDArray, MaskState> feedForwardMaskArray(INDArray maskArray, MaskState currentMaskState, int minibatchSize) {
        if (maskArray == null) {
            return new Pair((Object)maskArray, (Object)currentMaskState);
        }
        INDArray outMask = ConvolutionUtils.cnn2dMaskReduction(maskArray, ((org.deeplearning4j.nn.conf.layers.ConvolutionLayer)this.layerConf()).getKernelSize(), ((org.deeplearning4j.nn.conf.layers.ConvolutionLayer)this.layerConf()).getStride(), ((org.deeplearning4j.nn.conf.layers.ConvolutionLayer)this.layerConf()).getPadding(), ((org.deeplearning4j.nn.conf.layers.ConvolutionLayer)this.layerConf()).getDilation(), ((org.deeplearning4j.nn.conf.layers.ConvolutionLayer)this.layerConf()).getConvolutionMode());
        return new Pair((Object)outMask, (Object)currentMaskState);
    }
}

