/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.graph.vertex.impl;

import org.deeplearning4j.nn.api.Layer;
import org.deeplearning4j.nn.api.MaskState;
import org.deeplearning4j.nn.gradient.Gradient;
import org.deeplearning4j.nn.graph.ComputationGraph;
import org.deeplearning4j.nn.graph.vertex.BaseGraphVertex;
import org.deeplearning4j.nn.graph.vertex.VertexIndices;
import org.deeplearning4j.nn.workspace.ArrayType;
import org.deeplearning4j.nn.workspace.LayerWorkspaceMgr;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.memory.MemoryWorkspace;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.indexing.INDArrayIndex;
import org.nd4j.linalg.indexing.NDArrayIndex;
import org.nd4j.linalg.primitives.Pair;

public class StackVertex
extends BaseGraphVertex {
    private long[][] lastInputShapes;

    public StackVertex(ComputationGraph graph, String name, int vertexIndex, DataType dataType) {
        this(graph, name, vertexIndex, null, null, dataType);
    }

    public StackVertex(ComputationGraph graph, String name, int vertexIndex, VertexIndices[] inputVertices, VertexIndices[] outputVertices, DataType dataType) {
        super(graph, name, vertexIndex, inputVertices, outputVertices, dataType);
    }

    @Override
    public boolean hasLayer() {
        return false;
    }

    @Override
    public Layer getLayer() {
        return null;
    }

    @Override
    public INDArray doForward(boolean training, LayerWorkspaceMgr workspaceMgr) {
        this.lastInputShapes = null;
        int nStack = this.inputs.length;
        long[] inShape = this.inputs[0].shape();
        long[] outShape = new long[inShape.length];
        outShape[0] = (long)nStack * inShape[0];
        for (int i = 1; i < inShape.length; ++i) {
            outShape[i] = inShape[i];
        }
        boolean variableLengthTS = false;
        if (inShape.length == 3) {
            long minLength;
            long maxLength = minLength = this.inputs[0].size(2);
            for (int i = 1; i < this.inputs.length; ++i) {
                long thisLength = this.inputs[i].size(2);
                minLength = Math.min(minLength, thisLength);
                maxLength = Math.max(maxLength, thisLength);
            }
            boolean bl = variableLengthTS = minLength != maxLength;
            if (!variableLengthTS) {
                try (MemoryWorkspace ws = workspaceMgr.notifyScopeBorrowed(ArrayType.ACTIVATIONS);){
                    INDArray iNDArray = Nd4j.concat((int)0, (INDArray[])this.inputs);
                    return iNDArray;
                }
            }
            outShape[2] = maxLength;
            INDArray out = workspaceMgr.create(ArrayType.ACTIVATIONS, this.inputs[0].dataType(), outShape);
            long numExamples = this.inputs[0].size(0);
            this.lastInputShapes = new long[this.inputs.length][0];
            for (int i = 0; i < this.inputs.length; ++i) {
                out.put(new INDArrayIndex[]{NDArrayIndex.interval((long)((long)i * numExamples), (long)((long)(i + 1) * numExamples)), NDArrayIndex.all(), NDArrayIndex.interval((long)0L, (long)this.inputs[i].size(2))}, this.inputs[i]);
                this.lastInputShapes[i] = this.inputs[i].shape();
            }
            return out;
        }
        try (MemoryWorkspace ws = workspaceMgr.notifyScopeBorrowed(ArrayType.ACTIVATIONS);){
            INDArray iNDArray = Nd4j.concat((int)0, (INDArray[])this.inputs);
            return iNDArray;
        }
    }

    @Override
    public Pair<Gradient, INDArray[]> doBackward(boolean tbptt, LayerWorkspaceMgr workspaceMgr) {
        int i;
        if (!this.canDoForward()) {
            throw new IllegalStateException("Cannot do forward pass: input not set");
        }
        if (this.epsilon == null) {
            return new Pair(null, (Object)new INDArray[this.inputs.length]);
        }
        int nStack = this.inputs.length;
        INDArray[] out = new INDArray[nStack];
        long step = this.epsilon.size(0) / (long)nStack;
        block5: for (i = 0; i < nStack; ++i) {
            switch (this.epsilon.rank()) {
                case 2: {
                    out[i] = this.epsilon.get(new INDArrayIndex[]{NDArrayIndex.interval((long)((long)i * step), (long)((long)(i + 1) * step)), NDArrayIndex.all()});
                    continue block5;
                }
                case 3: {
                    if (this.lastInputShapes != null) {
                        out[i] = this.epsilon.get(new INDArrayIndex[]{NDArrayIndex.interval((long)((long)i * step), (long)((long)(i + 1) * step)), NDArrayIndex.all(), NDArrayIndex.interval((long)0L, (long)this.lastInputShapes[i][2])});
                        continue block5;
                    }
                    out[i] = this.epsilon.get(new INDArrayIndex[]{NDArrayIndex.interval((long)((long)i * step), (long)((long)(i + 1) * step)), NDArrayIndex.all(), NDArrayIndex.all()});
                    continue block5;
                }
                case 4: {
                    out[i] = this.epsilon.get(new INDArrayIndex[]{NDArrayIndex.interval((long)((long)i * step), (long)((long)(i + 1) * step)), NDArrayIndex.all(), NDArrayIndex.all(), NDArrayIndex.all()});
                    continue block5;
                }
                default: {
                    throw new UnsupportedOperationException("Cannot get subset for activations of rank " + this.inputs[0].rank());
                }
            }
        }
        for (i = 0; i < nStack; ++i) {
            out[i] = workspaceMgr.dup(ArrayType.ACTIVATION_GRAD, out[i]);
        }
        return new Pair(null, (Object)out);
    }

    @Override
    public void setBackpropGradientsViewArray(INDArray backpropGradientsViewArray) {
        if (backpropGradientsViewArray != null) {
            throw new RuntimeException("Vertex does not have gradients; gradients view array cannot be set here");
        }
    }

    @Override
    public Pair<INDArray, MaskState> feedForwardMaskArrays(INDArray[] maskArrays, MaskState currentMaskState, int minibatchSize) {
        long size1_ex0;
        if (maskArrays == null) {
            return new Pair(null, (Object)currentMaskState);
        }
        boolean allNull = true;
        for (INDArray i : maskArrays) {
            if (i == null) continue;
            allNull = false;
            break;
        }
        if (allNull) {
            return new Pair(null, (Object)currentMaskState);
        }
        boolean allSameLength = true;
        long maxLength = size1_ex0 = maskArrays[0].size(1);
        for (int i = 1; i < maskArrays.length; ++i) {
            allSameLength &= size1_ex0 == maskArrays[i].size(1);
            maxLength = Math.max(maxLength, maskArrays[i].size(1));
        }
        if (allSameLength) {
            return new Pair((Object)Nd4j.vstack((INDArray[])maskArrays), (Object)currentMaskState);
        }
        long numExamples = maskArrays[0].size(0);
        INDArray outMask = Nd4j.create((long[])new long[]{(long)maskArrays.length * numExamples, maxLength});
        for (int i = 0; i < maskArrays.length; ++i) {
            outMask.put(new INDArrayIndex[]{NDArrayIndex.interval((long)((long)i * numExamples), (long)((long)(i + 1) * numExamples)), NDArrayIndex.interval((long)0L, (long)maskArrays[i].size(1))}, maskArrays[i]);
        }
        return new Pair((Object)outMask, (Object)currentMaskState);
    }

    @Override
    public String toString() {
        return "StackVertex(id=" + this.getVertexIndex() + ",name=\"" + this.getVertexName() + ")";
    }
}

