/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.conf.distribution;

import org.deeplearning4j.nn.conf.distribution.Distribution;
import org.nd4j.shade.jackson.annotation.JsonCreator;
import org.nd4j.shade.jackson.annotation.JsonProperty;

public class LogNormalDistribution
extends Distribution {
    private double mean;
    private double std;

    @JsonCreator
    public LogNormalDistribution(@JsonProperty(value="mean") double mean, @JsonProperty(value="std") double std) {
        this.mean = mean;
        this.std = std;
    }

    public String toString() {
        return "LogNormalDistribution(mean=" + this.mean + ", std=" + this.std + ')';
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LogNormalDistribution)) {
            return false;
        }
        LogNormalDistribution other = (LogNormalDistribution)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Double.compare(this.getMean(), other.getMean()) != 0) {
            return false;
        }
        return Double.compare(this.getStd(), other.getStd()) == 0;
    }

    protected boolean canEqual(Object other) {
        return other instanceof LogNormalDistribution;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $mean = Double.doubleToLongBits(this.getMean());
        result = result * 59 + (int)($mean >>> 32 ^ $mean);
        long $std = Double.doubleToLongBits(this.getStd());
        result = result * 59 + (int)($std >>> 32 ^ $std);
        return result;
    }

    public double getMean() {
        return this.mean;
    }

    public double getStd() {
        return this.std;
    }

    public void setMean(double mean) {
        this.mean = mean;
    }

    public void setStd(double std) {
        this.std = std;
    }
}

