/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.optimize.listeners.callbacks;

import java.io.File;
import java.io.IOException;
import lombok.NonNull;
import org.apache.commons.io.FilenameUtils;
import org.deeplearning4j.eval.IEvaluation;
import org.deeplearning4j.exception.DL4JInvalidConfigException;
import org.deeplearning4j.nn.api.Model;
import org.deeplearning4j.optimize.listeners.EvaluativeListener;
import org.deeplearning4j.optimize.listeners.callbacks.EvaluationCallback;
import org.deeplearning4j.util.ModelSerializer;

public class ModelSavingCallback
implements EvaluationCallback {
    protected File rootFolder;
    protected String template;

    public ModelSavingCallback(@NonNull String fileNameTemplate) {
        this(new File("./"), fileNameTemplate);
        if (fileNameTemplate == null) {
            throw new NullPointerException("fileNameTemplate is marked @NonNull but is null");
        }
    }

    public ModelSavingCallback(@NonNull File rootFolder, @NonNull String fileNameTemplate) {
        if (rootFolder == null) {
            throw new NullPointerException("rootFolder is marked @NonNull but is null");
        }
        if (fileNameTemplate == null) {
            throw new NullPointerException("fileNameTemplate is marked @NonNull but is null");
        }
        if (!rootFolder.isDirectory()) {
            throw new DL4JInvalidConfigException("rootFolder argument should point to valid folder");
        }
        if (fileNameTemplate.isEmpty()) {
            throw new DL4JInvalidConfigException("Filename template can't be empty String");
        }
        this.rootFolder = rootFolder;
        this.template = fileNameTemplate;
    }

    @Override
    public void call(EvaluativeListener listener, Model model, long invocationsCount, IEvaluation[] evaluations) {
        String temp = this.template.replaceAll("%d", "" + invocationsCount);
        String finalName = FilenameUtils.concat((String)this.rootFolder.getAbsolutePath(), (String)temp);
        this.save(model, finalName);
    }

    protected void save(Model model, String filename) {
        try {
            ModelSerializer.writeModel(model, filename, true);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

