/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.layers;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.deeplearning4j.eval.Evaluation;
import org.deeplearning4j.nn.api.Layer;
import org.deeplearning4j.nn.api.layers.IOutputLayer;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.gradient.DefaultGradient;
import org.deeplearning4j.nn.gradient.Gradient;
import org.deeplearning4j.nn.layers.BaseLayer;
import org.deeplearning4j.nn.workspace.ArrayType;
import org.deeplearning4j.nn.workspace.LayerWorkspaceMgr;
import org.deeplearning4j.optimize.Solver;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.dataset.api.DataSet;
import org.nd4j.linalg.dataset.api.iterator.DataSetIterator;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.lossfunctions.ILossFunction;
import org.nd4j.linalg.primitives.Pair;
import org.nd4j.linalg.util.FeatureUtil;

public class LossLayer
extends BaseLayer<org.deeplearning4j.nn.conf.layers.LossLayer>
implements Serializable,
IOutputLayer {
    protected INDArray labels;
    private transient Solver solver;
    private double fullNetworkL1;
    private double fullNetworkL2;

    public LossLayer(NeuralNetConfiguration conf) {
        super(conf);
    }

    public LossLayer(NeuralNetConfiguration conf, INDArray input) {
        super(conf, input);
    }

    @Override
    public double computeScore(double fullNetworkL1, double fullNetworkL2, boolean training, LayerWorkspaceMgr workspaceMgr) {
        if (this.input == null || this.labels == null) {
            throw new IllegalStateException("Cannot calculate score without input and labels " + this.layerId());
        }
        this.fullNetworkL1 = fullNetworkL1;
        this.fullNetworkL2 = fullNetworkL2;
        INDArray preOut = this.input;
        ILossFunction lossFunction = ((org.deeplearning4j.nn.conf.layers.LossLayer)this.layerConf()).getLossFn();
        double score = lossFunction.computeScore(this.getLabels2d(), preOut, ((org.deeplearning4j.nn.conf.layers.LossLayer)this.layerConf()).getActivationFn(), this.maskArray, false);
        score += fullNetworkL1 + fullNetworkL2;
        this.score = score /= (double)this.getInputMiniBatchSize();
        return score;
    }

    @Override
    public INDArray computeScoreForExamples(double fullNetworkL1, double fullNetworkL2, LayerWorkspaceMgr workspaceMgr) {
        if (this.input == null || this.labels == null) {
            throw new IllegalStateException("Cannot calculate score without input and labels " + this.layerId());
        }
        INDArray preOut = this.input;
        ILossFunction lossFunction = ((org.deeplearning4j.nn.conf.layers.LossLayer)this.layerConf()).getLossFn();
        INDArray scoreArray = lossFunction.computeScoreArray(this.getLabels2d(), preOut, ((org.deeplearning4j.nn.conf.layers.LossLayer)this.layerConf()).getActivationFn(), this.maskArray);
        double l1l2 = fullNetworkL1 + fullNetworkL2;
        if (l1l2 != 0.0) {
            scoreArray.addi((Number)l1l2);
        }
        return workspaceMgr.leverageTo(ArrayType.ACTIVATIONS, scoreArray);
    }

    @Override
    public void computeGradientAndScore(LayerWorkspaceMgr workspaceMgr) {
        if (this.input == null || this.labels == null) {
            return;
        }
        INDArray preOut = this.input;
        Pair<Gradient, INDArray> pair = this.getGradientsAndDelta(preOut, workspaceMgr);
        this.gradient = (Gradient)pair.getFirst();
        this.score = this.computeScore(this.fullNetworkL1, this.fullNetworkL2, true, workspaceMgr);
    }

    @Override
    protected void setScoreWithZ(INDArray z) {
        throw new RuntimeException("Not supported " + this.layerId());
    }

    @Override
    public Pair<Gradient, Double> gradientAndScore() {
        return new Pair((Object)this.gradient(), (Object)this.score());
    }

    @Override
    public Pair<Gradient, INDArray> backpropGradient(INDArray epsilon, LayerWorkspaceMgr workspaceMgr) {
        return this.getGradientsAndDelta(this.input, workspaceMgr);
    }

    private Pair<Gradient, INDArray> getGradientsAndDelta(INDArray preOut, LayerWorkspaceMgr workspaceMgr) {
        ILossFunction lossFunction = ((org.deeplearning4j.nn.conf.layers.LossLayer)this.layerConf()).getLossFn();
        INDArray delta = lossFunction.computeGradient(this.getLabels2d(), preOut, ((org.deeplearning4j.nn.conf.layers.LossLayer)this.layerConf()).getActivationFn(), this.maskArray);
        DefaultGradient gradient = new DefaultGradient();
        delta = workspaceMgr.leverageTo(ArrayType.ACTIVATION_GRAD, delta);
        return new Pair((Object)gradient, (Object)delta);
    }

    @Override
    public Gradient gradient() {
        return this.gradient;
    }

    @Override
    public double calcL2(boolean backpropParamsOnly) {
        return 0.0;
    }

    @Override
    public double calcL1(boolean backpropParamsOnly) {
        return 0.0;
    }

    @Override
    public Layer.Type type() {
        return Layer.Type.FEED_FORWARD;
    }

    @Override
    public void fit(INDArray input, LayerWorkspaceMgr workspaceMgr) {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public INDArray activate(boolean training, LayerWorkspaceMgr workspaceMgr) {
        INDArray z = this.input;
        INDArray ret = ((org.deeplearning4j.nn.conf.layers.LossLayer)this.layerConf()).getActivationFn().getActivation(z.dup(), training);
        if (this.maskArray != null) {
            ret.muliColumnVector(this.maskArray);
        }
        return workspaceMgr.leverageTo(ArrayType.ACTIVATIONS, ret);
    }

    @Override
    public INDArray activate(INDArray input, boolean training, LayerWorkspaceMgr workspaceMgr) {
        this.setInput(input, workspaceMgr);
        return this.activate(training, workspaceMgr);
    }

    @Override
    public boolean isPretrainLayer() {
        return false;
    }

    @Override
    public INDArray params() {
        return null;
    }

    @Override
    public double f1Score(DataSet data) {
        return this.f1Score(data.getFeatures(), data.getLabels());
    }

    @Override
    public double f1Score(INDArray examples, INDArray labels) {
        Evaluation eval = new Evaluation();
        eval.eval(labels, this.labelProbabilities(examples));
        return eval.f1();
    }

    @Override
    public int numLabels() {
        return (int)this.labels.size(1);
    }

    @Override
    public void fit(DataSetIterator iter) {
    }

    @Override
    public int[] predict(INDArray input) {
        INDArray output = this.activate(input, false, LayerWorkspaceMgr.noWorkspacesImmutable());
        int[] ret = new int[input.rows()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = Nd4j.getBlasWrapper().iamax(output.getRow((long)i));
        }
        return ret;
    }

    @Override
    public List<String> predict(DataSet dataSet) {
        int[] intRet = this.predict(dataSet.getFeatures());
        ArrayList<String> ret = new ArrayList<String>();
        for (int i : intRet) {
            ret.add(i, dataSet.getLabelName(i));
        }
        return ret;
    }

    @Override
    public INDArray labelProbabilities(INDArray examples) {
        return this.activate(examples, false, LayerWorkspaceMgr.noWorkspacesImmutable());
    }

    @Override
    public void fit(INDArray input, INDArray labels) {
        throw new UnsupportedOperationException("LossLayer has no parameters and cannot be fit");
    }

    @Override
    public void fit(DataSet data) {
        this.fit(data.getFeatures(), data.getLabels());
    }

    @Override
    public void fit(INDArray examples, int[] labels) {
        INDArray outcomeMatrix = FeatureUtil.toOutcomeMatrix((int[])labels, (long)this.numLabels());
        this.fit(examples, outcomeMatrix);
    }

    @Override
    public void clear() {
        super.clear();
        if (this.labels != null) {
            this.labels.data().destroy();
            this.labels = null;
        }
        this.solver = null;
    }

    @Override
    public INDArray getLabels() {
        return this.labels;
    }

    @Override
    public boolean needsLabels() {
        return true;
    }

    @Override
    public void setLabels(INDArray labels) {
        this.labels = labels;
    }

    protected INDArray getLabels2d() {
        if (this.labels.rank() > 2) {
            return this.labels.reshape(this.labels.size(2), this.labels.size(1));
        }
        return this.labels;
    }
}

